/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.SidechainTypes;
import com.horizen.backup.BackupBox;
import com.horizen.backup.BoxIterator;
import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.block.WithdrawalEpochCertificateSerializer$;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.WithdrawalRequestBoxSerializer;
import com.horizen.box.ZenBox;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.consensus.package$;
import com.horizen.forge.ForgerList;
import com.horizen.forge.ForgerListSerializer$;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.storage.StorageIterator;
import com.horizen.storage.leveldb.package$Constants$;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.BlockFeeInfo;
import com.horizen.utils.BlockFeeInfoSerializer$;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.utils.WithdrawalEpochInfoSerializer$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Optional;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u0016-\u0001MB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\")A\u000b\u0001C\u0001+\"A\u0011\f\u0001b\u0001\n\u0003q#\f\u0003\u0004b\u0001\u0001\u0006Ia\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019i\u0007\u0001)A\u0005I\"Aa\u000e\u0001b\u0001\n\u0003q#\f\u0003\u0004p\u0001\u0001\u0006Ia\u0017\u0005\ta\u0002\u0011\r\u0011\"\u0001/5\"1\u0011\u000f\u0001Q\u0001\nmC\u0001B\u001d\u0001C\u0002\u0013\u0005aF\u0017\u0005\u0007g\u0002\u0001\u000b\u0011B.\t\u000fQ\u0004!\u0019!C\u0005k\"1\u0011\u0010\u0001Q\u0001\nYDaA\u001f\u0001\u0005\u00029Z\bB\u0002@\u0001\t\u0003qs\u0010\u0003\u0005\u0002\b\u0001!\tALA\u0005\u0011!\ty\u0001\u0001b\u0001\n\u0013)\bbBA\t\u0001\u0001\u0006IA\u001e\u0005\t\u0003'\u0001A\u0011\u0001\u0018\u0002\u0016!A\u00111\u0004\u0001\u0005\u00029\ni\u0002\u0003\u0005\u0002$\u0001!\tALA\u0013\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a.\u0001\t\u0003\tI\fC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\bb\u0002B$\u0001\u0011\u0005#\u0011\n\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005'BqAa\u0018\u0001\t\u0003\u0011\t\u0007C\u0004\u0003f\u0001!\t!!/\t\u000f\t\u001d\u0004\u0001\"\u0001\u0003j!9!\u0011\u000f\u0001\u0005\u0002\tM$!F*jI\u0016\u001c\u0007.Y5o'R\fG/Z*u_J\fw-\u001a\u0006\u0003[9\nqa\u001d;pe\u0006<WM\u0003\u00020a\u00059\u0001n\u001c:ju\u0016t'\"A\u0019\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001!$H\u0011$\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0003vi&d'\"A \u0002\rM\u001cwN]3y\u0013\t\tEHA\u0007TG>\u0014X\r\u001f'pO\u001eLgn\u001a\t\u0003\u0007\u0012k\u0011\u0001L\u0005\u0003\u000b2\u0012AcU5eK\u000eD\u0017-\u001b8Ti>\u0014\u0018mZ3J]\u001a|\u0007CA$I\u001b\u0005q\u0013BA%/\u00059\u0019\u0016\u000eZ3dQ\u0006Lg\u000eV=qKN\u0004\"aQ&\n\u00051c#aB*u_J\fw-Z\u0001\u0018g&$Wm\u00195bS:\u0014u\u000e_3t\u0007>l\u0007/\u00198j_:\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0018\u0002\u0013\r|W\u000e]1oS>t\u0017BA*Q\u0005]\u0019\u0016\u000eZ3dQ\u0006LgNQ8yKN\u001cu.\u001c9b]&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004-^C\u0006CA\"\u0001\u0011\u0015i3\u00011\u0001K\u0011\u0015i5\u00011\u0001O\u0003u9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4pe6\fG/[8o\u0017\u0016LX#A.\u0011\u0005q{V\"A/\u000b\u0005ys\u0013!B;uS2\u001c\u0018B\u00011^\u0005A\u0011\u0015\u0010^3BeJ\f\u0017p\u0016:baB,'/\u0001\u0010xSRDGM]1xC2,\u0005o\\2i\u0013:4wN]7bi&|gnS3zA\u0005Yr/\u001b;iIJ\fw/\u00197SKF,Xm\u001d;TKJL\u0017\r\\5{KJ,\u0012\u0001\u001a\t\u00049\u0016<\u0017B\u00014^\u00059a\u0015n\u001d;TKJL\u0017\r\\5{KJ\u0004\"\u0001[6\u000e\u0003%T!A\u001b\u0018\u0002\u0007\t|\u00070\u0003\u0002mS\n!r+\u001b;iIJ\fw/\u00197SKF,Xm\u001d;C_b\fAd^5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%A\td_:\u001cXM\\:vg\u0016\u0003xn\u00195LKf\f!cY8og\u0016t7/^:Fa>\u001c\u0007nS3zA\u0005y1-Z1tS:<7\u000b^1uK.+\u00170\u0001\tdK\u0006\u001c\u0018N\\4Ti\u0006$XmS3zA\u0005\u0011bm\u001c:hKJd\u0015n\u001d;J]\u0012,\u0007pS3z\u0003M1wN]4fe2K7\u000f^%oI\u0016D8*Z=!\u0003})h\u000eZ3gS:,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM]\u000b\u0002mB\u0011Qg^\u0005\u0003qZ\u00121!\u00138u\u0003\u0001*h\u000eZ3gS:,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM\u001d\u0011\u00029\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM]&fsR\u00111\f \u0005\u0006{B\u0001\rA^\u0001\u0010o&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u0006Ar-\u001a;XSRDGM]1xC2\u0014V-];fgR\u001c8*Z=\u0015\u000bm\u000b\t!a\u0001\t\u000bu\f\u0002\u0019\u0001<\t\r\u0005\u0015\u0011\u00031\u0001w\u0003\u001d\u0019w.\u001e8uKJ\f1dZ3u)>\u0004\u0018+^1mSRL8)\u001a:uS\u001aL7-\u0019;f\u0017\u0016LHcA.\u0002\f!1\u0011Q\u0002\nA\u0002Y\f\u0011D]3gKJ,gnY3e/&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u0006aRO\u001c3fM&tW\r\u001a\"m_\u000e\\g)Z3J]\u001a|7i\\;oi\u0016\u0014\u0018!H;oI\u00164\u0017N\\3e\u00052|7m\u001b$fK&sgm\\\"pk:$XM\u001d\u0011\u00023\u001d,GO\u00117pG.4U-Z%oM>\u001cu.\u001e8uKJ\\U-\u001f\u000b\u00047\u0006]\u0001BBA\r+\u0001\u0007a/A\u000bxSRDGM]1xC2,\u0005o\\2i\u001dVl'-\u001a:\u0002%\u001d,GO\u00117pG.4U-Z%oM>\\U-\u001f\u000b\u00067\u0006}\u0011\u0011\u0005\u0005\u0007\u000331\u0002\u0019\u0001<\t\r\u0005\u0015a\u00031\u0001w\u0003a9W\r^+uq>lUM]6mKR\u0013X-\u001a*p_R\\U-\u001f\u000b\u00047\u0006\u001d\u0002BBA\r/\u0001\u0007a/\u0001\u0004hKR\u0014u\u000e\u001f\u000b\u0005\u0003[\t)\u0005E\u00036\u0003_\t\u0019$C\u0002\u00022Y\u0012aa\u00149uS>t\u0007#\u00025\u00026\u0005e\u0012bAA\u001cS\n\u0019!i\u001c=\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010/\u0003-\u0001(o\u001c9pg&$\u0018n\u001c8\n\t\u0005\r\u0013Q\b\u0002\f!J|\u0007o\\:ji&|g\u000eC\u0004\u0002Ha\u0001\r!!\u0013\u0002\u000b\t|\u00070\u00133\u0011\u000bU\nY%a\u0014\n\u0007\u00055cGA\u0003BeJ\f\u0017\u0010E\u00026\u0003#J1!a\u00157\u0005\u0011\u0011\u0015\u0010^3\u0002-\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[%oM>,\"!!\u0017\u0011\u000bU\ny#a\u0017\u0011\u0007q\u000bi&C\u0002\u0002`u\u00131cV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[%oM>\f\u0011dZ3u/&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u000e{WO\u001c;feR\u0019a/!\u001a\t\r\u0005\u001d$\u00041\u0001w\u0003\u0015)\u0007o\\2i\u0003Y9W\r\u001e\"m_\u000e\\g)Z3J]\u001a|7i\\;oi\u0016\u0014Hc\u0001<\u0002n!1\u0011\u0011D\u000eA\u0002Y\fabZ3u\r\u0016,\u0007+Y=nK:$8\u000f\u0006\u0003\u0002t\u0005E\u0005CBA;\u0003\u000b\u000bYI\u0004\u0003\u0002x\u0005\u0005e\u0002BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005u$'\u0001\u0004=e>|GOP\u0005\u0002o%\u0019\u00111\u0011\u001c\u0002\u000fA\f7m[1hK&!\u0011qQAE\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u00073\u0004c\u0001/\u0002\u000e&\u0019\u0011qR/\u0003\u0019\tcwnY6GK\u0016LeNZ8\t\r\u0005eA\u00041\u0001w\u0003U9W\r^,ji\"$'/Y<bYJ+\u0017/^3tiN$B!a&\u0002\u001aB)\u0011QOACO\")Q0\ba\u0001m\u0006Ar-\u001a;U_B\fV/\u00197jif\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015\t\u0005}\u0015Q\u0016\t\u0006k\u0005=\u0012\u0011\u0015\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011q\u0015\u0018\u0002\u000b\tdwnY6\n\t\u0005-\u0016Q\u0015\u0002\u001b/&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u000e+'\u000f^5gS\u000e\fG/\u001a\u0005\u0007\u0003\u001bq\u0002\u0019\u0001<\u0002+\u001d,G/\u0016;y_6+'o\u001b7f)J,WMU8piR!\u00111WA[!\u0015)\u0014qFA%\u0011\u0015ix\u00041\u0001w\u0003%A\u0017m]\"fCN,G-\u0006\u0002\u0002<B\u0019Q'!0\n\u0007\u0005}fGA\u0004C_>dW-\u00198\u0002/\u001d,GoQ8og\u0016t7/^:Fa>\u001c\u0007NT;nE\u0016\u0014XCAAc!\u0015)\u0014qFAd!\u0011\tI-!8\u000f\t\u0005-\u0017\u0011\u001c\b\u0005\u0003\u001b\f)N\u0004\u0003\u0002P\u0006Mg\u0002BA=\u0003#L\u0011!M\u0005\u0003_AJ1!a6/\u0003%\u0019wN\\:f]N,8/\u0003\u0003\u0002\u0004\u0006m'bAAl]%!\u0011q\\Aq\u0005Q\u0019uN\\:f]N,8/\u00129pG\"tU/\u001c2fe*!\u00111QAn\u000359W\r\u001e$pe\u001e,'\u000fT5tiV\u0011\u0011q\u001d\t\u0006k\u0005=\u0012\u0011\u001e\t\u0005\u0003W\f\t0\u0004\u0002\u0002n*\u0019\u0011q\u001e\u0018\u0002\u000b\u0019|'oZ3\n\t\u0005M\u0018Q\u001e\u0002\u000b\r>\u0014x-\u001a:MSN$\u0018AB;qI\u0006$X\r\u0006\u000e\u0002z\n\r!q\u0001B\u0006\u0005?\u0011)C!\u000b\u0003.\tE\"Q\u0007B\u001d\u0005{\u0011\u0019\u0005E\u0003\u0002|\u0006}h+\u0004\u0002\u0002~*\u0011QHN\u0005\u0005\u0005\u0003\tiPA\u0002UefDaA!\u0002$\u0001\u0004Y\u0016a\u0002<feNLwN\u001c\u0005\b\u0005\u0013\u0019\u0003\u0019AA.\u0003M9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p\u0011\u001d\u0011ia\ta\u0001\u0005\u001f\tQBY8y+B$\u0017\r^3MSN$\bC\u0002B\t\u00053\t\u0019D\u0004\u0003\u0003\u0014\tU\u0001cAA=m%\u0019!q\u0003\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011YB!\b\u0003\u0007M+GOC\u0002\u0003\u0018YBqA!\t$\u0001\u0004\u0011\u0019#A\bc_bLEm\u001d*f[>4XmU3u!\u0015\u0011\tB!\u0007\\\u0011\u001d\u00119c\ta\u0001\u0003/\u000b!d^5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:u\u0003B\u0004XM\u001c3TKFDqAa\u000b$\u0001\u0004\t9-\u0001\bd_:\u001cXM\\:vg\u0016\u0003xn\u00195\t\u000f\t=2\u00051\u0001\u0002 \u0006ABo\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,w\n\u001d;\t\u000f\tM2\u00051\u0001\u0002\f\u0006a!\r\\8dW\u001a+W-\u00138g_\"9!qG\u0012A\u0002\u0005M\u0016!F;uq>lUM]6mKR\u0013X-\u001a*p_R|\u0005\u000f\u001e\u0005\b\u0005w\u0019\u0003\u0019AA^\u0003-\u00198\rS1t\u0007\u0016\f7/\u001a3\t\u000f\t}2\u00051\u0001\u0003B\u0005\tbm\u001c:hKJd\u0015n\u001d;J]\u0012,\u00070Z:\u0011\tU\nYE\u001e\u0005\u0007\u0005\u000b\u001a\u0003\u0019\u0001<\u0002\u001d\u0019|'oZ3s\u0019&\u001cHoU5{K\u0006iA.Y:u-\u0016\u00148/[8o\u0013\u0012,\"Aa\u0013\u0011\tU\nycW\u0001\u0011e>dGNY1dWZ+'o]5p]N$\"A!\u0015\u0011\u000b\u0005U\u0014QQ.\u0015\t\tU#1\f\t\u0006\u0003k\u00129fW\u0005\u0005\u00053\nII\u0001\u0003MSN$\bB\u0002B/M\u0001\u0007a/A\nnCbtU/\u001c2fe>3g+\u001a:tS>t7/\u0001\u0005s_2d'-Y2l)\u0011\tIPa\u0019\t\r\t\u0015q\u00051\u0001\\\u0003\u001dI7/R7qif\f1bZ3u\u0013R,'/\u0019;peV\u0011!1\u000e\t\u0004\u0007\n5\u0014b\u0001B8Y\ty1\u000b^8sC\u001e,\u0017\n^3sCR|'/A\u0007sKN$xN]3CC\u000e\\W\u000f\u001d\u000b\u0007\u0005k\u0012YHa#\u0011\u0007U\u00129(C\u0002\u0003zY\u0012A!\u00168ji\"9!Q\u0010\u0016A\u0002\t}\u0014\u0001\u00072bG.,\bo\u0015;pe\u0006<WMQ8y\u0013R,'/\u0019;peB!!\u0011\u0011BD\u001b\t\u0011\u0019IC\u0002\u0003\u0006:\naAY1dWV\u0004\u0018\u0002\u0002BE\u0005\u0007\u00131BQ8y\u0013R,'/\u0019;pe\"9!Q\u0012\u0016A\u0002\u0005%\u0013a\u00037bgR4VM]:j_:\u0004")
public class SidechainStateStorage
implements ScorexLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final ByteArrayWrapper withdrawalEpochInformationKey;
    private final ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer;
    private final ByteArrayWrapper consensusEpochKey;
    private final ByteArrayWrapper ceasingStateKey;
    private final ByteArrayWrapper forgerListIndexKey;
    private final int undefinedWithdrawalEpochCounter;
    private final int undefinedBlockFeeInfoCounter;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper withdrawalEpochInformationKey() {
        return this.withdrawalEpochInformationKey;
    }

    private ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer() {
        return this.withdrawalRequestSerializer;
    }

    public ByteArrayWrapper consensusEpochKey() {
        return this.consensusEpochKey;
    }

    public ByteArrayWrapper ceasingStateKey() {
        return this.ceasingStateKey;
    }

    public ByteArrayWrapper forgerListIndexKey() {
        return this.forgerListIndexKey;
    }

    private int undefinedWithdrawalEpochCounter() {
        return this.undefinedWithdrawalEpochCounter;
    }

    public ByteArrayWrapper getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getWithdrawalRequestsKey(int withdrawalEpoch, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getTopQualityCertificateKey(int referencedWithdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"topQualityCertificate".getBytes(), Ints.toByteArray((int)referencedWithdrawalEpoch)}));
    }

    private int undefinedBlockFeeInfoCounter() {
        return this.undefinedBlockFeeInfoCounter;
    }

    public ByteArrayWrapper getBlockFeeInfoCounterKey(int withdrawalEpochNumber) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfoCounter".getBytes(), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public ByteArrayWrapper getBlockFeeInfoKey(int withdrawalEpochNumber, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfo".getBytes(), Ints.toByteArray((int)withdrawalEpochNumber), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getUtxoMerkleTreeRootKey(int withdrawalEpochNumber) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"utxoMerkleTreeRoot".getBytes(), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public Option<Box<Proposition>> getBox(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainBoxesCompanion.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Box box = (Box)success.value();
                option2 = Option$.MODULE$.apply((Object)box);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while WalletBox parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<WithdrawalEpochInfo> getWithdrawalEpochInfo() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochInformationKey())));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochInfo> try_ = WithdrawalEpochInfoSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochInfo withdrawalEpochInfo = (WithdrawalEpochInfo)success.value();
                option3 = Option$.MODULE$.apply((Object)withdrawalEpochInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch info information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public int getWithdrawalEpochCounter(int epoch) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getWithdrawalEpochCounterKey(epoch))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedWithdrawalEpochCounter()));
        } else {
            n = this.undefinedWithdrawalEpochCounter();
        }
        return n;
    }

    private int getBlockFeeInfoCounter(int withdrawalEpochNumber) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getBlockFeeInfoCounterKey(withdrawalEpochNumber))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedBlockFeeInfoCounter()));
        } else {
            n = this.undefinedBlockFeeInfoCounter();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<BlockFeeInfo> getFeePayments(int withdrawalEpochNumber) {
        void var2_2;
        ListBuffer blockFees = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getBlockFeeInfoCounter(withdrawalEpochNumber);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getBlockFeeInfoKey(withdrawalEpochNumber, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try<BlockFeeInfo> try_ = BlockFeeInfoSerializer$.MODULE$.parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while fee payment parsing.", exception);
                    }
                    throw new MatchError(try_);
                }
                Success success = (Success)try_;
                BlockFeeInfo info = (BlockFeeInfo)success.value();
                blockFees.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockFeeInfo[]{info}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while fee payments retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<WithdrawalRequestBox> getWithdrawalRequests(int withdrawalEpoch) {
        void var2_2;
        ListBuffer withdrawalRequests = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getWithdrawalEpochCounter(withdrawalEpoch);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getWithdrawalRequestsKey(withdrawalEpoch, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try try_ = this.withdrawalRequestSerializer().parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while withdrawal requests parsing.", exception);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                java.util.List wr = (java.util.List)success.value();
                withdrawalRequests.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(wr).asScala());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while withdrawal requests retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getTopQualityCertificateKey(referencedWithdrawalEpoch))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochCertificate> try_ = WithdrawalEpochCertificateSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochCertificate certificate = (WithdrawalEpochCertificate)success.value();
                option3 = Option$.MODULE$.apply((Object)certificate);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch certificate information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getUtxoMerkleTreeRoot(int withdrawalEpoch) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getUtxoMerkleTreeRootKey(withdrawalEpoch)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    public boolean hasCeased() {
        return this.storage.get(this.ceasingStateKey()).isPresent();
    }

    public Option<Object> getConsensusEpochNumber() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.consensusEpochKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.intToConsensusEpochNumber(epoch)));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while consensus epoch information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    /*
     * Unable to fully structure code
     */
    public Option<ForgerList> getForgerList() {
        block13: {
            block12: {
                var3_1 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgerListIndexKey())));
                if (!(var3_1 instanceof Some)) break block12;
                var4_2 = (Some)var3_1;
                baw = (ByteArrayWrapper)var4_2.value();
                var6_4 = false;
                var7_5 = null;
                var8_6 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getForgerList$1(com.horizen.utils.ByteArrayWrapper ), ()Lscala/util/Try;)((ByteArrayWrapper)baw));
                if (!(var8_6 instanceof Success)) ** GOTO lbl-1000
                var6_4 = true;
                var7_5 = (Success)var8_6;
                var9_7 = (Try)var7_5.value();
                if (var9_7 instanceof Success) {
                    var10_8 = (Success)var9_7;
                    forgerIndexes = (ForgerList)var10_8.value();
                    var2_10 = new Some((Object)forgerIndexes);
                } else if (var6_4 && (var12_11 = (Try)var7_5.value()) instanceof Failure) {
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Error while forger list indexes information parsing.");
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    var2_10 = Option$.MODULE$.empty();
                } else if (var8_6 instanceof Failure) {
                    var13_12 = (Failure)var8_6;
                    exception = var13_12.exception();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Error while forger list indexes information parsing.", exception);
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    var2_10 = Option$.MODULE$.empty();
                } else {
                    throw new MatchError((Object)var8_6);
                }
                var1_14 = var2_10;
                break block13;
            }
            if (None$.MODULE$.equals(var3_1)) {
                var1_14 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)var3_1);
            }
        }
        return var1_14;
    }

    public Try<SidechainStateStorage> update(ByteArrayWrapper version, WithdrawalEpochInfo withdrawalEpochInfo, Set<Box<Proposition>> boxUpdateList, Set<ByteArrayWrapper> boxIdsRemoveSet, Seq<WithdrawalRequestBox> withdrawalRequestAppendSeq, int consensusEpoch, Option<WithdrawalEpochCertificate> topQualityCertificateOpt, BlockFeeInfo blockFeeInfo, Option<byte[]> utxoMerkleTreeRootOpt, boolean scHasCeased, int[] forgerListIndexes, int forgerListSize) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Object object2;
            Some some;
            WithdrawalEpochInfo storedEpochInfo;
            Object object3;
            Predef$.MODULE$.require(withdrawalEpochInfo != null, (Function0 & Serializable & scala.Serializable)() -> "WithdrawalEpochInfo must be NOT NULL.");
            Predef$.MODULE$.require(boxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Boxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!boxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Box to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveSet.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            Predef$.MODULE$.require(withdrawalRequestAppendSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of WithdrawalRequests to append must be NOT NULL. Use empty Seq instead.");
            Predef$.MODULE$.require(!withdrawalRequestAppendSeq.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WithdrawalRequest to append must be NOT NULL.");
            Predef$.MODULE$.require(blockFeeInfo != null, (Function0 & Serializable & scala.Serializable)() -> "BlockFeeInfo must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            boxIdsRemoveSet.foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)removeList.add(Utils.calculateKey(r.data()))));
            boxUpdateList.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(b.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(b))))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochInformationKey(), new ByteArrayWrapper(WithdrawalEpochInfoSerializer$.MODULE$.toBytes(withdrawalEpochInfo))));
            if (withdrawalRequestAppendSeq.nonEmpty()) {
                int nextWithdrawalEpochCounter = this.getWithdrawalEpochCounter(withdrawalEpochInfo.epoch()) + 1;
                updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalEpochCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextWithdrawalEpochCounter))));
                object3 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalRequestsKey(withdrawalEpochInfo.epoch(), nextWithdrawalEpochCounter), new ByteArrayWrapper(this.withdrawalRequestSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(withdrawalRequestAppendSeq).asJava())))));
            } else {
                object3 = BoxedUnit.UNIT;
            }
            utxoMerkleTreeRootOpt.foreach((Function1 & Serializable & scala.Serializable)merkleRoot -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getUtxoMerkleTreeRootKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(merkleRoot)))));
            Option<WithdrawalEpochInfo> option = this.getWithdrawalEpochInfo();
            boolean bl = option instanceof Some ? (storedEpochInfo = (WithdrawalEpochInfo)(some = (Some)option).value()).epoch() != withdrawalEpochInfo.epoch() : false;
            boolean isWithdrawalEpochSwitched = bl;
            if (isWithdrawalEpochSwitched) {
                int wrEpochNumberToRemove = withdrawalEpochInfo.epoch() - 2;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getWithdrawalEpochCounter(wrEpochNumberToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getWithdrawalRequestsKey(wrEpochNumberToRemove, counter)));
                removeList.add(this.getWithdrawalEpochCounterKey(wrEpochNumberToRemove));
                int certEpochNumberToRemove = withdrawalEpochInfo.epoch() - 4;
                removeList.add(this.getTopQualityCertificateKey(certEpochNumberToRemove));
                removeList.add(this.getUtxoMerkleTreeRootKey(certEpochNumberToRemove));
                int blockFeeInfoEpochToRemove = withdrawalEpochInfo.epoch() - 1;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getBlockFeeInfoCounter(blockFeeInfoEpochToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getBlockFeeInfoKey(blockFeeInfoEpochToRemove, counter)));
                object2 = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getBlockFeeInfoCounterKey(blockFeeInfoEpochToRemove)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            topQualityCertificateOpt.foreach((Function1 & Serializable & scala.Serializable)certificate -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getTopQualityCertificateKey(certificate.epochNumber()), com.horizen.utils.package$.MODULE$.byteArrayToWrapper(WithdrawalEpochCertificateSerializer$.MODULE$.toBytes(certificate))))));
            int nextBlockFeeInfoCounter = this.getBlockFeeInfoCounter(withdrawalEpochInfo.epoch()) + 1;
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getBlockFeeInfoCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextBlockFeeInfoCounter))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getBlockFeeInfoKey(withdrawalEpochInfo.epoch(), nextBlockFeeInfoCounter), new ByteArrayWrapper(BlockFeeInfoSerializer$.MODULE$.toBytes(blockFeeInfo))));
            Object object4 = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.intToConsensusEpochNumber(0))) != consensusEpoch ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.consensusEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)consensusEpoch))))) : BoxedUnit.UNIT;
            Object object5 = scHasCeased ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.ceasingStateKey(), new ByteArrayWrapper(Array$.MODULE$.emptyByteArray())))) : BoxedUnit.UNIT;
            Option<ForgerList> option2 = this.getForgerList();
            if (option2 instanceof Some) {
                Object object6;
                Some some2 = (Some)option2;
                ForgerList forgerList = (ForgerList)some2.value();
                if (forgerListIndexes.length != 0) {
                    ForgerList updatedForgerList = forgerList.updateIndexes(forgerListIndexes);
                    object6 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerListIndexKey(), com.horizen.utils.package$.MODULE$.byteArrayToWrapper(ForgerListSerializer$.MODULE$.toBytes(updatedForgerList)))));
                } else {
                    object6 = BoxedUnit.UNIT;
                }
                object = object6;
            } else if (None$.MODULE$.equals(option2)) {
                ForgerList emptyForgerListIndex = new ForgerList(new int[forgerListSize]);
                object = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerListIndexKey(), com.horizen.utils.package$.MODULE$.byteArrayToWrapper(ForgerListSerializer$.MODULE$.toBytes(emptyForgerListIndex)))));
            } else {
                throw new MatchError(option2);
            }
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<SidechainStateStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public StorageIterator getIterator() {
        return this.storage.getIterator();
    }

    public void restoreBackup(BoxIterator backupStorageBoxIterator, byte[] lastVersion) {
        BoxedUnit boxedUnit;
        ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        ByteArrayWrapper lastVersionWrapper = new ByteArrayWrapper(lastVersion);
        Optional<BackupBox> optionalBox = backupStorageBoxIterator.nextBox();
        while (optionalBox.isPresent()) {
            BoxedUnit boxedUnit2;
            Box<Proposition> box = optionalBox.get().getBox();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(box.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(box))));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder(15).append("Restore Box id ").append(box.boxTypeId()).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            optionalBox = backupStorageBoxIterator.nextBox();
            if (updateList.size() != package$Constants$.MODULE$.BatchSize()) continue;
            if (optionalBox.isPresent()) {
                this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), updateList, removeList);
            } else {
                this.storage.update(lastVersionWrapper, updateList, removeList);
            }
            updateList.clear();
        }
        if (updateList.size() != 0) {
            this.storage.update(lastVersionWrapper, updateList, removeList);
        }
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("SidechainStateStorage restore completed successfully!");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Try $anonfun$getForgerList$1(ByteArrayWrapper baw$4) {
        return ForgerListSerializer$.MODULE$.parseBytesTry(baw$4.data());
    }

    public SidechainStateStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        this.sidechainBoxesCompanion = sidechainBoxesCompanion;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this.withdrawalEpochInformationKey = Utils.calculateKey("withdrawalEpochInformation".getBytes());
        this.withdrawalRequestSerializer = new ListSerializer<WithdrawalRequestBox>(WithdrawalRequestBoxSerializer.getSerializer());
        this.consensusEpochKey = Utils.calculateKey("consensusEpoch".getBytes());
        this.ceasingStateKey = Utils.calculateKey("ceasingStateKey".getBytes());
        this.forgerListIndexKey = Utils.calculateKey("forgerListIndexKey".getBytes());
        this.undefinedWithdrawalEpochCounter = -1;
        this.undefinedBlockFeeInfoCounter = -1;
    }
}

