/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proof;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.proof.ProofOfKnowledge;
import com.horizen.proof.ProofSerializer;
import com.horizen.proof.VrfProofSerializer;
import com.horizen.proposition.VrfPublicKey;
import com.horizen.secret.VrfSecretKey;
import com.horizen.serialization.Views;
import com.horizen.vrf.VrfOutput;
import java.util.Arrays;
import java.util.Optional;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

@JsonView(value={Views.Default.class})
public final class VrfProof
implements ProofOfKnowledge<VrfSecretKey, VrfPublicKey> {
    public static final int PROOF_LENGTH = CryptoLibProvider.vrfFunctions().vrfProofLen();
    @JsonProperty(value="vrfProof")
    final byte[] proofBytes;

    public VrfProof(byte[] proof) {
        if (proof.length != PROOF_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect proof length, %d expected, %d found", PROOF_LENGTH, proof.length));
        }
        this.proofBytes = Arrays.copyOf(proof, proof.length);
    }

    public Optional<VrfOutput> proofToVrfOutput(VrfPublicKey publicKey, byte[] message) {
        return CryptoLibProvider.vrfFunctions().proofToOutput(publicKey.pubKeyBytes(), message, this.proofBytes).map(VrfOutput::new);
    }

    @Override
    public boolean isValid(VrfPublicKey proposition, byte[] message) {
        return CryptoLibProvider.vrfFunctions().verifyProof(message, proposition.pubKeyBytes(), this.proofBytes);
    }

    @Override
    public ProofSerializer serializer() {
        return VrfProofSerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VrfProof vrfProof = (VrfProof)o;
        return Arrays.equals(this.proofBytes, vrfProof.proofBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.proofBytes);
    }

    public String toString() {
        return "VrfProof{proofBytes=" + ByteUtils.toHexString((byte[])this.proofBytes) + "}";
    }
}

