/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.server;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.horizen.SidechainHistory;
import com.horizen.SidechainMemoryPool;
import com.horizen.SidechainState;
import com.horizen.SidechainSyncInfo;
import com.horizen.SidechainWallet;
import com.horizen.block.SidechainBlock;
import com.horizen.chain.FeePaymentsInfo;
import com.horizen.serialization.SerializationUtil;
import com.horizen.websocket.server.SidechainNodeChannel;
import com.horizen.websocket.server.WebSocketServerRef$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Try;
import scala.util.Try$;
import scorex.core.NodeViewHolder;
import scorex.util.ScorexLogging;
import scorex.util.package;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\n\u0014\u0001qAQa\f\u0001\u0005\u0002ABqA\r\u0001C\u0002\u0013\r1\u0007\u0003\u0004<\u0001\u0001\u0006I\u0001\u000e\u0005\by\u0001\u0011\r\u0011b\u0001>\u0011\u0019!\u0005\u0001)A\u0005}!9Q\t\u0001b\u0001\n\u00131\u0005BB)\u0001A\u0003%q)\u0002\u0003S\u0001\u0001\u0019\u0006\"\u00029\u0001\t\u0003\t\bbBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t9\u0005\u0001C!\u0003\u0013Bq!!\u001a\u0001\t\u0003\n9\u0007C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u0005E\u0004\u0001\"\u0011\u0002p!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBAC\u0001\u0011%\u0011q\u0011\u0002\u0019'&$Wm\u00195bS:tu\u000eZ3DQ\u0006tg.\u001a7J[Bd'B\u0001\u000b\u0016\u0003\u0019\u0019XM\u001d<fe*\u0011acF\u0001\no\u0016\u00147o\\2lKRT!\u0001G\r\u0002\u000f!|'/\u001b>f]*\t!$A\u0002d_6\u001c\u0001a\u0005\u0003\u0001;\r:\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%K5\t1#\u0003\u0002''\t!2+\u001b3fG\"\f\u0017N\u001c(pI\u0016\u001c\u0005.\u00198oK2\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u000511oY8sKbL!AL\u0015\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u0002%\u0001\u0005AA-\u001e:bi&|g.F\u00015!\t)\u0014(D\u00017\u0015\tQsGC\u00019\u0003\u0011\t7n[1\n\u0005i2$a\u0002+j[\u0016|W\u000f^\u0001\nIV\u0014\u0018\r^5p]\u0002\n!!Z2\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!Q\u0010\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002D\u0001\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004\u0013AB7baB,'/F\u0001H!\tAu*D\u0001J\u0015\tQ5*\u0001\u0005eCR\f'-\u001b8e\u0015\taU*A\u0004kC\u000e\\7o\u001c8\u000b\u00059K\u0012!\u00034bgR,'\u000f_7m\u0013\t\u0001\u0016J\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0003\tYKWm\u001e\t\u0007)\u0002\u001cwM[7\u000f\u0005UkfB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tI6$\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011AlK\u0001\u0005G>\u0014X-\u0003\u0002_?\u0006qaj\u001c3f-&,w\u000fS8mI\u0016\u0014(B\u0001/,\u0013\t\t'MA\u0006DkJ\u0014XM\u001c;WS\u0016<(B\u00010`!\t!W-D\u0001\u0018\u0013\t1wC\u0001\tTS\u0012,7\r[1j]\"K7\u000f^8ssB\u0011A\r[\u0005\u0003S^\u0011abU5eK\u000eD\u0017-\u001b8Ti\u0006$X\r\u0005\u0002eW&\u0011An\u0006\u0002\u0010'&$Wm\u00195bS:<\u0016\r\u001c7fiB\u0011AM\\\u0005\u0003_^\u00111cU5eK\u000eD\u0017-\u001b8NK6|'/\u001f)p_2\fq\"\u00199qYf|eNT8eKZKWm^\u000b\u0003eV$\"a\u001d@\u0011\u0005Q,H\u0002\u0001\u0003\u0006m&\u0011\ra\u001e\u0002\u0002%F\u0011\u0001p\u001f\t\u0003=eL!A_\u0010\u0003\u000f9{G\u000f[5oOB\u0011a\u0004`\u0005\u0003{~\u00111!\u00118z\u0011\u0019y\u0018\u00021\u0001\u0002\u0002\u0005\u0019b-\u001e8di&|g\u000eV8CK\u0006\u0003\b\u000f\\5fIB1a$a\u0001\u0002\bML1!!\u0002 \u0005%1UO\\2uS>t\u0017\u0007E\u0002\u0002\n!i\u0011\u0001A\u0001\u0015O\u0016$(\t\\8dW&sgm\u001c\"z\u0011\u0016Lw\r\u001b;\u0015\t\u0005=\u0011Q\u0005\t\u0007\u0003#\t)\"!\u0007\u000e\u0005\u0005M!B\u0001\u0016 \u0013\u0011\t9\"a\u0005\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"S\u0001\u0005]>$W-\u0003\u0003\u0002$\u0005u!AC(cU\u0016\u001cGOT8eK\"9\u0011q\u0005\u0006A\u0002\u0005%\u0012A\u00025fS\u001eDG\u000fE\u0002\u001f\u0003WI1!!\f \u0005\rIe\u000e^\u0001\u0013O\u0016$(\t\\8dW&sgm\u001c\"z\u0011\u0006\u001c\b\u000e\u0006\u0003\u0002\u0010\u0005M\u0002bBA\u001b\u0017\u0001\u0007\u0011qG\u0001\u0005Q\u0006\u001c\b\u000e\u0005\u0003\u0002:\u0005\u0005c\u0002BA\u001e\u0003{\u0001\"aV\u0010\n\u0007\u0005}r$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\n)E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007fy\u0012!E4fi:+wO\u00117pG.D\u0015m\u001d5fgR1\u0011qBA&\u0003CBq!!\u0014\r\u0001\u0004\ty%A\u0007m_\u000e\fGo\u001c:ICNDWm\u001d\t\u0007\u0003#\nY&a\u000e\u000f\t\u0005M\u0013q\u000b\b\u0004/\u0006U\u0013\"\u0001\u0011\n\u0007\u0005es$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0013q\f\u0002\u0004'\u0016\f(bAA-?!9\u00111\r\u0007A\u0002\u0005%\u0012!\u00027j[&$\u0018!D4fi6+W\u000e]8pYRC8\u000f\u0006\u0003\u0002\u0010\u0005%\u0004bBA6\u001b\u0001\u0007\u0011qJ\u0001\u0006ibLGm]\u0001\u000eO\u0016$(+Y<NK6\u0004xn\u001c7\u0015\u0005\u0005=\u0011\u0001E4fi\n+7\u000f\u001e\"m_\u000e\\\u0017J\u001c4p\u000319W\r\u001e\"m_\u000e\\\u0017J\u001c4p)\u0011\ty!a\u001e\t\u000f\u0005e\u0004\u00031\u0001\u0002|\u0005)!\r\\8dWB!\u0011QPAA\u001b\t\tyHC\u0002\u0002z]IA!a!\u0002\u0000\tq1+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017!F2bY\u000e,H.\u0019;f\u00052|7m\u001b)bs2|\u0017\r\u001a\u000b\t\u00033\tI)a#\u0002\u000e\"9\u0011\u0011P\tA\u0002\u0005m\u0004bBA\u0014#\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003\u001f\u000b\u0002\u0019AAI\u0003I1W-\u001a)bs6,g\u000e^:J]\u001a|w\n\u001d;\u0011\u000by\t\u0019*a&\n\u0007\u0005UuD\u0001\u0004PaRLwN\u001c\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011QT\f\u0002\u000b\rD\u0017-\u001b8\n\t\u0005\u0005\u00161\u0014\u0002\u0010\r\u0016,\u0007+Y=nK:$8/\u00138g_\u0002")
public class SidechainNodeChannelImpl
implements SidechainNodeChannel,
ScorexLogging {
    private final Timeout duration;
    private final ExecutionContext ec;
    private final ObjectMapper mapper;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Timeout duration() {
        return this.duration;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public <R> R applyOnNodeView(Function1<NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool>, R> functionToBeApplied) {
        Object object;
        try {
            Object result;
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(WebSocketServerRef$.MODULE$.sidechainNodeViewHolderRef());
            NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView x$1 = new NodeViewHolder.ReceivableMessages$.GetDataFromCurrentView(functionToBeApplied);
            Timeout x$2 = this.duration();
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            Future res = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3);
            object = result = Await$.MODULE$.result((Awaitable)res, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5000)).millis());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return (R)object;
    }

    @Override
    public Try<ObjectNode> getBlockInfoByHeight(int height) {
        return ((Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> sidechainBlockHash = ((SidechainHistory)sidechainNodeView.history()).blockIdByHeight(height);
            if (sidechainBlockHash.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(28).append("Block not found for height: ").append(height).toString());
            }
            String blockId = (String)package.ModifierId$.MODULE$.$at$at(sidechainBlockHash.get(), package.Tagger$.MODULE$.baseRaw());
            Option<SidechainBlock> sblockOpt = ((SidechainHistory)sidechainNodeView.history()).modifierById(blockId);
            if (sblockOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(26).append("Block not found for hash: ").append(sidechainBlockHash).toString());
            }
            Option<FeePaymentsInfo> feePaymentsInfoOpt = ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(blockId);
            return new Tuple2(sblockOpt.get(), feePaymentsInfoOpt);
        }))).map((Function1 & Serializable & scala.Serializable)blockInfo -> this.calculateBlockPayload((SidechainBlock)blockInfo._1(), height, (Option<FeePaymentsInfo>)((Option)blockInfo._2())));
    }

    @Override
    public Try<ObjectNode> getBlockInfoByHash(String hash) {
        return ((Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String blockId = (String)package.ModifierId$.MODULE$.$at$at((Object)hash, package.Tagger$.MODULE$.baseRaw());
            Option<SidechainBlock> blockOpt = ((SidechainHistory)sidechainNodeView.history()).modifierById(blockId);
            if (blockOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(26).append("Block not found for hash: ").append(hash).toString());
            }
            int height = ((SidechainHistory)sidechainNodeView.history()).blockInfoById(blockId).height();
            Option<FeePaymentsInfo> feePaymentsInfoOpt = ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(blockId);
            return new Tuple3(blockOpt.get(), (Object)BoxesRunTime.boxToInteger((int)height), feePaymentsInfoOpt);
        }))).map((Function1 & Serializable & scala.Serializable)blockInfo -> this.calculateBlockPayload((SidechainBlock)blockInfo._1(), BoxesRunTime.unboxToInt((Object)blockInfo._2()), (Option<FeePaymentsInfo>)((Option)blockInfo._3())));
    }

    @Override
    public Try<ObjectNode> getNewBlockHashes(Seq<String> locatorHashes, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            IntRef lastHeight = IntRef.create((int)-1);
            ObjectNode responsePayload = this.mapper().createObjectNode();
            SidechainSyncInfo scInfo = new SidechainSyncInfo(locatorHashes);
            Seq headerList = (Seq)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Seq<Tuple2<Object, String>> headers;
                block0: {
                    headers = ((SidechainHistory)sidechainNodeView.history()).continuationIds(scInfo, limit);
                    if (!headers.nonEmpty()) break block0;
                    lastHeight$1.elem = ((SidechainHistory)sidechainNodeView.history()).blockInfoById((String)((Tuple2)headers.last())._2()).height();
                }
                return headers;
            });
            JsonNode hashes = this.mapper().readTree(SerializationUtil.serialize(headerList.map((Function1 & Serializable & scala.Serializable)el -> (String)el._2(), Seq$.MODULE$.canBuildFrom())));
            responsePayload.put("height", lastHeight.elem);
            responsePayload.set("hashes", hashes);
            return responsePayload;
        });
    }

    @Override
    public Try<ObjectNode> getMempoolTxs(Seq<String> txids) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            ObjectNode responsePayload = this.mapper().createObjectNode();
            Seq txs = (Seq)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> ((SidechainMemoryPool)sidechainNodeView.pool()).getAll(txids));
            JsonNode txsJson = this.mapper().readTree(SerializationUtil.serialize(txs));
            responsePayload.set("transactions", txsJson);
            return var2_2;
        });
    }

    @Override
    public Try<ObjectNode> getRawMempool() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ObjectNode responsePayload = this.mapper().createObjectNode();
            ArrayList txids = (ArrayList)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                void var1_1;
                ArrayList txs = new ArrayList();
                ((SidechainMemoryPool)sidechainNodeView.pool()).take(((SidechainMemoryPool)sidechainNodeView.pool()).size()).foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)txs.add(tx.id())));
                return var1_1;
            });
            JsonNode json = this.mapper().readTree(SerializationUtil.serialize(txids.toArray()));
            responsePayload.set("transactions", json);
            responsePayload.put("size", txids.size());
            return var1_1;
        });
    }

    @Override
    public Try<ObjectNode> getBestBlockInfo() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n;
            SidechainBlock sidechainBlock;
            Option feePaymentsInfoOpt;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = (Tuple3)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                        SidechainBlock bBlock = ((SidechainHistory)sidechainNodeView.history()).bestBlock();
                        int height = ((SidechainHistory)sidechainNodeView.history()).height();
                        Option<FeePaymentsInfo> feePaymentsInfoOpt = ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(bBlock.id());
                        return new Tuple3((Object)bBlock, (Object)BoxesRunTime.boxToInteger((int)height), feePaymentsInfoOpt);
                    });
                    if (tuple3 == null) break block2;
                    SidechainBlock bestBlock = (SidechainBlock)tuple3._1();
                    int height = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    feePaymentsInfoOpt = (Option)tuple3._3();
                    if (bestBlock == null) break block2;
                    sidechainBlock = bestBlock;
                    n = height;
                    if (feePaymentsInfoOpt != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Option option = feePaymentsInfoOpt;
            Tuple3 tuple3 = new Tuple3((Object)sidechainBlock, (Object)BoxesRunTime.boxToInteger((int)n), (Object)option);
            Tuple3 tuple32 = tuple3;
            SidechainBlock bestBlock = (SidechainBlock)tuple32._1();
            int height = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option feePaymentsInfoOpt2 = (Option)tuple32._3();
            return this.calculateBlockPayload(bestBlock, height, (Option<FeePaymentsInfo>)feePaymentsInfoOpt2);
        });
    }

    @Override
    public Try<ObjectNode> getBlockInfo(SidechainBlock block) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n;
            Option feePaymentsInfoOpt;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = (Tuple2)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)((SidechainHistory)sidechainNodeView.history()).blockInfoById(block.id()).height()), ((SidechainHistory)sidechainNodeView.history()).feePaymentsInfo(block.id())));
                    if (tuple2 == null) break block2;
                    int height = tuple2._1$mcI$sp();
                    feePaymentsInfoOpt = (Option)tuple2._2();
                    n = height;
                    if (feePaymentsInfoOpt != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Option option = feePaymentsInfoOpt;
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)option);
            Tuple2 tuple22 = tuple2;
            int height = tuple22._1$mcI$sp();
            Option feePaymentsInfoOpt2 = (Option)tuple22._2();
            return this.calculateBlockPayload(block, height, (Option<FeePaymentsInfo>)feePaymentsInfoOpt2);
        });
    }

    private ObjectNode calculateBlockPayload(SidechainBlock block, int height, Option<FeePaymentsInfo> feePaymentsInfoOpt) {
        ObjectNode eventPayload = this.mapper().createObjectNode();
        JsonNode blockJson = this.mapper().readTree(SerializationUtil.serialize(block));
        eventPayload.put("height", height);
        eventPayload.put("hash", block.id());
        eventPayload.set("block", blockJson);
        feePaymentsInfoOpt.foreach((Function1 & Serializable & scala.Serializable)feePaymentsInfo -> {
            JsonNode feePaymentsTxJson = this.mapper().readTree(SerializationUtil.serialize(feePaymentsInfo.transaction()));
            return eventPayload.set("feePayments", feePaymentsTxJson);
        });
        return eventPayload;
    }

    public SidechainNodeChannelImpl() {
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.duration = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds());
        this.ec = ExecutionContext.Implicits$.MODULE$.global();
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

