/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.client;

import com.horizen.websocket.client.DisconnectionCode$;
import com.horizen.websocket.client.WebSocketChannel;
import com.horizen.websocket.client.WebSocketConnector;
import com.horizen.websocket.client.WebSocketMessageHandler;
import com.horizen.websocket.client.WebSocketReconnectionHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import scala.Function0;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ClientEndpoint
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\n\u0014\u0001qA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015y\u0005\u0001\"\u0001Q\u0011%1\u0006\u00011AA\u0002\u0013%q\u000bC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"Ia\r\u0001a\u0001\u0002\u0003\u0006K\u0001\u0017\u0005\b)\u0001\u0011\r\u0011\"\u0003h\u0011\u0019\u0019\b\u0001)A\u0005Q\"9A\u000f\u0001b\u0001\n\u0013)\bBB?\u0001A\u0003%a\u000fC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005B\u0005%\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0002\u0017/\u0016\u00147k\\2lKR\u001cuN\u001c8fGR|'/S7qY*\u0011A#F\u0001\u0007G2LWM\u001c;\u000b\u0005Y9\u0012!C<fEN|7m[3u\u0015\tA\u0012$A\u0004i_JL'0\u001a8\u000b\u0003i\t1aY8n\u0007\u0001\u0019R\u0001A\u000f$O)\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013&\u001b\u0005\u0019\u0012B\u0001\u0014\u0014\u0005I9VMY*pG.,GoQ8o]\u0016\u001cGo\u001c:\u0011\u0005\u0011B\u0013BA\u0015\u0014\u0005A9VMY*pG.,Go\u00115b]:,G\u000e\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!Q\u000f^5m\u0015\u0005y\u0013AB:d_J,\u00070\u0003\u00022Y\ti1kY8sKbdunZ4j]\u001e\f1BY5oI\u0006#GM]3tgB\u0011Ag\u000f\b\u0003ke\u0002\"AN\u0010\u000e\u0003]R!\u0001O\u000e\u0002\rq\u0012xn\u001c;?\u0013\tQt$\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e \u0003E\u0019wN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\t~\t!bY8oGV\u0014(/\u001a8u\u0013\t1\u0015I\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u001d5,7o]1hK\"\u000bg\u000e\u001a7feB\u0011A%S\u0005\u0003\u0015N\u0011qcV3c'>\u001c7.\u001a;NKN\u001c\u0018mZ3IC:$G.\u001a:\u0002'I,7m\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\u0011\u0005\u0011j\u0015B\u0001(\u0014\u0005q9VMY*pG.,GOU3d_:tWm\u0019;j_:D\u0015M\u001c3mKJ\fa\u0001P5oSRtD#B)S'R+\u0006C\u0001\u0013\u0001\u0011\u0015\u0011T\u00011\u00014\u0011\u0015qT\u00011\u0001@\u0011\u00159U\u00011\u0001I\u0011\u0015YU\u00011\u0001M\u0003-)8/\u001a:TKN\u001c\u0018n\u001c8\u0016\u0003a\u0003\"!W/\u000e\u0003iS!AF.\u000b\u0003q\u000bQA[1wCbL!A\u0018.\u0003\u000fM+7o]5p]\u0006yQo]3s'\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u0002bIB\u0011aDY\u0005\u0003G~\u0011A!\u00168ji\"9QmBA\u0001\u0002\u0004A\u0016a\u0001=%c\u0005aQo]3s'\u0016\u001c8/[8oAU\t\u0001\u000e\u0005\u0002jc6\t!N\u0003\u0002\u0015W*\u0011A.\\\u0001\u0006if\u0014Xo\u001d\u0006\u0003]>\f\u0011b\u001a7bgN4\u0017n\u001d5\u000b\u0003A\f1a\u001c:h\u0013\t\u0011(NA\u0007DY&,g\u000e^'b]\u0006<WM]\u0001\bG2LWM\u001c;!\u0003A\u0011XmY8o]\u0016\u001cG\u000fS1oI2,'/F\u0001w!\t9(P\u0004\u0002jq&\u0011\u0011P[\u0001\u000e\u00072LWM\u001c;NC:\fw-\u001a:\n\u0005md(\u0001\u0005*fG>tg.Z2u\u0011\u0006tG\r\\3s\u0015\tI(.A\tsK\u000e|gN\\3di\"\u000bg\u000e\u001a7fe\u0002\n\u0011\"[:Ti\u0006\u0014H/\u001a3\u0015\u0005\u0005\u0005\u0001c\u0001\u0010\u0002\u0004%\u0019\u0011QA\u0010\u0003\u000f\t{w\u000e\\3b]\u0006)1\u000f^1siR\u0011\u00111\u0002\t\u0006\u0003\u001b\t\t\"Y\u0007\u0003\u0003\u001fQ!!L\u0010\n\t\u0005M\u0011q\u0002\u0002\u0004)JL\u0018AC1ts:\u001c7\u000b^1siR\u0011\u0011\u0011\u0004\t\u0007\u00037\ti\"a\u0003\u000e\u0003\rK1!a\bD\u0005\u00191U\u000f^;sK\u0006!1\u000f^8q\u0003-\u0019XM\u001c3NKN\u001c\u0018mZ3\u0015\u0007\u0005\f9\u0003\u0003\u0004\u0002*E\u0001\raM\u0001\b[\u0016\u001c8/Y4fQ\r\u0001\u0011Q\u0006\t\u00043\u0006=\u0012bAA\u00195\nq1\t\\5f]R,e\u000e\u001a9pS:$\b")
public class WebSocketConnectorImpl
implements WebSocketConnector,
WebSocketChannel,
ScorexLogging {
    private final String bindAddress;
    private final FiniteDuration connectionTimeout;
    public final WebSocketMessageHandler com$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler;
    public final WebSocketReconnectionHandler com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler;
    private Session userSession;
    private final ClientManager client;
    private final ClientManager.ReconnectHandler reconnectHandler;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Session userSession() {
        return this.userSession;
    }

    private void userSession_$eq(Session x$1) {
        this.userSession = x$1;
    }

    private ClientManager client() {
        return this.client;
    }

    private ClientManager.ReconnectHandler reconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public boolean isStarted() {
        return this.userSession() != null && this.userSession().isOpen();
    }

    @Override
    public Try<BoxedUnit> start() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.isStarted()) {
                throw new IllegalStateException("Connector is already started.");
            }
            this.client().getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", this.reconnectHandler());
            this.client().getProperties().put("org.glassfish.tyrus.client.ClientManager.ContainerTimeout", String.valueOf($this.connectionTimeout.toMillis()));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Starting web socket connector, ws address = {}...", new Object[]{$this.bindAddress});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.userSession_$eq(this.client().connectToServer((Object)this, new URI($this.bindAddress)));
            $this.com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onConnectionSuccess();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Web socket connector started.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.userSession().addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(this){
                private final /* synthetic */ WebSocketConnectorImpl $outer;

                public void onMessage(String t) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.log().underlying().isInfoEnabled()) {
                        this.$outer.log().underlying().info(new StringBuilder(30).append("Message received from server: ").append(t).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.com$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler.onReceivedMessage(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        });
    }

    @Override
    public Future<Try<BoxedUnit>> asyncStart() {
        Promise promise = Promise$.MODULE$.apply();
        new Thread(new Runnable(this, promise){
            private final /* synthetic */ WebSocketConnectorImpl $outer;
            private final Promise promise$1;

            public void run() {
                this.promise$1.success(this.$outer.start());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
            }
        }).start();
        return promise.future();
    }

    @Override
    public Try<BoxedUnit> stop() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Stopping web socket connector...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.userSession().close();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Web socket connector stopped.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    @Override
    public void sendMessage(String message) {
        try {
            this.userSession().getAsyncRemote().sendText(message, new SendHandler(this, message){
                private final /* synthetic */ WebSocketConnectorImpl $outer;
                private final String message$1;

                public void onResult(SendResult sendResult) {
                    BoxedUnit boxedUnit;
                    if (!sendResult.isOK()) {
                        BoxedUnit boxedUnit2;
                        if (this.$outer.log().underlying().isInfoEnabled()) {
                            this.$outer.log().underlying().info("Send message failed.");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        this.$outer.com$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler.onSendMessageErrorOccurred(this.message$1, sendResult.getException());
                    } else if (this.$outer.log().underlying().isInfoEnabled()) {
                        this.$outer.log().underlying().info("Message sent");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.message$1 = message$1;
                }
            });
        }
        catch (Throwable e) {
            this.com$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler.onSendMessageErrorOccurred(message, e);
        }
    }

    public WebSocketConnectorImpl(String bindAddress, FiniteDuration connectionTimeout, WebSocketMessageHandler messageHandler, WebSocketReconnectionHandler reconnectionHandler) {
        this.bindAddress = bindAddress;
        this.connectionTimeout = connectionTimeout;
        this.com$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler = messageHandler;
        this.com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler = reconnectionHandler;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.client = ClientManager.createClient();
        this.reconnectHandler = new ClientManager.ReconnectHandler(this){
            private final /* synthetic */ WebSocketConnectorImpl $outer;

            public long getDelay() {
                return this.$outer.com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.getDelay().toSeconds();
            }

            public boolean onDisconnect(CloseReason closeReason) {
                BoxedUnit boxedUnit;
                if (this.$outer.log().underlying().isInfoEnabled()) {
                    this.$outer.log().underlying().info(new StringBuilder(22).append("onDisconnect. Reason: ").append(closeReason.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return closeReason.getCloseCode().getCode() == 1000 ? this.$outer.com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onDisconnection(DisconnectionCode$.MODULE$.ON_SUCCESS(), closeReason.getReasonPhrase()) : this.$outer.com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onDisconnection(DisconnectionCode$.MODULE$.UNEXPECTED(), closeReason.getReasonPhrase());
            }

            public boolean onConnectFailure(Exception exception) {
                return this.$outer.com$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onConnectionFailed(exception);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

