/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.validation;

import com.horizen.SidechainHistory;
import com.horizen.block.Ommer;
import com.horizen.block.OmmersContainer;
import com.horizen.block.SidechainBlock;
import com.horizen.block.SidechainBlockHeader;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.consensus.ConsensusEpochAndSlot;
import com.horizen.consensus.FullConsensusEpochInfo;
import com.horizen.consensus.NonceConsensusEpochInfo;
import com.horizen.consensus.StakeConsensusEpochInfo;
import com.horizen.consensus.package$;
import com.horizen.params.NetworkParams;
import com.horizen.utils.TimeToEpochUtils$;
import com.horizen.validation.HistoryBlockValidator;
import com.horizen.validation.SidechainBlockSlotInFutureException;
import com.horizen.validation.SidechainBlockSlotInFutureException$;
import com.horizen.vrf.VrfOutput;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.core.utils.TimeProvider;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001\u0002\u0006\f\u0001IA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006]\u0001!\ta\f\u0005\u0006e\u0001!\te\r\u0005\u0006\u0013\u0002!IA\u0013\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006%\u0002!Ia\u0015\u0005\u0006Q\u0002!I!\u001b\u0005\u0007Y\u0002!\t!D7\t\u0011\u0005E\u0004\u0001\"\u0001\u000e\u0003g\u0012!cQ8og\u0016t7/^:WC2LG-\u0019;pe*\u0011A\"D\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\b\u0010\u0003\u001dAwN]5{K:T\u0011\u0001E\u0001\u0004G>l7\u0001A\n\u0005\u0001MIR\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011aC\u0005\u00039-\u0011Q\u0003S5ti>\u0014\u0018P\u00117pG.4\u0016\r\\5eCR|'\u000f\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!Q\u000f^5m\u0015\u0005\u0011\u0013AB:d_J,\u00070\u0003\u0002%?\ti1kY8sKbdunZ4j]\u001e\fA\u0002^5nKB\u0013xN^5eKJ\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u000bU$\u0018\u000e\\:\u000b\u0005-\n\u0013\u0001B2pe\u0016L!!\f\u0015\u0003\u0019QKW.\u001a)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\t\u0001\u0014\u0007\u0005\u0002\u001b\u0001!)QE\u0001a\u0001M\u0005Aa/\u00197jI\u0006$X\rF\u00025y\r\u00032!N\u001c:\u001b\u00051$B\u0001\u0011\u0016\u0013\tAdGA\u0002Uef\u0004\"\u0001\u0006\u001e\n\u0005m*\"\u0001B+oSRDQ!P\u0002A\u0002y\nQA\u00197pG.\u0004\"aP!\u000e\u0003\u0001S!!P\u0007\n\u0005\t\u0003%AD*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b\u0005\u0006\t\u000e\u0001\r!R\u0001\bQ&\u001cHo\u001c:z!\t1u)D\u0001\u000e\u0013\tAUB\u0001\tTS\u0012,7\r[1j]\"K7\u000f^8ss\u0006!b/\u00197jI\u0006$XmR3oKNL7O\u00117pG.$2!O&M\u0011\u0015iD\u00011\u0001?\u0011\u0015!E\u00011\u0001F\u0003]1\u0018\r\\5eCR,gj\u001c8HK:,7/[:CY>\u001c7\u000eF\u0002:\u001fFCQ\u0001U\u0003A\u0002y\nQB^3sS\u001aLW\r\u001a\"m_\u000e\\\u0007\"\u0002#\u0006\u0001\u0004)\u0015a\u0004<fe&4\u0017\u0010V5nKN$\u0018-\u001c9\u0015\te\"v,\u0019\u0005\u0006+\u001a\u0001\rAV\u0001\u0017m\u0016\u0014\u0018NZ5fI\ncwnY6US6,7\u000f^1naB\u0011q\u000b\u0018\b\u00031jk\u0011!\u0017\u0006\u0003{)J!aW-\u0002\u000b\tcwnY6\n\u0005us&!\u0003+j[\u0016\u001cH/Y7q\u0015\tY\u0016\fC\u0003a\r\u0001\u0007a+\u0001\u000bqCJ,g\u000e\u001e\"m_\u000e\\G+[7fgR\fW\u000e\u001d\u0005\u0006E\u001a\u0001\raY\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005\u00114W\"A3\u000b\u0005\tl\u0011BA4f\u00055qU\r^<pe.\u0004\u0016M]1ng\u00069b/\u001a:jMf$\u0016.\\3ti\u0006l\u0007/\u00138GkR,(/\u001a\u000b\u0004s)\\\u0007\"B+\b\u0001\u00041\u0006\"\u0002#\b\u0001\u0004)\u0015\u0001\u0004<fe&4\u0017pT7nKJ\u001cH\u0003D\u001dogn\f\t!!\t\u00022\u0005M\u0002\"B8\t\u0001\u0004\u0001\u0018aD8n[\u0016\u00148oQ8oi\u0006Lg.\u001a:\u0011\u0005}\n\u0018B\u0001:A\u0005=yU.\\3sg\u000e{g\u000e^1j]\u0016\u0014\b\"\u0002;\t\u0001\u0004)\u0018!H2veJ,g\u000e\u001e$vY2\u001cuN\\:f]N,8/\u00129pG\"LeNZ8\u0011\u0005YLX\"A<\u000b\u0005al\u0011!C2p]N,gn];t\u0013\tQxO\u0001\fGk2d7i\u001c8tK:\u001cXo]#q_\u000eD\u0017J\u001c4p\u0011\u0015a\b\u00021\u0001~\u0003\u0005\u0002(/\u001a<j_V\u001ch)\u001e7m\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4wn\u00149u!\r!b0^\u0005\u0003\u007fV\u0011aa\u00149uS>t\u0007bBA\u0002\u0011\u0001\u0007\u0011QA\u0001\u0012E\u0016\u001cHo\u00138po:\u0004\u0016M]3oi&#\u0007\u0003BA\u0004\u00037qA!!\u0003\u0002\u00189!\u00111BA\u000b\u001d\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t#\u00051AH]8pizJ\u0011AI\u0005\u0003A\u0005J1!!\u0007 \u0003\u001d\u0001\u0018mY6bO\u0016LA!!\b\u0002 \tQQj\u001c3jM&,'/\u00133\u000b\u0007\u0005eq\u0004C\u0004\u0002$!\u0001\r!!\n\u0002'\t,7\u000f^&o_^t\u0007+\u0019:f]RLeNZ8\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u000e\u0003\u0015\u0019\u0007.Y5o\u0013\u0011\ty#!\u000b\u0003%MKG-Z2iC&t'\t\\8dW&sgm\u001c\u0005\u0006\t\"\u0001\r!\u0012\u0005\b\u0003kA\u0001\u0019AA\u001c\u0003\t\u0002(/\u001a<j_V\u001cX\t]8dQ>kW.\u001a:t\u0013:4w.Q2dk6,H.\u0019;peB1\u0011\u0011HA!\u0003\u000frA!a\u000f\u0002@9!\u0011QBA\u001f\u0013\u00051\u0012bAA\r+%!\u00111IA#\u0005\r\u0019V-\u001d\u0006\u0004\u00033)\u0002c\u0002\u000b\u0002J\u00055\u0013\u0011L\u0005\u0004\u0003\u0017*\"A\u0002+va2,'\u0007\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019&D\u0001\u0004mJ4\u0017\u0002BA,\u0003#\u0012\u0011B\u0016:g\u001fV$\b/\u001e;\u0011\t\u0005m\u00131\u000e\b\u0005\u0003;\nIG\u0004\u0003\u0002`\u0005\u001dd\u0002BA1\u0003KrA!!\u0004\u0002d%\t\u0001#\u0003\u0002\u000f\u001f%\u0011\u00010D\u0005\u0004\u000339\u0018\u0002BA7\u0003_\u00121cQ8og\u0016t7/^:TY>$h*^7cKJT1!!\u0007x\u0003Y1XM]5gs\u001a{'oZ5oON#\u0018m[3J]\u001a|GcB\u001d\u0002v\u0005}\u0014\u0011\u0012\u0005\b\u0003oJ\u0001\u0019AA=\u0003\u0019AW-\u00193feB\u0019q(a\u001f\n\u0007\u0005u\u0004I\u0001\u000bTS\u0012,7\r[1j]\ncwnY6IK\u0006$WM\u001d\u0005\b\u0003\u0003K\u0001\u0019AAB\u0003]\u0019H/Y6f\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eE\u0002w\u0003\u000bK1!a\"x\u0005]\u0019F/Y6f\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w\u000eC\u0004\u0002\f&\u0001\r!!\u0014\u0002\u0013Y\u0014hmT;uaV$\b")
public class ConsensusValidator
implements HistoryBlockValidator,
ScorexLogging {
    private final TimeProvider timeProvider;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Try<BoxedUnit> validate(SidechainBlock block, SidechainHistory history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (history.isGenesisBlock(block.id())) {
                this.validateGenesisBlock(block, history);
            } else {
                this.validateNonGenesisBlock(block, history);
            }
        });
    }

    private void validateGenesisBlock(SidechainBlock block, SidechainHistory history) {
        if (block.timestamp() != history.params().sidechainGenesisBlockTimestamp()) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Genesis block timestamp ").append(block.timestamp()).append(" is differ than expected timestamp from configuration ").append(history.params().sidechainGenesisBlockTimestamp()).toString());
        }
        boolean vrfSignIsNotCorrect = false;
        if (vrfSignIsNotCorrect) {
            throw new IllegalArgumentException("Genesis block timestamp is not signed his own forger box");
        }
    }

    private void validateNonGenesisBlock(SidechainBlock verifiedBlock, SidechainHistory history) {
        SidechainBlockInfo parentBlockInfo = history.blockInfoById(verifiedBlock.parentId());
        this.verifyTimestamp(verifiedBlock.timestamp(), parentBlockInfo.timestamp(), history.params());
        FullConsensusEpochInfo currentConsensusEpochInfo = history.getFullConsensusEpochInfoForBlock(verifiedBlock.timestamp(), verifiedBlock.parentId());
        VrfOutput vrfOutput = (VrfOutput)history.getVrfOutput(verifiedBlock.header(), currentConsensusEpochInfo.nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for block ").append(verifiedBlock.id()).append(" had been failed").toString());
        });
        this.verifyForgingStakeInfo(verifiedBlock.header(), currentConsensusEpochInfo.stakeConsensusEpochInfo(), vrfOutput);
        SidechainBlockInfo lastBlockInPreviousConsensusEpochInfo = history.blockInfoById(history.getLastBlockInPreviousConsensusEpoch(verifiedBlock.timestamp(), verifiedBlock.parentId()));
        FullConsensusEpochInfo previousFullConsensusEpochInfo = history.getFullConsensusEpochInfoForBlock(lastBlockInPreviousConsensusEpochInfo.timestamp(), lastBlockInPreviousConsensusEpochInfo.parentId());
        this.verifyOmmers(verifiedBlock, currentConsensusEpochInfo, (Option<FullConsensusEpochInfo>)new Some((Object)previousFullConsensusEpochInfo), verifiedBlock.parentId(), parentBlockInfo, history, (Seq<Tuple2<VrfOutput, Object>>)((Seq)Nil$.MODULE$));
        this.verifyTimestampInFuture(verifiedBlock.timestamp(), history);
    }

    private void verifyTimestamp(long verifiedBlockTimestamp, long parentBlockTimestamp, NetworkParams params) {
        int epochNumberForParentBlock;
        int absoluteSlotNumberForParentBlock;
        if (verifiedBlockTimestamp < parentBlockTimestamp) {
            throw new IllegalArgumentException("Block had been generated before parent block had been generated");
        }
        int absoluteSlotNumberForVerifiedBlock = TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(params, verifiedBlockTimestamp);
        if (absoluteSlotNumberForVerifiedBlock <= (absoluteSlotNumberForParentBlock = TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(params, parentBlockTimestamp))) {
            throw new IllegalArgumentException("Block absolute slot number is equal or less than parent block");
        }
        int epochNumberForVerifiedBlock = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params, verifiedBlockTimestamp);
        if (epochNumberForVerifiedBlock - (epochNumberForParentBlock = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(params, parentBlockTimestamp)) > 1) {
            throw new IllegalStateException("Whole epoch had been skipped");
        }
    }

    private void verifyTimestampInFuture(long verifiedBlockTimestamp, SidechainHistory history) {
        if (TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(history.params(), verifiedBlockTimestamp) > TimeToEpochUtils$.MODULE$.timeStampToAbsoluteSlotNumber(history.params(), this.timeProvider.time() / 1000L)) {
            throw new SidechainBlockSlotInFutureException("Block had been generated in the future", SidechainBlockSlotInFutureException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public void verifyOmmers(OmmersContainer ommersContainer, FullConsensusEpochInfo currentFullConsensusEpochInfo, Option<FullConsensusEpochInfo> previousFullConsensusEpochInfoOpt, String bestKnownParentId, SidechainBlockInfo bestKnownParentInfo, SidechainHistory history, Seq<Tuple2<VrfOutput, Object>> previousEpochOmmersInfoAccumulator) {
        Seq<Ommer> ommers = ommersContainer.ommers();
        if (ommers.isEmpty()) {
            return;
        }
        int ommersContainerEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(history.params(), ommersContainer.header().timestamp());
        ObjectRef accumulator = ObjectRef.create(previousEpochOmmersInfoAccumulator);
        IntRef previousOmmerEpochNumber = IntRef.create((int)ommersContainerEpochNumber);
        ObjectRef ommerCurrentFullConsensusEpochInfo = ObjectRef.create((Object)currentFullConsensusEpochInfo);
        ObjectRef ommerPreviousFullConsensusEpochInfoOpt = ObjectRef.create(previousFullConsensusEpochInfoOpt);
        ommers.foreach((Function1 & Serializable & scala.Serializable)ommer -> {
            ConsensusValidator.$anonfun$verifyOmmers$1(this, history, previousOmmerEpochNumber, ommerCurrentFullConsensusEpochInfo, previousFullConsensusEpochInfoOpt, ommersContainer, ommerPreviousFullConsensusEpochInfoOpt, bestKnownParentId, bestKnownParentInfo, accumulator, currentFullConsensusEpochInfo, ommersContainerEpochNumber, ommer);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyForgingStakeInfo(SidechainBlockHeader header, StakeConsensusEpochInfo stakeConsensusEpochInfo, VrfOutput vrfOutput) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Verify Forger box against root hash: {} by merkle path {}", new Object[]{stakeConsensusEpochInfo.rootHash(), new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.forgingStakeMerklePath().bytes())).deep().mkString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean forgingStakeIsCorrect = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.forgingStakeMerklePath().apply(header.forgingStakeInfo().hash())));
        if (!forgingStakeIsCorrect) {
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("Actual stakeInfo: rootHash: {}, totalStake: {}", new Object[]{stakeConsensusEpochInfo.rootHash(), BoxesRunTime.boxToLong((long)stakeConsensusEpochInfo.totalStake())});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new IllegalStateException(new StringBuilder(79).append("Forging stake merkle path in block ").append(header.id()).append(" is inconsistent to stakes merkle root hash ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(stakeConsensusEpochInfo.rootHash())).deep().mkString(",")).toString());
        }
        long value = header.forgingStakeInfo().stakeAmount();
        boolean stakeIsEnough = package$.MODULE$.vrfProofCheckAgainstStake(vrfOutput, value, stakeConsensusEpochInfo.totalStake());
        if (!stakeIsEnough) {
            throw new IllegalArgumentException(new StringBuilder(67).append("Stake value in forger box in block ").append(header.id()).append(" is not enough for to be forger.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$verifyOmmers$1(ConsensusValidator $this, SidechainHistory history$2, IntRef previousOmmerEpochNumber$1, ObjectRef ommerCurrentFullConsensusEpochInfo$1, Option previousFullConsensusEpochInfoOpt$1, OmmersContainer ommersContainer$1, ObjectRef ommerPreviousFullConsensusEpochInfoOpt$1, String bestKnownParentId$1, SidechainBlockInfo bestKnownParentInfo$1, ObjectRef accumulator$1, FullConsensusEpochInfo currentFullConsensusEpochInfo$1, int ommersContainerEpochNumber$1, Ommer ommer) {
        ConsensusEpochAndSlot ommerEpochAndSlot = TimeToEpochUtils$.MODULE$.timestampToEpochAndSlot(history$2.params(), ommer.header().timestamp());
        if (ommerEpochAndSlot.epochNumber() < previousOmmerEpochNumber$1.elem) {
            ommerCurrentFullConsensusEpochInfo$1.elem = (FullConsensusEpochInfo)previousFullConsensusEpochInfoOpt$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(40).append("Block ").append(ommersContainer$1.header().id()).append(" contains ommer two epochs before.").toString());
            });
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = None$.MODULE$;
        } else if (ommerEpochAndSlot.epochNumber() > previousOmmerEpochNumber$1.elem) {
            NonceConsensusEpochInfo nonce = history$2.calculateNonceForNonGenesisEpoch(bestKnownParentId$1, bestKnownParentInfo$1, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
            ommerCurrentFullConsensusEpochInfo$1.elem = new FullConsensusEpochInfo(currentFullConsensusEpochInfo$1.stakeConsensusEpochInfo(), nonce);
            ommerPreviousFullConsensusEpochInfoOpt$1.elem = previousFullConsensusEpochInfoOpt$1;
        }
        VrfOutput ommerVrfOutput = (VrfOutput)history$2.getVrfOutput(ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).nonceConsensusEpochInfo()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(36).append("VRF check for Ommer ").append(ommer.header().id()).append(" had been failed").toString());
        });
        $this.verifyForgingStakeInfo(ommer.header(), ((FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem).stakeConsensusEpochInfo(), ommerVrfOutput);
        $this.verifyOmmers(ommer, (FullConsensusEpochInfo)ommerCurrentFullConsensusEpochInfo$1.elem, (Option<FullConsensusEpochInfo>)((Option)ommerPreviousFullConsensusEpochInfoOpt$1.elem), bestKnownParentId$1, bestKnownParentInfo$1, history$2, (Seq<Tuple2<VrfOutput, Object>>)((Seq)accumulator$1.elem));
        if (ommerEpochAndSlot.epochNumber() < ommersContainerEpochNumber$1) {
            Tuple2 tuple2 = new Tuple2((Object)ommerVrfOutput, (Object)BoxesRunTime.boxToInteger((int)ommerEpochAndSlot.slotNumber()));
            accumulator$1.elem = (Seq)((Seq)accumulator$1.elem).$plus$colon((Object)tuple2, Seq$.MODULE$.canBuildFrom());
        }
        previousOmmerEpochNumber$1.elem = ommerEpochAndSlot.epochNumber();
    }

    public ConsensusValidator(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
    }
}

