/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.horizen.utils.BytesUtils;
import com.horizen.utils.MerklePathSerializer;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;

public class MerklePath
implements BytesSerializable {
    List<Pair<Byte, byte[]>> merklePath;

    public MerklePath(List<Pair<Byte, byte[]>> merklePath) {
        if (merklePath == null) {
            throw new IllegalArgumentException("Merkle path object is not defined.");
        }
        for (Pair<Byte, byte[]> pair : merklePath) {
            if (pair == null || pair.getValue() == null) {
                throw new IllegalArgumentException("Merkle path contains broken item inside");
            }
            if (pair.getValue().length == 32) continue;
            throw new IllegalArgumentException("Some of merkle path nodes contains broken bytes. Bytes expected to be SHA256 hash of length 32.");
        }
        this.merklePath = merklePath;
    }

    public List<Pair<Byte, byte[]>> merklePathList() {
        return Collections.unmodifiableList(this.merklePath);
    }

    public byte[] apply(byte[] leaf) {
        byte[] tmp = leaf;
        for (Pair<Byte, byte[]> node : this.merklePath) {
            if (node.getKey() == 0) {
                tmp = BytesUtils.reverseBytes(Utils.doubleSHA256HashOfConcatenation(BytesUtils.reverseBytes(node.getValue()), BytesUtils.reverseBytes(tmp)));
                continue;
            }
            tmp = BytesUtils.reverseBytes(Utils.doubleSHA256HashOfConcatenation(BytesUtils.reverseBytes(tmp), BytesUtils.reverseBytes(node.getValue())));
        }
        return tmp;
    }

    public byte[] bytes() {
        return this.serializer().toBytes((Object)this);
    }

    public ScorexSerializer serializer() {
        return MerklePathSerializer.getSerializer();
    }

    public boolean isLeftmost() {
        for (Pair<Byte, byte[]> neighbour : this.merklePath) {
            if (neighbour.getKey() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRightmost(byte[] leaf) {
        byte[] currentNode = leaf;
        for (Pair<Byte, byte[]> neighbour : this.merklePath) {
            if (neighbour.getKey() == 0) {
                currentNode = BytesUtils.reverseBytes(Utils.doubleSHA256HashOfConcatenation(BytesUtils.reverseBytes(neighbour.getValue()), BytesUtils.reverseBytes(currentNode)));
                continue;
            }
            if (!Arrays.equals(currentNode, neighbour.getValue())) {
                return false;
            }
            currentNode = BytesUtils.reverseBytes(Utils.doubleSHA256HashOfConcatenation(BytesUtils.reverseBytes(currentNode), BytesUtils.reverseBytes(neighbour.getValue())));
        }
        return true;
    }

    public int leafIndex() {
        int index = 0;
        for (int i = this.merklePath.size() - 1; i >= 0; --i) {
            index <<= 1;
            if (this.merklePath.get(i).getKey() != 0) continue;
            ++index;
        }
        return index;
    }

    public int hashCode() {
        int result = 1;
        for (Pair<Byte, byte[]> pair : this.merklePath) {
            result += 31 * result + pair.getKey().intValue() + Arrays.hashCode(pair.getValue());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MerklePath merklePath = (MerklePath)obj;
        if (this.merklePath.size() != merklePath.merklePath.size()) {
            return false;
        }
        for (int i = 0; i < this.merklePath.size(); ++i) {
            Pair<Byte, byte[]> pair = this.merklePath.get(i);
            Pair<Byte, byte[]> otherPair = merklePath.merklePath.get(i);
            if (pair.getKey().equals(otherPair.getKey()) && Arrays.equals(pair.getValue(), otherPair.getValue())) continue;
            return false;
        }
        return true;
    }
}

