/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import java.util.ArrayList;
import java.util.List;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;

public class ListSerializer<T extends BytesSerializable>
implements ScorexSerializer<List<T>> {
    private ScorexSerializer<T> serializer;
    private int maxListLength;

    public ListSerializer(ScorexSerializer<T> serializer) {
        this(serializer, 0);
    }

    public ListSerializer(ScorexSerializer<T> serializer, int maxListLength) {
        this.maxListLength = maxListLength;
        this.serializer = serializer;
    }

    public void serialize(List<T> objectsList, Writer writer) {
        if (this.maxListLength > 0 && objectsList.size() > this.maxListLength) {
            throw new IllegalArgumentException("Serializable data contains too many elements - " + objectsList.size());
        }
        writer.putInt(objectsList.size());
        for (BytesSerializable object : objectsList) {
            this.serializer.serialize((Object)object, writer);
        }
    }

    public List<T> parse(Reader reader) {
        int objectsCount = reader.getInt();
        if (objectsCount < 0) {
            throw new IllegalArgumentException("Input data contains illegal elements count - " + objectsCount);
        }
        if (this.maxListLength > 0 && objectsCount > this.maxListLength) {
            throw new IllegalArgumentException("Input data contains to many elements - " + objectsCount);
        }
        ArrayList<BytesSerializable> objectsList = new ArrayList<BytesSerializable>(objectsCount);
        for (int i = 0; i < objectsCount; ++i) {
            BytesSerializable parseObject = (BytesSerializable)this.serializer.parse(reader);
            objectsList.add(parseObject);
        }
        return objectsList;
    }
}

