/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.horizen.utils.Pair;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import scorex.crypto.hash.Sha256;

public final class Ed25519 {
    private Ed25519() {
    }

    public static int privateKeyLength() {
        return 32;
    }

    public static int publicKeyLength() {
        return 32;
    }

    public static int signatureLength() {
        return 64;
    }

    public static Pair<byte[], byte[]> createKeyPair(byte[] seed) {
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(Sha256.hash((byte[])seed), 0);
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new Pair<byte[], byte[]>(privateKey.getEncoded(), publicKey.getEncoded());
    }

    public static boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        try {
            return org.bouncycastle.math.ec.rfc8032.Ed25519.verify((byte[])signature, (int)0, (byte[])publicKey, (int)0, (byte[])message, (int)0, (int)message.length);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte[] sign(byte[] privateKey, byte[] message, byte[] publicKey) {
        byte[] signature = new byte[64];
        org.bouncycastle.math.ec.rfc8032.Ed25519.sign((byte[])privateKey, (int)0, (byte[])publicKey, (int)0, (byte[])null, (byte[])message, (int)0, (int)message.length, (byte[])signature, (int)0);
        return signature;
    }
}

