/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.box.Box;
import com.horizen.box.BoxUnlocker;
import com.horizen.box.data.BoxData;
import com.horizen.proof.Proof;
import com.horizen.proposition.Proposition;
import com.horizen.transaction.CoreTransactionsIdsEnum;
import com.horizen.transaction.SidechainCoreTransactionSerializer;
import com.horizen.transaction.SidechainNoncedTransaction;
import com.horizen.transaction.TransactionSerializer;
import com.horizen.transaction.exception.TransactionSemanticValidityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import scala.Array;

public final class SidechainCoreTransaction
extends SidechainNoncedTransaction<Proposition, Box<Proposition>, BoxData<Proposition, Box<Proposition>>> {
    public static final byte SIDECHAIN_CORE_TRANSACTION_VERSION = 1;
    final List<byte[]> inputsIds;
    private final List<BoxData<Proposition, Box<Proposition>>> outputsData;
    final List<Proof<Proposition>> proofs;
    private final long fee;
    private final byte version;
    private List<BoxUnlocker<Proposition>> unlockers;

    public SidechainCoreTransaction(List<byte[]> inputsIds, List<BoxData<Proposition, Box<Proposition>>> outputsData, List<Proof<Proposition>> proofs, long fee, byte version) {
        Objects.requireNonNull(inputsIds, "Inputs Ids list can't be null.");
        Objects.requireNonNull(outputsData, "Outputs Data list can't be null.");
        Objects.requireNonNull(proofs, "Proofs list can't be null.");
        this.inputsIds = inputsIds;
        this.outputsData = outputsData;
        this.proofs = proofs;
        this.fee = fee;
        this.version = version;
    }

    public TransactionSerializer serializer() {
        return SidechainCoreTransactionSerializer.getSerializer();
    }

    @Override
    public synchronized List<BoxUnlocker<Proposition>> unlockers() {
        if (this.unlockers == null) {
            this.unlockers = new ArrayList<BoxUnlocker<Proposition>>();
            int i = 0;
            while (i < this.inputsIds.size() && i < this.proofs.size()) {
                final int finalI = i++;
                BoxUnlocker<Proposition> unlocker = new BoxUnlocker<Proposition>(){

                    @Override
                    public byte[] closedBoxId() {
                        return SidechainCoreTransaction.this.inputsIds.get(finalI);
                    }

                    @Override
                    public Proof boxKey() {
                        return SidechainCoreTransaction.this.proofs.get(finalI);
                    }
                };
                this.unlockers.add(unlocker);
            }
        }
        return Collections.unmodifiableList(this.unlockers);
    }

    @Override
    protected List<BoxData<Proposition, Box<Proposition>>> getOutputData() {
        return this.outputsData;
    }

    @Override
    public long fee() {
        return this.fee;
    }

    @Override
    public void transactionSemanticValidity() throws TransactionSemanticValidityException {
        if (this.version != 1) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: unsupported version number.", this.id()));
        }
        if (this.inputsIds.isEmpty() || this.outputsData.isEmpty()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no input and output data present.", this.id()));
        }
        if (this.inputsIds.size() != this.proofs.size() || this.inputsIds.size() != this.boxIdsToOpen().size()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: inputs number is not consistent to proofs number.", this.id()));
        }
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.SidechainCoreTransactionId.id();
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    @Override
    public byte[] customFieldsData() {
        return Array.emptyByteArray();
    }

    @Override
    public byte[] customDataMessageToSign() {
        return Array.emptyByteArray();
    }
}

