/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.cryptolibprovider.CryptoLibProvider$;
import com.horizen.cryptolibprovider.InMemorySparseMerkleTreeWrapper;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.horizen.utils.UtxoMerkleTreeLeafInfo;
import com.horizen.utils.UtxoMerkleTreeLeafInfoSerializer$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.Optional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\n\u0014\u0001iA\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006i\u0001!\t!\u000e\u0005\bq\u0001\u0001\r\u0011\"\u0001:\u0011\u001d\u0001\u0005\u00011A\u0005\u0002\u0005Caa\u0012\u0001!B\u0013Q\u0004\"\u0002%\u0001\t\u0013I\u0005B\u0002&\u0001\t\u0003)2\nC\u0003`\u0001\u0011\u0005\u0001\rC\u0003s\u0001\u0011\u00051\u000f\u0003\u0004w\u0001\u0011\u0005Qc\u001e\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002L!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0002$'&$Wm\u00195bS:\u001cF/\u0019;f+RDx.T3sW2,GK]3f'R|'/Y4f\u0015\t!R#A\u0004ti>\u0014\u0018mZ3\u000b\u0005Y9\u0012a\u00025pe&TXM\u001c\u0006\u00021\u0005\u00191m\\7\u0004\u0001M)\u0001aG\u0011*[A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u000511oY8sKbL!\u0001K\u0012\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h!\tQ3&D\u0001\u0014\u0013\ta3C\u0001\u000bTS\u0012,7\r[1j]N#xN]1hK&sgm\u001c\t\u0003]=j\u0011!F\u0005\u0003aU\u0011abU5eK\u000eD\u0017-\u001b8UsB,7\u000f\u0005\u0002+e%\u00111g\u0005\u0002\b'R|'/Y4f\u0003\u0019a\u0014N\\5u}Q\u0011ag\u000e\t\u0003U\u0001AQ\u0001\u0006\u0002A\u0002E\n\u0011#\\3sW2,GK]3f/J\f\u0007\u000f]3s+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u0016\u0003E\u0019'/\u001f9u_2L'\r\u001d:pm&$WM]\u0005\u0003\u007fq\u0012q$\u00138NK6|'/_*qCJ\u001cX-T3sW2,GK]3f/J\f\u0007\u000f]3s\u0003UiWM]6mKR\u0013X-Z,sCB\u0004XM]0%KF$\"AQ#\u0011\u0005q\u0019\u0015B\u0001#\u001e\u0005\u0011)f.\u001b;\t\u000f\u0019#\u0011\u0011!a\u0001u\u0005\u0019\u0001\u0010J\u0019\u0002%5,'o\u001b7f)J,Wm\u0016:baB,'\u000fI\u0001\u000fY>\fG-T3sW2,GK]3f)\u0005Q\u0014!D2bY\u000e,H.\u0019;f\u0019\u0016\fg\r\u0006\u0002M%B\u0011Q\nU\u0007\u0002\u001d*\u0011q*F\u0001\u0012Y&\u0014'/^:ug&$Wm\u00195bS:\u001c\u0018BA)O\u000511\u0015.\u001a7e\u000b2,W.\u001a8u\u0011\u0015\u0019v\u00011\u0001U\u0003\r\u0011w\u000e\u001f\t\u0004+^KV\"\u0001,\u000b\u0005M+\u0012B\u0001-W\u0005\r\u0011u\u000e\u001f\t\u00035vk\u0011a\u0017\u0006\u00039V\t1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&\u0011al\u0017\u0002\f!J|\u0007o\\:ji&|g.A\u0006hKRdU-\u00194J]\u001a|GCA1k!\ra\"\rZ\u0005\u0003Gv\u0011aa\u00149uS>t\u0007CA3i\u001b\u00051'BA4\u0016\u0003\u0015)H/\u001b7t\u0013\tIgM\u0001\fVib|W*\u001a:lY\u0016$&/Z3MK\u00064\u0017J\u001c4p\u0011\u0015Y\u0007\u00021\u0001m\u0003\u0015\u0011w\u000e_%e!\raRn\\\u0005\u0003]v\u0011Q!\u0011:sCf\u0004\"\u0001\b9\n\u0005El\"\u0001\u0002\"zi\u0016\fQbZ3u\u001b\u0016\u00148\u000e\\3QCRDGC\u0001;v!\ra\"\r\u001c\u0005\u0006W&\u0001\r\u0001\\\u0001\u0011O\u0016$\u0018\t\u001c7MK\u00064Xm]%oM>,\u0012\u0001\u001f\t\u0005s\u0006\rAM\u0004\u0002{\u007f:\u00111P`\u0007\u0002y*\u0011Q0G\u0001\u0007yI|w\u000e\u001e \n\u0003yI1!!\u0001\u001e\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0002\u0002\b\t\u00191+Z9\u000b\u0007\u0005\u0005Q$A\thKRlUM]6mKR\u0013X-\u001a*p_R,\u0012\u0001\\\u0001\u0007kB$\u0017\r^3\u0015\u0011\u0005E\u00111DA\u0013\u0003W\u0001R!a\u0005\u0002\u0018Yj!!!\u0006\u000b\u0005\u0011j\u0012\u0002BA\r\u0003+\u00111\u0001\u0016:z\u0011\u001d\ti\u0002\u0004a\u0001\u0003?\tqA^3sg&|g\u000eE\u0002f\u0003CI1!a\tg\u0005A\u0011\u0015\u0010^3BeJ\f\u0017p\u0016:baB,'\u000fC\u0004\u0002(1\u0001\r!!\u000b\u0002\u001b\t|\u00070Z:U_\u0006\u0003\b/\u001a8e!\u0011I\u00181\u0001+\t\u000f\u00055B\u00021\u0001\u00020\u0005\u0001\"m\u001c=fgR{'+Z7pm\u0016\u001cV\r\u001e\t\u0007\u0003c\tI$a\b\u000f\t\u0005M\u0012Q\u0007\t\u0003wvI1!a\u000e\u001e\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\r\u0019V\r\u001e\u0006\u0004\u0003oi\u0012!\u00047bgR4VM]:j_:LE-\u0006\u0002\u0002DA!ADYA\u0010\u0003A\u0011x\u000e\u001c7cC\u000e\\g+\u001a:tS>t7\u000f\u0006\u0002\u0002JA)\u00110a\u0001\u0002 Q!\u0011QJA*!\u0015I\u0018qJA\u0010\u0013\u0011\t\t&a\u0002\u0003\t1K7\u000f\u001e\u0005\b\u0003+z\u0001\u0019AA,\u0003Mi\u0017\r\u001f(v[\n,'o\u00144WKJ\u001c\u0018n\u001c8t!\ra\u0012\u0011L\u0005\u0004\u00037j\"aA%oi\u0006A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0003\u0002\u0012\u0005\u0005\u0004bBA\u000f!\u0001\u0007\u0011qD\u0001\bSN,U\u000e\u001d;z+\t\t9\u0007E\u0002\u001d\u0003SJ1!a\u001b\u001e\u0005\u001d\u0011un\u001c7fC:\u0004")
public class SidechainStateUtxoMerkleTreeStorage
implements ScorexLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private InMemorySparseMerkleTreeWrapper merkleTreeWrapper;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public InMemorySparseMerkleTreeWrapper merkleTreeWrapper() {
        return this.merkleTreeWrapper;
    }

    public void merkleTreeWrapper_$eq(InMemorySparseMerkleTreeWrapper x$1) {
        this.merkleTreeWrapper = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public InMemorySparseMerkleTreeWrapper com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree() {
        void var2_2;
        int treeHeight = CryptoLibProvider$.MODULE$.cswCircuitFunctions().utxoMerkleTreeHeight();
        InMemorySparseMerkleTreeWrapper merkleTree = new InMemorySparseMerkleTreeWrapper(treeHeight);
        scala.collection.immutable.Map newLeaves = ((TraversableOnce)this.getAllLeavesInfo().map((Function1 & Serializable & scala.Serializable)leafInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.long2Long(leafInfo.position())), (Object)FieldElement.deserialize((byte[])leafInfo.leaf())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        try {
            merkleTree.addLeaves((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newLeaves).asJava());
        }
        finally {
            newLeaves.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                SidechainStateUtxoMerkleTreeStorage.$anonfun$loadMerkleTree$2(x$1);
                return BoxedUnit.UNIT;
            });
        }
        return var2_2;
    }

    public FieldElement calculateLeaf(Box<Proposition> box) {
        return CryptoLibProvider$.MODULE$.cswCircuitFunctions().getUtxoMerkleTreeLeaf(box);
    }

    public Option<UtxoMerkleTreeLeafInfo> getLeafInfo(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try<UtxoMerkleTreeLeafInfo> try_ = UtxoMerkleTreeLeafInfoSerializer$.MODULE$.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                UtxoMerkleTreeLeafInfo leafInfo = (UtxoMerkleTreeLeafInfo)success.value();
                option2 = Option$.MODULE$.apply((Object)leafInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while UtxoMerkleTreeLeafInfo parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getMerklePath(byte[] boxId) {
        return this.getLeafInfo(boxId).map((Function1 & Serializable & scala.Serializable)leafInfo -> this.merkleTreeWrapper().merklePath(leafInfo.position()));
    }

    public Seq<UtxoMerkleTreeLeafInfo> getAllLeavesInfo() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).map((Function1 & Serializable & scala.Serializable)pair -> (UtxoMerkleTreeLeafInfo)UtxoMerkleTreeLeafInfoSerializer$.MODULE$.parseBytes(((ByteArrayWrapper)pair.getValue()).data()), Buffer$.MODULE$.canBuildFrom());
    }

    public byte[] getMerkleTreeRoot() {
        return this.merkleTreeWrapper().calculateRoot();
    }

    public Try<SidechainStateUtxoMerkleTreeStorage> update(ByteArrayWrapper version, Seq<Box<Proposition>> boxesToAppend, Set<ByteArrayWrapper> boxesToRemoveSet) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(boxesToAppend != null, (Function0 & Serializable & scala.Serializable)() -> "List of boxes to add must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxesToRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            java.util.List removeList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)boxesToRemoveSet.map((Function1 & Serializable & scala.Serializable)id -> Utils.calculateKey(id.data()), Set$.MODULE$.canBuildFrom())).toList()).asJava();
            Predef$.MODULE$.require(this.merkleTreeWrapper().removeLeaves((long[])((TraversableOnce)boxesToRemoveSet.flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(this.getLeafInfo(id.data()).map((Function1 & Serializable & scala.Serializable)leafInfo -> BoxesRunTime.boxToLong((long)leafInfo.position()))), Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long())), (Function0 & Serializable & scala.Serializable)() -> "Failed to remove leaves from UtxoMerkleTree");
            Seq newLeavesPositions = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.merkleTreeWrapper().leftmostEmptyPositions(boxesToAppend.size())).asScala()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x)), Buffer$.MODULE$.canBuildFrom());
            if (newLeavesPositions.size() != boxesToAppend.size()) {
                throw new IllegalStateException("Not enough empty leaves in the UTXOMerkleTree.");
            }
            Seq leavesToAppend = (Seq)((IterableLike)boxesToAppend.map((Function1 & Serializable & scala.Serializable)box -> new Tuple2((Object)Utils.calculateKey(box.id()), (Object)this.calculateLeaf((Box<Proposition>)box)), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)newLeavesPositions, Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(this.merkleTreeWrapper().addLeaves((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)leavesToAppend.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FieldElement leaf;
                long position;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        position = tuple2._2$mcJ$sp();
                        if (tuple22 != null && (leaf = (FieldElement)tuple22._2()) != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FieldElement fieldElement = leaf;
                long l = position;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.long2Long(l)), (Object)fieldElement);
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), (Function0 & Serializable & scala.Serializable)() -> "Failed to add leaves to UtxoMerkleTree");
            java.util.List updateList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leavesToAppend.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ByteArrayWrapper byteArrayWrapper;
                FieldElement leaf;
                long position;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = x0$2;
                        if (tuple2 == null) break block2;
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        position = tuple2._2$mcJ$sp();
                        if (tuple22 == null) break block2;
                        ByteArrayWrapper key = (ByteArrayWrapper)tuple22._1();
                        leaf = (FieldElement)tuple22._2();
                        if (key == null) break block2;
                        byteArrayWrapper = key;
                        if (leaf != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                FieldElement fieldElement = leaf;
                long l = position;
                byte[] leafBytes = fieldElement.serializeFieldElement();
                fieldElement.freeFieldElement();
                Pair<ByteArrayWrapper, ByteArrayWrapper> pair = new Pair<ByteArrayWrapper, ByteArrayWrapper>(byteArrayWrapper, new ByteArrayWrapper(new UtxoMerkleTreeLeafInfo(leafBytes, l).bytes()));
                return pair;
            }, Seq$.MODULE$.canBuildFrom())).asJava();
            $this.storage.update(version, updateList, removeList);
            return this;
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SidechainStateUtxoMerkleTreeStorage $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.merkleTreeWrapper().close();
                this.$outer.merkleTreeWrapper_$eq(this.$outer.com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree());
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<SidechainStateUtxoMerkleTreeStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            this.merkleTreeWrapper().close();
            this.merkleTreeWrapper_$eq(this.com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree());
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$loadMerkleTree$2(Tuple2 x$1) {
        ((FieldElement)x$1._2()).close();
    }

    public SidechainStateUtxoMerkleTreeStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        this.merkleTreeWrapper = this.com$horizen$storage$SidechainStateUtxoMerkleTreeStorage$$loadMerkleTree();
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
    }
}

