/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.SidechainTypes;
import com.horizen.backup.BackupBox;
import com.horizen.backup.BoxIterator;
import com.horizen.block.WithdrawalEpochCertificate;
import com.horizen.block.WithdrawalEpochCertificateSerializer$;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.WithdrawalRequestBoxSerializer;
import com.horizen.box.ZenBox;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.consensus.package$;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.storage.StorageIterator;
import com.horizen.storage.leveldb.package$Constants$;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.BlockFeeInfo;
import com.horizen.utils.BlockFeeInfoSerializer$;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.utils.WithdrawalEpochInfoSerializer$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001\u0002\u0015*\u0001AB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\")\u0011\u000b\u0001C\u0001%\"Aa\u000b\u0001b\u0001\n\u0003Ys\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019Q\u0007\u0001)A\u0005C\"A1\u000e\u0001b\u0001\n\u0003Ys\u000b\u0003\u0004m\u0001\u0001\u0006I\u0001\u0017\u0005\t[\u0002\u0011\r\u0011\"\u0001,/\"1a\u000e\u0001Q\u0001\naCqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\u0007k\u0002!\ta\u000b<\t\re\u0004A\u0011A\u0016{\u0011\u0019q\b\u0001\"\u0001,\u007f\"A\u0011Q\u0001\u0001C\u0002\u0013%\u0001\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011B9\t\u0011\u0005%\u0001\u0001\"\u0001,\u0003\u0017A\u0001\"!\u0005\u0001\t\u0003Y\u00131\u0003\u0005\t\u00033\u0001A\u0011A\u0016\u0002\u001c!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003o\u0003A\u0011AA]\u0011\u001d\tI\u000e\u0001C\u0001\u00037DqA!\t\u0001\t\u0003\u0012\u0019\u0003C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003.!9!\u0011\b\u0001\u0005\u0002\tm\u0002b\u0002B \u0001\u0011\u0005\u0011q\u0016\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001b\u0012QcU5eK\u000eD\u0017-\u001b8Ti\u0006$Xm\u0015;pe\u0006<WM\u0003\u0002+W\u000591\u000f^8sC\u001e,'B\u0001\u0017.\u0003\u001dAwN]5{K:T\u0011AL\u0001\u0004G>l7\u0001A\n\u0006\u0001E:th\u0011\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001B;uS2T\u0011\u0001P\u0001\u0007g\u000e|'/\u001a=\n\u0005yJ$!D*d_J,\u0007\u0010T8hO&tw\r\u0005\u0002A\u00036\t\u0011&\u0003\u0002CS\t!2+\u001b3fG\"\f\u0017N\\*u_J\fw-Z%oM>\u0004\"\u0001R#\u000e\u0003-J!AR\u0016\u0003\u001dMKG-Z2iC&tG+\u001f9fgB\u0011\u0001\tS\u0005\u0003\u0013&\u0012qa\u0015;pe\u0006<W-A\ftS\u0012,7\r[1j]\n{\u00070Z:D_6\u0004\u0018M\\5p]B\u0011AjT\u0007\u0002\u001b*\u0011ajK\u0001\nG>l\u0007/\u00198j_:L!\u0001U'\u0003/MKG-Z2iC&t'i\u001c=fg\u000e{W\u000e]1oS>t\u0017A\u0002\u001fj]&$h\bF\u0002T)V\u0003\"\u0001\u0011\u0001\t\u000b)\u001a\u0001\u0019A$\t\u000b)\u001b\u0001\u0019A&\u0002;]LG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8s[\u0006$\u0018n\u001c8LKf,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037.\nQ!\u001e;jYNL!!\u0018.\u0003!\tKH/Z!se\u0006LxK]1qa\u0016\u0014\u0018AH<ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|'/\\1uS>t7*Z=!\u0003m9\u0018\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f^*fe&\fG.\u001b>feV\t\u0011\rE\u0002ZE\u0012L!a\u0019.\u0003\u001d1K7\u000f^*fe&\fG.\u001b>feB\u0011Q\r[\u0007\u0002M*\u0011qmK\u0001\u0004E>D\u0018BA5g\u0005Q9\u0016\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f\u001e\"pq\u0006ar/\u001b;iIJ\fw/\u00197SKF,Xm\u001d;TKJL\u0017\r\\5{KJ\u0004\u0013!E2p]N,gn];t\u000bB|7\r[&fs\u0006\u00112m\u001c8tK:\u001cXo]#q_\u000eD7*Z=!\u0003=\u0019W-Y:j]\u001e\u001cF/\u0019;f\u0017\u0016L\u0018\u0001E2fCNLgnZ*uCR,7*Z=!\u0003})h\u000eZ3gS:,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM]\u000b\u0002cB\u0011!G]\u0005\u0003gN\u00121!\u00138u\u0003\u0001*h\u000eZ3gS:,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM\u001d\u0011\u00029\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM]&fsR\u0011\u0001l\u001e\u0005\u0006q:\u0001\r!]\u0001\u0010o&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u0006Ar-\u001a;XSRDGM]1xC2\u0014V-];fgR\u001c8*Z=\u0015\u0007a[H\u0010C\u0003y\u001f\u0001\u0007\u0011\u000fC\u0003~\u001f\u0001\u0007\u0011/A\u0004d_VtG/\u001a:\u00027\u001d,G\u000fV8q#V\fG.\u001b;z\u0007\u0016\u0014H/\u001b4jG\u0006$XmS3z)\rA\u0016\u0011\u0001\u0005\u0007\u0003\u0007\u0001\u0002\u0019A9\u00023I,g-\u001a:f]\u000e,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\u0001\u001dk:$WMZ5oK\u0012\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0007>,h\u000e^3s\u0003u)h\u000eZ3gS:,GM\u00117pG.4U-Z%oM>\u001cu.\u001e8uKJ\u0004\u0013!G4fi\ncwnY6GK\u0016LeNZ8D_VtG/\u001a:LKf$2\u0001WA\u0007\u0011\u0019\tya\u0005a\u0001c\u0006)r/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007NT;nE\u0016\u0014\u0018AE4fi\ncwnY6GK\u0016LeNZ8LKf$R\u0001WA\u000b\u0003/Aa!a\u0004\u0015\u0001\u0004\t\b\"B?\u0015\u0001\u0004\t\u0018\u0001G4fiV#\bp\\'fe.dW\r\u0016:fKJ{w\u000e^&fsR\u0019\u0001,!\b\t\r\u0005=Q\u00031\u0001r\u0003\u00199W\r\u001e\"pqR!\u00111EA\u001e!\u0015\u0011\u0014QEA\u0015\u0013\r\t9c\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0015\fY#a\f\n\u0007\u00055bMA\u0002C_b\u0004B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003kY\u0013a\u00039s_B|7/\u001b;j_:LA!!\u000f\u00024\tY\u0001K]8q_NLG/[8o\u0011\u001d\tiD\u0006a\u0001\u0003\u007f\tQAY8y\u0013\u0012\u0004RAMA!\u0003\u000bJ1!a\u00114\u0005\u0015\t%O]1z!\r\u0011\u0014qI\u0005\u0004\u0003\u0013\u001a$\u0001\u0002\"zi\u0016\facZ3u/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\\\u000b\u0003\u0003\u001f\u0002RAMA\u0013\u0003#\u00022!WA*\u0013\r\t)F\u0017\u0002\u0014/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\\\u0001\u001aO\u0016$x+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ8v]R,'\u000fF\u0002r\u00037Ba!!\u0018\u0019\u0001\u0004\t\u0018!B3q_\u000eD\u0017AF4fi\ncwnY6GK\u0016LeNZ8D_VtG/\u001a:\u0015\u0007E\f\u0019\u0007\u0003\u0004\u0002\u0010e\u0001\r!]\u0001\u000fO\u0016$h)Z3QCflWM\u001c;t)\u0011\tI'a\"\u0011\r\u0005-\u00141PAA\u001d\u0011\ti'a\u001e\u000f\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d0\u0003\u0019a$o\\8u}%\tA'C\u0002\u0002zM\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002~\u0005}$aA*fc*\u0019\u0011\u0011P\u001a\u0011\u0007e\u000b\u0019)C\u0002\u0002\u0006j\u0013AB\u00117pG.4U-Z%oM>Da!a\u0004\u001b\u0001\u0004\t\u0018!F4fi^KG\u000f\u001b3sC^\fGNU3rk\u0016\u001cHo\u001d\u000b\u0005\u0003\u001b\u000by\tE\u0003\u0002l\u0005mD\rC\u0003y7\u0001\u0007\u0011/\u0001\rhKR$v\u000e])vC2LG/_\"feRLg-[2bi\u0016$B!!&\u0002$B)!'!\n\u0002\u0018B!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001e.\nQA\u00197pG.LA!!)\u0002\u001c\nQr+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ3si&4\u0017nY1uK\"1\u00111\u0001\u000fA\u0002E\fQcZ3u+RDx.T3sW2,GK]3f%>|G\u000f\u0006\u0003\u0002*\u0006-\u0006#\u0002\u001a\u0002&\u0005}\u0002\"\u0002=\u001e\u0001\u0004\t\u0018!\u00035bg\u000e+\u0017m]3e+\t\t\t\fE\u00023\u0003gK1!!.4\u0005\u001d\u0011un\u001c7fC:\fqcZ3u\u0007>t7/\u001a8tkN,\u0005o\\2i\u001dVl'-\u001a:\u0016\u0005\u0005m\u0006#\u0002\u001a\u0002&\u0005u\u0006\u0003BA`\u0003'tA!!1\u0002P:!\u00111YAf\u001d\u0011\t)-!3\u000f\t\u0005=\u0014qY\u0005\u0002]%\u0011A&L\u0005\u0004\u0003\u001b\\\u0013!C2p]N,gn];t\u0013\u0011\tI(!5\u000b\u0007\u000557&\u0003\u0003\u0002V\u0006]'\u0001F\"p]N,gn];t\u000bB|7\r\u001b(v[\n,'O\u0003\u0003\u0002z\u0005E\u0017AB;qI\u0006$X\r\u0006\f\u0002^\u0006\u001d\u00181^Ax\u0005\u0007\u0011IA!\u0004\u0003\u0012\tU!\u0011\u0004B\u000f!\u0015\ty.a9T\u001b\t\t\tO\u0003\u0002;g%!\u0011Q]Aq\u0005\r!&/\u001f\u0005\u0007\u0003S\u0004\u0003\u0019\u0001-\u0002\u000fY,'o]5p]\"9\u0011Q\u001e\u0011A\u0002\u0005E\u0013aE<ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|\u0007bBAyA\u0001\u0007\u00111_\u0001\u000eE>DX\u000b\u001d3bi\u0016d\u0015n\u001d;\u0011\r\u0005U\u0018Q`A\u0015\u001d\u0011\t90!?\u0011\u0007\u0005=4'C\u0002\u0002|N\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0000\u0005\u0003\u00111aU3u\u0015\r\tYp\r\u0005\b\u0005\u000b\u0001\u0003\u0019\u0001B\u0004\u0003=\u0011w\u000e_%egJ+Wn\u001c<f'\u0016$\b#BA{\u0003{D\u0006b\u0002B\u0006A\u0001\u0007\u0011QR\u0001\u001bo&$\b\u000e\u001a:bo\u0006d'+Z9vKN$\u0018\t\u001d9f]\u0012\u001cV-\u001d\u0005\b\u0005\u001f\u0001\u0003\u0019AA_\u00039\u0019wN\\:f]N,8/\u00129pG\"DqAa\u0005!\u0001\u0004\t)*\u0001\ru_B\fV/\u00197jif\u001cUM\u001d;jM&\u001c\u0017\r^3PaRDqAa\u0006!\u0001\u0004\t\t)\u0001\u0007cY>\u001c7NR3f\u0013:4w\u000eC\u0004\u0003\u001c\u0001\u0002\r!!+\u0002+U$\bp\\'fe.dW\r\u0016:fKJ{w\u000e^(qi\"9!q\u0004\u0011A\u0002\u0005E\u0016aC:d\u0011\u0006\u001c8)Z1tK\u0012\fQ\u0002\\1tiZ+'o]5p]&#WC\u0001B\u0013!\u0011\u0011\u0014Q\u0005-\u0002!I|G\u000e\u001c2bG.4VM]:j_:\u001cHC\u0001B\u0016!\u0015\tY'a\u001fY)\u0011\u0011yC!\u000e\u0011\u000b\u0005-$\u0011\u0007-\n\t\tM\u0012q\u0010\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004\u00038\r\u0002\r!]\u0001\u0014[\u0006Dh*^7cKJ|eMV3sg&|gn]\u0001\te>dGNY1dWR!\u0011Q\u001cB\u001f\u0011\u0019\tI\u000f\na\u00011\u00069\u0011n]#naRL\u0018aC4fi&#XM]1u_J,\"A!\u0012\u0011\u0007\u0001\u00139%C\u0002\u0003J%\u0012qb\u0015;pe\u0006<W-\u0013;fe\u0006$xN]\u0001\u000ee\u0016\u001cHo\u001c:f\u0005\u0006\u001c7.\u001e9\u0015\r\t=#Q\u000bB3!\r\u0011$\u0011K\u0005\u0004\u0005'\u001a$\u0001B+oSRDqAa\u0016(\u0001\u0004\u0011I&\u0001\rcC\u000e\\W\u000f]*u_J\fw-\u001a\"pq&#XM]1u_J\u0004BAa\u0017\u0003b5\u0011!Q\f\u0006\u0004\u0005?Z\u0013A\u00022bG.,\b/\u0003\u0003\u0003d\tu#a\u0003\"pq&#XM]1u_JDqAa\u001a(\u0001\u0004\ty$A\u0006mCN$h+\u001a:tS>t\u0007")
public class SidechainStateStorage
implements ScorexLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final ByteArrayWrapper withdrawalEpochInformationKey;
    private final ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer;
    private final ByteArrayWrapper consensusEpochKey;
    private final ByteArrayWrapper ceasingStateKey;
    private final int undefinedWithdrawalEpochCounter;
    private final int undefinedBlockFeeInfoCounter;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper withdrawalEpochInformationKey() {
        return this.withdrawalEpochInformationKey;
    }

    private ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer() {
        return this.withdrawalRequestSerializer;
    }

    public ByteArrayWrapper consensusEpochKey() {
        return this.consensusEpochKey;
    }

    public ByteArrayWrapper ceasingStateKey() {
        return this.ceasingStateKey;
    }

    private int undefinedWithdrawalEpochCounter() {
        return this.undefinedWithdrawalEpochCounter;
    }

    public ByteArrayWrapper getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getWithdrawalRequestsKey(int withdrawalEpoch, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getTopQualityCertificateKey(int referencedWithdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"topQualityCertificate".getBytes(), Ints.toByteArray((int)referencedWithdrawalEpoch)}));
    }

    private int undefinedBlockFeeInfoCounter() {
        return this.undefinedBlockFeeInfoCounter;
    }

    public ByteArrayWrapper getBlockFeeInfoCounterKey(int withdrawalEpochNumber) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfoCounter".getBytes(), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public ByteArrayWrapper getBlockFeeInfoKey(int withdrawalEpochNumber, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfo".getBytes(), Ints.toByteArray((int)withdrawalEpochNumber), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getUtxoMerkleTreeRootKey(int withdrawalEpochNumber) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"utxoMerkleTreeRoot".getBytes(), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public Option<Box<Proposition>> getBox(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainBoxesCompanion.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Box box = (Box)success.value();
                option2 = Option$.MODULE$.apply((Object)box);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while WalletBox parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<WithdrawalEpochInfo> getWithdrawalEpochInfo() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochInformationKey())));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochInfo> try_ = WithdrawalEpochInfoSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochInfo withdrawalEpochInfo = (WithdrawalEpochInfo)success.value();
                option3 = Option$.MODULE$.apply((Object)withdrawalEpochInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch info information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public int getWithdrawalEpochCounter(int epoch) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getWithdrawalEpochCounterKey(epoch))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedWithdrawalEpochCounter()));
        } else {
            n = this.undefinedWithdrawalEpochCounter();
        }
        return n;
    }

    private int getBlockFeeInfoCounter(int withdrawalEpochNumber) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getBlockFeeInfoCounterKey(withdrawalEpochNumber))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedBlockFeeInfoCounter()));
        } else {
            n = this.undefinedBlockFeeInfoCounter();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<BlockFeeInfo> getFeePayments(int withdrawalEpochNumber) {
        void var2_2;
        ListBuffer blockFees = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getBlockFeeInfoCounter(withdrawalEpochNumber);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getBlockFeeInfoKey(withdrawalEpochNumber, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try<BlockFeeInfo> try_ = BlockFeeInfoSerializer$.MODULE$.parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while fee payment parsing.", exception);
                    }
                    throw new MatchError(try_);
                }
                Success success = (Success)try_;
                BlockFeeInfo info = (BlockFeeInfo)success.value();
                blockFees.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockFeeInfo[]{info}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while fee payments retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<WithdrawalRequestBox> getWithdrawalRequests(int withdrawalEpoch) {
        void var2_2;
        ListBuffer withdrawalRequests = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getWithdrawalEpochCounter(withdrawalEpoch);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getWithdrawalRequestsKey(withdrawalEpoch, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try try_ = this.withdrawalRequestSerializer().parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while withdrawal requests parsing.", exception);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                java.util.List wr = (java.util.List)success.value();
                withdrawalRequests.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(wr).asScala());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while withdrawal requests retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getTopQualityCertificateKey(referencedWithdrawalEpoch))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochCertificate> try_ = WithdrawalEpochCertificateSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochCertificate certificate = (WithdrawalEpochCertificate)success.value();
                option3 = Option$.MODULE$.apply((Object)certificate);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch certificate information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getUtxoMerkleTreeRoot(int withdrawalEpoch) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getUtxoMerkleTreeRootKey(withdrawalEpoch)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    public boolean hasCeased() {
        return this.storage.get(this.ceasingStateKey()).isPresent();
    }

    public Option<Object> getConsensusEpochNumber() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.consensusEpochKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.intToConsensusEpochNumber(epoch)));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while consensus epoch information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Try<SidechainStateStorage> update(ByteArrayWrapper version, WithdrawalEpochInfo withdrawalEpochInfo, Set<Box<Proposition>> boxUpdateList, Set<ByteArrayWrapper> boxIdsRemoveSet, Seq<WithdrawalRequestBox> withdrawalRequestAppendSeq, int consensusEpoch, Option<WithdrawalEpochCertificate> topQualityCertificateOpt, BlockFeeInfo blockFeeInfo, Option<byte[]> utxoMerkleTreeRootOpt, boolean scHasCeased) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Some some;
            WithdrawalEpochInfo storedEpochInfo;
            Object object2;
            Predef$.MODULE$.require(withdrawalEpochInfo != null, (Function0 & Serializable & scala.Serializable)() -> "WithdrawalEpochInfo must be NOT NULL.");
            Predef$.MODULE$.require(boxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Boxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!boxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Box to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveSet.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            Predef$.MODULE$.require(withdrawalRequestAppendSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of WithdrawalRequests to append must be NOT NULL. Use empty Seq instead.");
            Predef$.MODULE$.require(!withdrawalRequestAppendSeq.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WithdrawalRequest to append must be NOT NULL.");
            Predef$.MODULE$.require(blockFeeInfo != null, (Function0 & Serializable & scala.Serializable)() -> "BlockFeeInfo must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            boxIdsRemoveSet.foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)removeList.add(Utils.calculateKey(r.data()))));
            boxUpdateList.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(b.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(b))))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochInformationKey(), new ByteArrayWrapper(WithdrawalEpochInfoSerializer$.MODULE$.toBytes(withdrawalEpochInfo))));
            if (withdrawalRequestAppendSeq.nonEmpty()) {
                int nextWithdrawalEpochCounter = this.getWithdrawalEpochCounter(withdrawalEpochInfo.epoch()) + 1;
                updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalEpochCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextWithdrawalEpochCounter))));
                object2 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalRequestsKey(withdrawalEpochInfo.epoch(), nextWithdrawalEpochCounter), new ByteArrayWrapper(this.withdrawalRequestSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(withdrawalRequestAppendSeq).asJava())))));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            utxoMerkleTreeRootOpt.foreach((Function1 & Serializable & scala.Serializable)merkleRoot -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getUtxoMerkleTreeRootKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(merkleRoot)))));
            Option<WithdrawalEpochInfo> option = this.getWithdrawalEpochInfo();
            boolean bl = option instanceof Some ? (storedEpochInfo = (WithdrawalEpochInfo)(some = (Some)option).value()).epoch() != withdrawalEpochInfo.epoch() : false;
            boolean isWithdrawalEpochSwitched = bl;
            if (isWithdrawalEpochSwitched) {
                int wrEpochNumberToRemove = withdrawalEpochInfo.epoch() - 2;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getWithdrawalEpochCounter(wrEpochNumberToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getWithdrawalRequestsKey(wrEpochNumberToRemove, counter)));
                removeList.add(this.getWithdrawalEpochCounterKey(wrEpochNumberToRemove));
                int certEpochNumberToRemove = withdrawalEpochInfo.epoch() - 4;
                removeList.add(this.getTopQualityCertificateKey(certEpochNumberToRemove));
                removeList.add(this.getUtxoMerkleTreeRootKey(certEpochNumberToRemove));
                int blockFeeInfoEpochToRemove = withdrawalEpochInfo.epoch() - 1;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getBlockFeeInfoCounter(blockFeeInfoEpochToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getBlockFeeInfoKey(blockFeeInfoEpochToRemove, counter)));
                object = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getBlockFeeInfoCounterKey(blockFeeInfoEpochToRemove)));
            } else {
                object = BoxedUnit.UNIT;
            }
            topQualityCertificateOpt.foreach((Function1 & Serializable & scala.Serializable)certificate -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getTopQualityCertificateKey(certificate.epochNumber()), com.horizen.utils.package$.MODULE$.byteArrayToWrapper(WithdrawalEpochCertificateSerializer$.MODULE$.toBytes(certificate))))));
            int nextBlockFeeInfoCounter = this.getBlockFeeInfoCounter(withdrawalEpochInfo.epoch()) + 1;
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getBlockFeeInfoCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextBlockFeeInfoCounter))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getBlockFeeInfoKey(withdrawalEpochInfo.epoch(), nextBlockFeeInfoCounter), new ByteArrayWrapper(BlockFeeInfoSerializer$.MODULE$.toBytes(blockFeeInfo))));
            Object object3 = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.intToConsensusEpochNumber(0))) != consensusEpoch ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.consensusEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)consensusEpoch))))) : BoxedUnit.UNIT;
            Object object4 = scHasCeased ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.ceasingStateKey(), new ByteArrayWrapper(Array$.MODULE$.emptyByteArray())))) : BoxedUnit.UNIT;
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<SidechainStateStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public StorageIterator getIterator() {
        return this.storage.getIterator();
    }

    public void restoreBackup(BoxIterator backupStorageBoxIterator, byte[] lastVersion) {
        BoxedUnit boxedUnit;
        ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        ByteArrayWrapper lastVersionWrapper = new ByteArrayWrapper(lastVersion);
        Optional<BackupBox> optionalBox = backupStorageBoxIterator.nextBox();
        while (optionalBox.isPresent()) {
            BoxedUnit boxedUnit2;
            Box<Proposition> box = optionalBox.get().getBox();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(box.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(box))));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder(15).append("Restore Box id ").append(box.boxTypeId()).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            optionalBox = backupStorageBoxIterator.nextBox();
            if (updateList.size() != package$Constants$.MODULE$.BatchSize()) continue;
            if (optionalBox.isPresent()) {
                this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), updateList, removeList);
            } else {
                this.storage.update(lastVersionWrapper, updateList, removeList);
            }
            updateList.clear();
        }
        if (updateList.size() != 0) {
            this.storage.update(lastVersionWrapper, updateList, removeList);
        }
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("SidechainStateStorage restore completed successfully!");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SidechainStateStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        this.sidechainBoxesCompanion = sidechainBoxesCompanion;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this.withdrawalEpochInformationKey = Utils.calculateKey("withdrawalEpochInformation".getBytes());
        this.withdrawalRequestSerializer = new ListSerializer<WithdrawalRequestBox>(WithdrawalRequestBoxSerializer.getSerializer());
        this.consensusEpochKey = Utils.calculateKey("consensusEpoch".getBytes());
        this.ceasingStateKey = Utils.calculateKey("ceasingStateKey".getBytes());
        this.undefinedWithdrawalEpochCounter = -1;
        this.undefinedBlockFeeInfoCounter = -1;
    }
}

