/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.block.MainchainBlockReference;
import com.horizen.block.MainchainBlockReferenceData;
import com.horizen.block.MainchainHeader;
import com.horizen.block.SidechainBlock;
import com.horizen.block.SidechainBlockSerializer;
import com.horizen.chain.ActiveChain;
import com.horizen.chain.ActiveChain$;
import com.horizen.chain.FeePaymentsInfo;
import com.horizen.chain.FeePaymentsInfoSerializer$;
import com.horizen.chain.MainchainBlockReferenceDataInfo;
import com.horizen.chain.MainchainHeaderBaseInfo;
import com.horizen.chain.MainchainHeaderInfo;
import com.horizen.chain.MainchainHeaderMetadata;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.chain.SidechainBlockInfoSerializer$;
import com.horizen.chain.package$;
import com.horizen.companion.SidechainTransactionsCompanion;
import com.horizen.node.util.MainchainBlockReferenceInfo;
import com.horizen.params.NetworkParams;
import com.horizen.storage.SidechainBlockInfoProvider;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.vrf.VrfOutput;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.core.consensus.ModifierSemanticValidity;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001\u0002\u001c8\u0001yB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t/\u0002\u0011\t\u0011)A\u00051\"Aa\f\u0001B\u0001B\u0003%q\fC\u0003e\u0001\u0011\u0005Q\rC\u0004k\u0001\t\u0007I\u0011B6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\bA1A\u0005\nQDaa\u001f\u0001!\u0002\u0013)\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003\u007f\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002,\u0002!\t!!,\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003W\u0004A\u0011AAw\u0011\u001d\t\t\u0010\u0001C\u0001\u0003gDq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u000e\u0001!\tAa\u0004\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e!9!1\u0007\u0001\u0005\u0002\tU\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005{\u0001A\u0011\u0002B \u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005kBqAa \u0001\t\u0003\u0011\t\tC\u0004\u0003\f\u0002!\tA!$\t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\"9!q\u0013\u0001\u0005\u0002\te\u0005b\u0002BR\u0001\u0011\u0005!Q\u0015\u0005\b\u0005S\u0003A\u0011\u0001BV\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005cCqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003T\u0002!\tA!6\t\u000f\tm\u0007\u0001\"\u0001\u0003^\"9!\u0011\u001f\u0001\u0005\u0002\tM\bb\u0002B~\u0001\u0011\u0005!Q \u0005\b\u0007\u0007\u0001A\u0011AB\u0003\u0011\u001d\u00199\u0001\u0001C!\u0007\u0013\u0011qcU5eK\u000eD\u0017-\u001b8ISN$xN]=Ti>\u0014\u0018mZ3\u000b\u0005aJ\u0014aB:u_J\fw-\u001a\u0006\u0003um\nq\u0001[8sSj,gNC\u0001=\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001q(R%M!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0011aiR\u0007\u0002o%\u0011\u0001j\u000e\u0002\u001b'&$Wm\u00195bS:\u0014En\\2l\u0013:4w\u000e\u0015:pm&$WM\u001d\t\u0003\r*K!aS\u001c\u0003)MKG-Z2iC&t7\u000b^8sC\u001e,\u0017J\u001c4p!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003vi&d'\"A)\u0002\rM\u001cwN]3y\u0013\t\u0019fJA\u0007TG>\u0014X\r\u001f'pO\u001eLgn\u001a\t\u0003\rVK!AV\u001c\u0003\u000fM#xN]1hK\u0006q2/\u001b3fG\"\f\u0017N\u001c+sC:\u001c\u0018m\u0019;j_:\u001c8i\\7qC:LwN\u001c\t\u00033rk\u0011A\u0017\u0006\u00037f\n\u0011bY8na\u0006t\u0017n\u001c8\n\u0005uS&AH*jI\u0016\u001c\u0007.Y5o)J\fgn]1di&|gn]\"p[B\fg.[8o\u0003\u0019\u0001\u0018M]1ngB\u0011\u0001MY\u0007\u0002C*\u0011a,O\u0005\u0003G\u0006\u0014QBT3uo>\u00148\u000eU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003gO\"L\u0007C\u0001$\u0001\u0011\u0015AD\u00011\u0001U\u0011\u00159F\u00011\u0001Y\u0011\u0015qF\u00011\u0001`\u0003a\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.\u001cVM]5bY&TXM]\u000b\u0002YB\u0011Q\u000e]\u0007\u0002]*\u0011q.O\u0001\u0006E2|7m[\u0005\u0003c:\u0014\u0001dU5eK\u000eD\u0017-\u001b8CY>\u001c7nU3sS\u0006d\u0017N_3s\u0003e\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.\u001cVM]5bY&TXM\u001d\u0011\u0002\u001d\t,7\u000f\u001e\"m_\u000e\\\u0017\nZ&fsV\tQ\u000f\u0005\u0002ws6\tqO\u0003\u0002ys\u0005)Q\u000f^5mg&\u0011!p\u001e\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJ\fqBY3ti\ncwnY6JI.+\u0017\u0010I\u0001\fC\u000e$\u0018N^3DQ\u0006Lg.F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001:\u0003\u0015\u0019\u0007.Y5o\u0013\u0011\t9!!\u0001\u0003\u0017\u0005\u001bG/\u001b<f\u0007\"\f\u0017N\\\u0001\rC\u000e$\u0018N^3DQ\u0006Lg\u000eI\u0001\u0010Y>\fG-Q2uSZ,7\t[1j]R\ta0\u0001\u0007cY>\u001c7.\u00138g_.+\u0017\u0010F\u0002v\u0003'Aq!!\u0006\r\u0001\u0004\t9\"A\u0004cY>\u001c7.\u00133\u0011\t\u0005e\u0011Q\u0006\b\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rR(\u0001\u0004=e>|GOP\u0005\u0002#&\u0011q\nU\u0005\u0004\u0003Wq\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003_\t\tD\u0001\u0006N_\u0012Lg-[3s\u0013\u0012T1!a\u000bO\u0003I1W-\u001a)bs6,g\u000e^:J]\u001a|7*Z=\u0015\u0007U\f9\u0004C\u0004\u0002\u00165\u0001\r!a\u0006\u0002\r!,\u0017n\u001a5u+\t\ti\u0004E\u0002A\u0003\u007fI1!!\u0011B\u0005\rIe\u000e^\u0001\tQ\u0016Lw\r\u001b;PMR!\u0011qIA'!\u0015\u0001\u0015\u0011JA\u001f\u0013\r\tY%\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005Uq\u00021\u0001\u0002\u0018\u0005Y!-Z:u\u00052|7m[%e+\t\t9\"A\u0005cKN$(\t\\8dWV\u0011\u0011q\u000b\t\u0004[\u0006e\u0013bAA.]\nq1+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017!\u00042fgR\u0014En\\2l\u0013:4w.\u0006\u0002\u0002bA\u0019q0a\u0019\n\t\u0005\u0015\u0014\u0011\u0001\u0002\u0013'&$Wm\u00195bS:\u0014En\\2l\u0013:4w.A\u0005cY>\u001c7NQ=JIR!\u00111NA7!\u0015\u0001\u0015\u0011JA,\u0011\u001d\t)b\u0005a\u0001\u0003/\tQB\u00197pG.LeNZ8Cs&#G\u0003BA1\u0003gBq!!\u0006\u0015\u0001\u0004\t9\"A\ncY>\u001c7.\u00138g_>\u0003H/[8o\u0005fLE\r\u0006\u0003\u0002z\u0005m\u0004#\u0002!\u0002J\u0005\u0005\u0004bBA\u000b+\u0001\u0007\u0011qC\u0001\u001fE2|7m[%oM>|\u0005\u000f^5p]\nK\u0018\n\u001a$s_6\u001cFo\u001c:bO\u0016$B!!\u001f\u0002\u0002\"9\u0011Q\u0003\fA\u0002\u0005]\u0011\u0001\u00072m_\u000e\\\u0017J\u001c4p\u0005fLEM\u0012:p[N#xN]1hKR!\u0011\u0011MAD\u0011\u001d\t)b\u0006a\u0001\u0003/\tqeZ3u\u0019\u0006\u001cH/T1j]\u000eD\u0017-\u001b8IK\u0006$WM\u001d\"bg\u0016LeNZ8J]\u000edWo]5p]R!\u0011QRAJ!\ry\u0018qR\u0005\u0005\u0003#\u000b\tAA\fNC&t7\r[1j]\"+\u0017\rZ3s\u0005\u0006\u001cX-\u00138g_\"9\u0011Q\u0003\rA\u0002\u0005]\u0011!\u00049be\u0016tGO\u00117pG.LE\r\u0006\u0003\u0002\u001a\u0006m\u0005#\u0002!\u0002J\u0005]\u0001bBA\u000b3\u0001\u0007\u0011qC\u0001\u000eG\"\f\u0017N\\*d_J,gi\u001c:\u0015\t\u0005\u0005\u0016\u0011\u0016\t\u0006\u0001\u0006%\u00131\u0015\t\u0004\u0001\u0006\u0015\u0016bAAT\u0003\n!Aj\u001c8h\u0011\u001d\t)B\u0007a\u0001\u0003/\tq\"[:J]\u0006\u001bG/\u001b<f\u0007\"\f\u0017N\u001c\u000b\u0005\u0003_\u000b)\fE\u0002A\u0003cK1!a-B\u0005\u001d\u0011un\u001c7fC:Dq!!\u0006\u001c\u0001\u0004\t9\"\u0001\nbGRLg/Z\"iC&t'\t\\8dW&#G\u0003BAM\u0003wCq!!\u000f\u001d\u0001\u0004\ti$\u0001\tbGRLg/Z\"iC&t\u0017I\u001a;feR1\u0011\u0011YAi\u0003'\u0004b!a1\u0002L\u0006]a\u0002BAc\u0003\u0013tA!a\b\u0002H&\t!)C\u0002\u0002,\u0005KA!!4\u0002P\n\u00191+Z9\u000b\u0007\u0005-\u0012\tC\u0004\u0002\u0016u\u0001\r!a\u0006\t\u000f\u0005UW\u00041\u0001\u0002H\u0005)A.[7ji\u0006Qs-\u001a;TS\u0012,7\r[1j]\ncwnY6D_:$\u0018-\u001b8j]\u001el\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014H\u0003BA6\u00037Dq!!8\u001f\u0001\u0004\ty.A\nnC&t7\r[1j]\"+\u0017\rZ3s\u0011\u0006\u001c\b\u000eE\u0003A\u0003C\f)/C\u0002\u0002d\u0006\u0013Q!\u0011:sCf\u00042\u0001QAt\u0013\r\tI/\u0011\u0002\u0005\u0005f$X-A\u0019hKR\u001c\u0016\u000eZ3dQ\u0006LgN\u00117pG.\u001cuN\u001c;bS:LgnZ'bS:\u001c\u0007.Y5o%\u00164WM]3oG\u0016$\u0015\r^1\u0015\t\u0005-\u0014q\u001e\u0005\b\u0003;|\u0002\u0019AAp\u0003\u0001:W\r^'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\u0005fD\u0015m\u001d5\u0015\t\u0005U\u0018Q \t\u0006\u0001\u0006%\u0013q\u001f\t\u0004[\u0006e\u0018bAA~]\n9R*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a\u0005\b\u0003;\u0004\u0003\u0019AAp\u0003a9W\r^'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:Cs\"\u000b7\u000f\u001b\u000b\u0005\u0005\u0007\u0011Y\u0001E\u0003A\u0003\u0013\u0012)\u0001E\u0002n\u0005\u000fI1A!\u0003o\u0005=i\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014\bbBAoC\u0001\u0007\u0011q\\\u0001 O\u0016$X*Y5oG\"\f\u0017N\u001c*fM\u0016\u0014XM\\2f\t\u0006$\u0018MQ=ICNDG\u0003\u0002B\t\u00053\u0001R\u0001QA%\u0005'\u00012!\u001cB\u000b\u0013\r\u00119B\u001c\u0002\u001c\u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016$\u0015\r^1\t\u000f\u0005u'\u00051\u0001\u0002`\u0006!t-\u001a;NC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK&sgm\u001c\"z\u001b\u0006Lgn\u00195bS:\u0014En\\2l\u0011\u0016Lw\r\u001b;\u0015\t\t}!q\u0006\t\u0006\u0001\u0006%#\u0011\u0005\t\u0005\u0005G\u0011Y#\u0004\u0002\u0003&)\u0019qJa\n\u000b\u0007\t%\u0012(\u0001\u0003o_\u0012,\u0017\u0002\u0002B\u0017\u0005K\u00111$T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3J]\u001a|\u0007b\u0002B\u0019G\u0001\u0007\u0011QH\u0001\u0010[\u0006Lgn\u00195bS:DU-[4ii\u0006\u0011s-\u001a;CKN$X*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-Z%oM>,\"Aa\b\u0002I\u001d,G/T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3J]\u001a|')\u001f%bg\"$BAa\b\u0003<!9\u0011Q\\\u0013A\u0002\u0005}\u0017\u0001\t2vS2$W*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-Z%oM>$BB!\t\u0003B\tu#q\rB6\u0005_BqAa\u0011'\u0001\u0004\u0011)%\u0001\u0004nG\"\u000b7\u000f\u001b\t\u0005\u0005\u000f\u00129F\u0004\u0003\u0003J\tUc\u0002\u0002B&\u0005'rAA!\u0014\u0003R9!\u0011q\u0004B(\u0013\u0005a\u0014B\u0001\u001e<\u0013\r\t\u0019!O\u0005\u0005\u0003W\t\t!\u0003\u0003\u0003Z\tm#aE'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:ICND'\u0002BA\u0016\u0003\u0003AqAa\u0018'\u0001\u0004\u0011\t'A\u0007sK\u001a,'/\u001a8dK&sgm\u001c\t\u0004\u007f\n\r\u0014\u0002\u0002B3\u0003\u0003\u0011q#T1j]\u000eD\u0017-\u001b8IK\u0006$WM]'fi\u0006$\u0017\r^1\t\u000f\t%d\u00051\u0001\u0002>\u0005iQn\u0019\"m_\u000e\\\u0007*Z5hQRDqA!\u001c'\u0001\u0004\t9\"A\u0010nC&t7\r[1j]\"+\u0017\rZ3s'&$Wm\u00195bS:\u0014En\\2l\u0013\u0012DqA!\u001d'\u0001\u0004\t9\"\u0001\u0014nC&t7\r[1j]J+g-\u001a:f]\u000e,G)\u0019;b'&$Wm\u00195bS:\u0014En\\2l\u0013\u0012\fAdZ3u\u001b\u0006Lgn\u00195bS:D\u0015m\u001d5fg\u001a{'/\u00138eKb,7\u000f\u0006\u0003\u0003x\te\u0004CBAb\u0003\u0017\u0014)\u0005C\u0004\u0003|\u001d\u0002\rA! \u0002!5\f\u0017N\\2iC&t\u0007*Z5hQR\u001c\bCBAb\u0003\u0017\fi$\u0001\u000ehKR\u0014Um\u001d;NC&t7\r[1j]\"+\u0017\rZ3s\u0013:4w.\u0006\u0002\u0003\u0004B)\u0001)!\u0013\u0003\u0006B\u0019qPa\"\n\t\t%\u0015\u0011\u0001\u0002\u0014\u001b\u0006Lgn\u00195bS:DU-\u00193fe&sgm\\\u0001\u001fO\u0016$X*Y5oG\"\f\u0017N\u001c%fC\u0012,'/\u00138g_\nK\b*Z5hQR$BAa!\u0003\u0010\"9!\u0011G\u0015A\u0002\u0005u\u0012\u0001H4fi6\u000b\u0017N\\2iC&t\u0007*Z1eKJLeNZ8Cs\"\u000b7\u000f\u001b\u000b\u0005\u0005\u0007\u0013)\nC\u0004\u0002^*\u0002\r!a8\u0002M\u001d,GOQ3ti6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4w.\u0006\u0002\u0003\u001cB)\u0001)!\u0013\u0003\u001eB\u0019qPa(\n\t\t\u0005\u0016\u0011\u0001\u0002 \u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016$\u0015\r^1J]\u001a|\u0017AK4fi6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4wNQ=IK&<\u0007\u000e\u001e\u000b\u0005\u00057\u00139\u000bC\u0004\u000321\u0002\r!!\u0010\u0002Q\u001d,G/T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\f\u0017J\u001c4p\u0005fD\u0015m\u001d5\u0015\t\tm%Q\u0016\u0005\b\u0003;l\u0003\u0019AAp\u0003\u0019)\b\u000fZ1uKR1!1\u0017B_\u0005\u007f\u0003RA!.\u0003:\u001al!Aa.\u000b\u0005=\u000b\u0015\u0002\u0002B^\u0005o\u00131\u0001\u0016:z\u0011\u0019yg\u00061\u0001\u0002X!9!\u0011\u0019\u0018A\u0002\u0005\u0005\u0014!\u00032m_\u000e\\\u0017J\u001c4p\u0003U)\b\u000fZ1uK\u001a+W\rU1z[\u0016tGo]%oM>$bAa-\u0003H\n%\u0007bBA\u000b_\u0001\u0007\u0011q\u0003\u0005\b\u0005\u0017|\u0003\u0019\u0001Bg\u0003=1W-\u001a)bs6,g\u000e^:J]\u001a|\u0007cA@\u0003P&!!\u0011[A\u0001\u0005=1U-\u001a)bs6,g\u000e^:J]\u001a|\u0017AE4fi\u001a+W\rU1z[\u0016tGo]%oM>$BAa6\u0003ZB)\u0001)!\u0013\u0003N\"9\u0011Q\u0003\u0019A\u0002\u0005]\u0011\u0001E:f[\u0006tG/[2WC2LG-\u001b;z)\u0011\u0011yNa<\u0011\t\t\u0005(1^\u0007\u0003\u0005GTAA!:\u0003h\u0006I1m\u001c8tK:\u001cXo\u001d\u0006\u0004\u0005S\u0004\u0016\u0001B2pe\u0016LAA!<\u0003d\nARj\u001c3jM&,'oU3nC:$\u0018n\u0019,bY&$\u0017\u000e^=\t\u000f\u0005U\u0011\u00071\u0001\u0002\u0018\u00051R\u000f\u001d3bi\u0016\u001cV-\\1oi&\u001cg+\u00197jI&$\u0018\u0010\u0006\u0004\u00034\nU(q\u001f\u0005\u0007_J\u0002\r!a\u0016\t\u000f\te(\u00071\u0001\u0003`\u000611\u000f^1ukN\fab]3u\u0003N\u0014Um\u001d;CY>\u001c7\u000e\u0006\u0004\u00034\n}8\u0011\u0001\u0005\u0007_N\u0002\r!a\u0016\t\u000f\t\u00057\u00071\u0001\u0002b\u00059\u0011n]#naRLXCAAX\u00035a\u0017m\u001d;WKJ\u001c\u0018n\u001c8JIV\u001111\u0002\t\u0005\u0001\u0006%S\u000f")
public class SidechainHistoryStorage
implements SidechainBlockInfoProvider,
SidechainStorageInfo,
ScorexLogging {
    private final Storage storage;
    private final NetworkParams params;
    private final SidechainBlockSerializer sidechainBlockSerializer;
    private final ByteArrayWrapper bestBlockIdKey;
    private final ActiveChain activeChain;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SidechainBlockSerializer sidechainBlockSerializer() {
        return this.sidechainBlockSerializer;
    }

    private ByteArrayWrapper bestBlockIdKey() {
        return this.bestBlockIdKey;
    }

    private ActiveChain activeChain() {
        return this.activeChain;
    }

    private ActiveChain loadActiveChain() {
        if (this.storage.isEmpty()) {
            return ActiveChain$.MODULE$.apply(this.params.mainchainCreationBlockHeight());
        }
        ArrayBuffer activeChainBlocksInfo = new ArrayBuffer();
        activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.bestBlockId(), (Object)this.blockInfoByIdFromStorage(this.bestBlockId()))}));
        while (((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).height() > 1) {
            String id = ((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).parentId();
            activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)id, (Object)this.blockInfoByIdFromStorage(id))}));
        }
        ArrayBuffer orderedChainBlocks = (ArrayBuffer)activeChainBlocksInfo.reverse();
        Option mainchainBlockParent = orderedChainBlocks.headOption().flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlockInfo -> this.blockById((String)firstSidechainBlockInfo._1()).flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlock -> firstSidechainBlock.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)firstMainchainHeader -> package$.MODULE$.byteArrayToMainchainHeaderHash(firstMainchainHeader.hashPrevBlock()))));
        return ActiveChain$.MODULE$.apply((ArrayBuffer<Tuple2<String, SidechainBlockInfo>>)orderedChainBlocks, (ByteArrayWrapper)mainchainBlockParent.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Loaded active chain miss mainchain parent");
        }), this.params.mainchainCreationBlockHeight());
    }

    private ByteArrayWrapper blockInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(9).append("blockInfo").append(blockId).toString()));
    }

    private ByteArrayWrapper feePaymentsInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(15).append("feePaymentsInfo").append(blockId).toString()));
    }

    public int height() {
        return this.activeChain().height();
    }

    public Option<Object> heightOf(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.height()));
    }

    public String bestBlockId() {
        return (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.bestBlockIdKey()))).map((Function1 & Serializable & scala.Serializable)d -> scorex.util.package$.MODULE$.bytesToId(d.data())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.params.sidechainGenesisBlockId());
    }

    public SidechainBlock bestBlock() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return (SidechainBlock)this.blockById(this.bestBlockId()).get();
    }

    public SidechainBlockInfo bestBlockInfo() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return this.blockInfoById(this.bestBlockId());
    }

    public Option<SidechainBlock> blockById(String blockId) {
        None$ none$;
        ByteArrayWrapper blockIdBytes = new ByteArrayWrapper(scorex.util.package$.MODULE$.idToBytes(blockId));
        Option baw = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(blockIdBytes)));
        Option option = baw;
        if (option instanceof Some) {
            Option option2;
            Some some = (Some)option;
            ByteArrayWrapper value = (ByteArrayWrapper)some.value();
            Try<SidechainBlock> try_ = this.sidechainBlockSerializer().parseBytesTry(com.horizen.utils.package$.MODULE$.wrapperToByteArray(value));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainBlock block = (SidechainBlock)success.value();
                option2 = Option$.MODULE$.apply((Object)block);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while sidechain block parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            none$ = option2;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("SidechainHistoryStorage:blockById: byte array is empty");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public SidechainBlockInfo blockInfoById(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionById(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(24).append("No block info for block ").append(blockId).toString());
        });
    }

    public Option<SidechainBlockInfo> blockInfoOptionById(String blockId) {
        return this.activeChain().blockInfoById(blockId).orElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoOptionByIdFromStorage(blockId));
    }

    private Option<SidechainBlockInfo> blockInfoOptionByIdFromStorage(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.blockInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> SidechainBlockInfoSerializer$.MODULE$.parseBytesTry(baw.data()).toOption());
    }

    private SidechainBlockInfo blockInfoByIdFromStorage(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionByIdFromStorage(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(36).append("No blockInfo in storage for blockId ").append(blockId).toString());
        });
    }

    public MainchainHeaderBaseInfo getLastMainchainHeaderBaseInfoInclusion(String blockId) {
        SidechainBlockInfo sidechainBlockInfo = this.blockInfoById(blockId);
        while (sidechainBlockInfo.mainchainHeaderBaseInfo().isEmpty()) {
            sidechainBlockInfo = this.blockInfoById(sidechainBlockInfo.parentId());
        }
        return (MainchainHeaderBaseInfo)sidechainBlockInfo.mainchainHeaderBaseInfo().last();
    }

    public Option<String> parentBlockId(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parentId());
    }

    public Option<Object> chainScoreFor(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.score()));
    }

    public boolean isInActiveChain(String blockId) {
        return this.activeChain().contains(blockId);
    }

    public Option<String> activeChainBlockId(int height) {
        return this.activeChain().idByHeight(height);
    }

    public Seq<String> activeChainAfter(String blockId, Option<Object> limit) {
        return this.activeChain().chainAfter(blockId, limit);
    }

    public Option<SidechainBlock> getSidechainBlockContainingMainchainHeader(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcHeader(package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<SidechainBlock> getSidechainBlockContainingMainchainReferenceData(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcReferenceData(package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<MainchainBlockReference> getMainchainBlockReferenceByHash(byte[] mainchainHeaderHash) {
        return this.getMainchainHeaderByHash(mainchainHeaderHash).flatMap((Function1 & Serializable & scala.Serializable)header -> this.getMainchainReferenceDataByHash(mainchainHeaderHash).map((Function1 & Serializable & scala.Serializable)data -> new MainchainBlockReference((MainchainHeader)header, (MainchainBlockReferenceData)data)));
    }

    public Option<MainchainHeader> getMainchainHeaderByHash(byte[] mainchainHeaderHash) {
        Option<SidechainBlock> sidechainBlock = this.getSidechainBlockContainingMainchainHeader(mainchainHeaderHash);
        return sidechainBlock.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)SidechainHistoryStorage.$anonfun$getMainchainHeaderByHash$2(mainchainHeaderHash, header))));
    }

    public Option<MainchainBlockReferenceData> getMainchainReferenceDataByHash(byte[] mainchainHeaderHash) {
        Option<SidechainBlock> sidechainBlock = this.getSidechainBlockContainingMainchainReferenceData(mainchainHeaderHash);
        return sidechainBlock.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mainchainBlockReferencesData().find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)SidechainHistoryStorage.$anonfun$getMainchainReferenceDataByHash$2(mainchainHeaderHash, data))));
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByMainchainBlockHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).flatMap((Function1 & Serializable & scala.Serializable)hash -> this.getMainchainBlockReferenceInfoByHash(com.horizen.utils.package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)hash)));
    }

    public Option<MainchainBlockReferenceInfo> getBestMainchainBlockReferenceInfo() {
        return this.getMainchainBlockReferenceInfoByMainchainBlockHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> SidechainHistoryStorage.$anonfun$getMainchainBlockReferenceInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    private MainchainBlockReferenceInfo buildMainchainBlockReferenceInfo(ByteArrayWrapper mcHash, MainchainHeaderMetadata referenceInfo, int mcBlockHeight, String mainchainHeaderSidechainBlockId, String mainchainReferenceDataSidechainBlockId) {
        return new MainchainBlockReferenceInfo(com.horizen.utils.package$.MODULE$.wrapperToByteArray(mcHash), com.horizen.utils.package$.MODULE$.wrapperToByteArray(referenceInfo.getParentId()), mcBlockHeight, scorex.util.package$.MODULE$.idToBytes(mainchainHeaderSidechainBlockId), scorex.util.package$.MODULE$.idToBytes(mainchainReferenceDataSidechainBlockId));
    }

    public Seq<ByteArrayWrapper> getMainchainHashesForIndexes(Seq<Object> mainchainHeights) {
        return (Seq)mainchainHeights.flatMap((Function1 & Serializable & scala.Serializable)mainchainHeight -> Option$.MODULE$.option2Iterable(this.activeChain().mcHashByMcHeight(BoxesRunTime.unboxToInt((Object)mainchainHeight))), Seq$.MODULE$.canBuildFrom());
    }

    public Option<MainchainHeaderInfo> getBestMainchainHeaderInfo() {
        return this.getMainchainHeaderInfoByHeight(this.activeChain().heightOfMcHeaders());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainHeaderInfo)this.getMainchainHeaderInfoByHash(com.horizen.utils.package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcHeadersHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> SidechainHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Option<MainchainBlockReferenceDataInfo> getBestMainchainBlockReferenceDataInfo() {
        return this.getMainchainBlockReferenceDataInfoByHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainBlockReferenceDataInfo)this.getMainchainBlockReferenceDataInfoByHash(com.horizen.utils.package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> SidechainHistoryStorage.$anonfun$getMainchainBlockReferenceDataInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Try<SidechainHistoryStorage> update(SidechainBlock block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(block != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBlock must be NOT NULL.");
            String string = block.parentId();
            String string2 = blockInfo.parentId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Passed BlockInfo data conflicts to passed Block.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes())));
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(scorex.util.package$.MODULE$.idToBytes(block.id())), new ByteArrayWrapper(block.bytes())));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<SidechainHistoryStorage> updateFeePaymentsInfo(String blockId, FeePaymentsInfo feePaymentsInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(com.horizen.utils.package$.MODULE$.byteArrayToWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.feePaymentsInfoKey(blockId)), new ByteArrayWrapper(feePaymentsInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<FeePaymentsInfo> getFeePaymentsInfo(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.feePaymentsInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> FeePaymentsInfoSerializer$.MODULE$.parseBytesTry(baw.data()).toOption());
    }

    public ModifierSemanticValidity semanticValidity(String blockId) {
        ModifierSemanticValidity.Absent$ absent$;
        Option<SidechainBlockInfo> option = this.blockInfoOptionById(blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainBlockInfo info = (SidechainBlockInfo)some.value();
            absent$ = info.semanticValidity();
        } else if (None$.MODULE$.equals(option)) {
            absent$ = ModifierSemanticValidity.Absent$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return absent$;
    }

    public Try<SidechainHistoryStorage> updateSemanticValidity(SidechainBlock block, ModifierSemanticValidity status) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainBlockInfo oldInfo = (SidechainBlockInfo)this.activeChain().blockInfoById(block.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoById(block.id()));
            ModifierSemanticValidity x$1 = status;
            int x$2 = oldInfo.copy$default$1();
            long x$3 = oldInfo.copy$default$2();
            String x$4 = oldInfo.copy$default$3();
            long x$5 = oldInfo.copy$default$4();
            Seq<MainchainHeaderBaseInfo> x$6 = oldInfo.copy$default$6();
            Seq<ByteArrayWrapper> x$7 = oldInfo.copy$default$7();
            WithdrawalEpochInfo x$8 = oldInfo.copy$default$8();
            Option<VrfOutput> x$9 = oldInfo.copy$default$9();
            String x$10 = oldInfo.copy$default$10();
            SidechainBlockInfo blockInfo = oldInfo.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<SidechainHistoryStorage> setAsBestBlock(SidechainBlock block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.bestBlockIdKey(), new ByteArrayWrapper(scorex.util.package$.MODULE$.idToBytes(block.id())))}), new ArrayList<ByteArrayWrapper>());
            Option mainchainParent = block.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)header -> package$.MODULE$.byteArrayToMainchainHeaderHash(header.hashPrevBlock()));
            this.activeChain().setBestBlock(block.id(), blockInfo, (Option<ByteArrayWrapper>)mainchainParent);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderByHash$2(byte[] mainchainHeaderHash$2, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$2)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.hash()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainReferenceDataByHash$2(byte[] mainchainHeaderHash$3, MainchainBlockReferenceData data) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$3)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(data.headerHash()));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceInfoByHash$1(SidechainHistoryStorage $this, ByteArrayWrapper mcHash$1, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)headerContainingId -> $this.activeChain().idByMcReferenceData(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)dataContainingId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$1).map((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.buildMainchainBlockReferenceInfo(mcHash$1, (MainchainHeaderMetadata)mcMetadata, mcHeight, (String)headerContainingId, (String)dataContainingId))));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderInfoByHash$5(ByteArrayWrapper mcHash$2, MainchainHeaderBaseInfo info) {
        return info.hash().equals(mcHash$2);
    }

    public static final /* synthetic */ Option $anonfun$getMainchainHeaderInfoByHash$1(SidechainHistoryStorage $this, ByteArrayWrapper mcHash$2, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)sidechainBlockId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.activeChain().blockInfoById((String)sidechainBlockId).flatMap((Function1 & Serializable & scala.Serializable)blockInfo -> blockInfo.mainchainHeaderBaseInfo().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)SidechainHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$5(mcHash$2, info))).map((Function1 & Serializable & scala.Serializable)mainchainBaseInfo -> new MainchainHeaderInfo(mcHash$2, mcMetadata.getParentId(), mcHeight, (String)sidechainBlockId, mainchainBaseInfo.cumulativeCommTreeHash())))));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceDataInfoByHash$1(SidechainHistoryStorage $this, ByteArrayWrapper mcHash$3, int mcHeight) {
        return $this.activeChain().idByMcReferenceData(mcHash$3).map((Function1 & Serializable & scala.Serializable)sidechainBlockId -> new MainchainBlockReferenceDataInfo(mcHash$3, mcHeight, (String)sidechainBlockId));
    }

    public SidechainHistoryStorage(Storage storage, SidechainTransactionsCompanion sidechainTransactionsCompanion, NetworkParams params) {
        this.storage = storage;
        this.params = params;
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainTransactionsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainTransactionsCompanion must be NOT NULL.");
        Predef$.MODULE$.require(params != null, (Function0 & Serializable & scala.Serializable)() -> "params must be NOT NULL.");
        this.sidechainBlockSerializer = new SidechainBlockSerializer(sidechainTransactionsCompanion);
        this.bestBlockIdKey = new ByteArrayWrapper((byte[])Array$.MODULE$.fill(32, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Byte()));
        this.activeChain = this.loadActiveChain();
    }
}

