/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.secret;

import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.cryptolibprovider.VrfFunctions;
import com.horizen.proof.VrfProof;
import com.horizen.proposition.ProofOfKnowledgeProposition;
import com.horizen.proposition.VrfPublicKey;
import com.horizen.secret.Secret;
import com.horizen.secret.SecretSerializer;
import com.horizen.secret.SecretsIdsEnum;
import com.horizen.secret.VrfSecretKeySerializer;
import com.horizen.utils.Pair;
import com.horizen.vrf.VrfOutput;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;

public class VrfSecretKey
implements Secret {
    public static final int SECRET_KEY_LENGTH = CryptoLibProvider.vrfFunctions().vrfSecretKeyLength();
    public static final int PUBLIC_KEY_LENGTH = CryptoLibProvider.vrfFunctions().vrfPublicKeyLen();
    final byte[] secretBytes;
    final byte[] publicBytes;

    public VrfSecretKey(byte[] secretKey, byte[] publicKey) {
        Objects.requireNonNull(secretKey, "Secret key can't be null");
        Objects.requireNonNull(publicKey, "Public key can't be null");
        this.secretBytes = Arrays.copyOf(secretKey, secretKey.length);
        this.publicBytes = Arrays.copyOf(publicKey, publicKey.length);
    }

    private byte[] getSecretBytes() {
        return Arrays.copyOf(this.secretBytes, this.secretBytes.length);
    }

    public byte[] getPublicBytes() {
        return this.publicBytes;
    }

    public Pair<VrfProof, VrfOutput> prove(byte[] message) {
        EnumMap<VrfFunctions.ProofType, byte[]> proofs = CryptoLibProvider.vrfFunctions().createProof(this.getSecretBytes(), this.getPublicBytes(), message);
        return new Pair<VrfProof, VrfOutput>(new VrfProof(proofs.get((Object)VrfFunctions.ProofType.VRF_PROOF)), new VrfOutput(proofs.get((Object)VrfFunctions.ProofType.VRF_OUTPUT)));
    }

    @Override
    public byte secretTypeId() {
        return SecretsIdsEnum.VrfPrivateKeySecretId.id();
    }

    @Override
    public VrfPublicKey publicImage() {
        byte[] publicKey = Arrays.copyOf(this.publicBytes, this.publicBytes.length);
        return new VrfPublicKey(publicKey);
    }

    @Override
    public SecretSerializer serializer() {
        return VrfSecretKeySerializer.getSerializer();
    }

    @Override
    public boolean owns(ProofOfKnowledgeProposition proposition) {
        return Arrays.equals(this.publicBytes, proposition.pubKeyBytes());
    }

    @Override
    public VrfProof sign(byte[] message) {
        return this.prove(message).getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VrfSecretKey that = (VrfSecretKey)o;
        return Arrays.equals(this.secretBytes, that.secretBytes) && Arrays.equals(this.publicBytes, that.publicBytes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.secretBytes);
        result = 31 * result + Arrays.hashCode(this.publicBytes);
        return result;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }
}

