/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.box.WithdrawalRequestBox;
import com.horizen.certnative.BackwardTransfer;
import com.horizen.certnative.CreateProofResult;
import com.horizen.certnative.NaiveThresholdSigProof;
import com.horizen.cryptolibprovider.ThresholdSignatureCircuit;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.proposition.MCPublicKeyHashProposition;
import com.horizen.provingsystemnative.ProvingSystemType;
import com.horizen.schnorrnative.SchnorrPublicKey;
import com.horizen.schnorrnative.SchnorrSignature;
import com.horizen.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ThresholdSignatureCircuitImplZendoo
implements ThresholdSignatureCircuit {
    private static final int supportedSegmentSize = 131072;
    private static final SchnorrSignature signaturePlaceHolder = new SchnorrSignature();

    private static BackwardTransfer withdrawalRequestBoxToBackwardTransfer(WithdrawalRequestBox box) {
        return new BackwardTransfer(((MCPublicKeyHashProposition)box.proposition()).bytes(), box.value());
    }

    @Override
    public List<byte[]> getCertificateCustomFields(Optional<byte[]> utxoMerkleTreeRoot) {
        List<FieldElement> fes = this.prepareCustomFieldElements(utxoMerkleTreeRoot);
        List<byte[]> fesBytes = fes.stream().map(fe -> fe.serializeFieldElement()).collect(Collectors.toList());
        fes.forEach(fe -> fe.freeFieldElement());
        return fesBytes;
    }

    private List<FieldElement> prepareCustomFieldElements(Optional<byte[]> utxoMerkleTreeRoot) {
        if (utxoMerkleTreeRoot.isPresent()) {
            return this.splitUtxoMerkleTreeRootToFieldElements(utxoMerkleTreeRoot.get());
        }
        return new ArrayList<FieldElement>();
    }

    private List<FieldElement> splitUtxoMerkleTreeRootToFieldElements(byte[] utxoMerkleTreeRoot) {
        FieldElement utxoMerkleTreeRootFe = FieldElement.deserialize((byte[])utxoMerkleTreeRoot);
        List split = utxoMerkleTreeRootFe.splitAt(16);
        utxoMerkleTreeRootFe.freeFieldElement();
        return split;
    }

    @Override
    public byte[] reconstructUtxoMerkleTreeRoot(byte[] fe1Bytes, byte[] fe2Bytes) {
        FieldElement fe1 = FieldElement.deserialize((byte[])fe1Bytes);
        if (fe1 == null) {
            return new byte[0];
        }
        FieldElement fe2 = FieldElement.deserialize((byte[])fe2Bytes);
        if (fe2 == null) {
            fe1.freeFieldElement();
            return new byte[0];
        }
        FieldElement utxoMerkleTreeRootFe = FieldElement.joinAt((FieldElement)fe1, (int)16, (FieldElement)fe2, (int)16);
        byte[] utxoMerkleTreeRoot = utxoMerkleTreeRootFe.serializeFieldElement();
        fe1.freeFieldElement();
        fe2.freeFieldElement();
        utxoMerkleTreeRootFe.freeFieldElement();
        return utxoMerkleTreeRoot;
    }

    @Override
    public byte[] generateMessageToBeSigned(List<WithdrawalRequestBox> bt, byte[] sidechainId, int epochNumber, byte[] endCumulativeScTxCommTreeRoot, long btrFee, long ftMinAmount, Optional<byte[]> utxoMerkleTreeRoot) {
        BackwardTransfer[] backwardTransfers = (BackwardTransfer[])bt.stream().map(ThresholdSignatureCircuitImplZendoo::withdrawalRequestBoxToBackwardTransfer).toArray(BackwardTransfer[]::new);
        FieldElement endCumulativeScTxCommTreeRootFe = FieldElement.deserialize((byte[])endCumulativeScTxCommTreeRoot);
        FieldElement sidechainIdFe = FieldElement.deserialize((byte[])sidechainId);
        List<FieldElement> customFe = this.prepareCustomFieldElements(utxoMerkleTreeRoot);
        FieldElement messageToSign = NaiveThresholdSigProof.createMsgToSign((BackwardTransfer[])backwardTransfers, (FieldElement)sidechainIdFe, (int)epochNumber, (FieldElement)endCumulativeScTxCommTreeRootFe, (long)btrFee, (long)ftMinAmount, customFe);
        byte[] messageAsBytes = messageToSign.serializeFieldElement();
        endCumulativeScTxCommTreeRootFe.freeFieldElement();
        sidechainIdFe.freeFieldElement();
        customFe.forEach(fe -> fe.freeFieldElement());
        messageToSign.freeFieldElement();
        return messageAsBytes;
    }

    @Override
    public Pair<byte[], Long> createProof(List<WithdrawalRequestBox> bt, byte[] sidechainId, int epochNumber, byte[] endCumulativeScTxCommTreeRoot, long btrFee, long ftMinAmount, Optional<byte[]> utxoMerkleTreeRoot, List<Optional<byte[]>> schnorrSignatureBytesList, List<byte[]> schnorrPublicKeysBytesList, long threshold, String provingKeyPath, boolean checkProvingKey, boolean zk) {
        List backwardTransfers = bt.stream().map(ThresholdSignatureCircuitImplZendoo::withdrawalRequestBoxToBackwardTransfer).collect(Collectors.toList());
        List<SchnorrSignature> signatures = schnorrSignatureBytesList.stream().map(signatureBytesOpt -> signatureBytesOpt.map(bytes -> SchnorrSignature.deserialize((byte[])bytes)).orElse(signaturePlaceHolder)).collect(Collectors.toList());
        List<SchnorrPublicKey> publicKeys = schnorrPublicKeysBytesList.stream().map(bytes -> SchnorrPublicKey.deserialize((byte[])bytes)).collect(Collectors.toList());
        FieldElement endCumulativeScTxCommTreeRootFe = FieldElement.deserialize((byte[])endCumulativeScTxCommTreeRoot);
        FieldElement sidechainIdFe = FieldElement.deserialize((byte[])sidechainId);
        List<FieldElement> customFe = this.prepareCustomFieldElements(utxoMerkleTreeRoot);
        CreateProofResult proofAndQuality = NaiveThresholdSigProof.createProof(backwardTransfers, (FieldElement)sidechainIdFe, (int)epochNumber, (FieldElement)endCumulativeScTxCommTreeRootFe, (long)btrFee, (long)ftMinAmount, signatures, publicKeys, (long)threshold, customFe, Optional.of(131072), (String)provingKeyPath, (boolean)checkProvingKey, (boolean)zk);
        endCumulativeScTxCommTreeRootFe.freeFieldElement();
        sidechainIdFe.freeFieldElement();
        publicKeys.forEach(SchnorrPublicKey::freePublicKey);
        signatures.forEach(SchnorrSignature::freeSignature);
        customFe.forEach(fe -> fe.freeFieldElement());
        return new Pair<byte[], Long>(proofAndQuality.getProof(), proofAndQuality.getQuality());
    }

    @Override
    public Boolean verifyProof(List<WithdrawalRequestBox> bt, byte[] sidechainId, int epochNumber, byte[] endCumulativeScTxCommTreeRoot, long btrFee, long ftMinAmount, Optional<byte[]> utxoMerkleTreeRoot, byte[] constant, long quality, byte[] proof, boolean checkProof, String verificationKeyPath, boolean checkVerificationKey) {
        List backwardTransfers = bt.stream().map(ThresholdSignatureCircuitImplZendoo::withdrawalRequestBoxToBackwardTransfer).collect(Collectors.toList());
        FieldElement endCumulativeScTxCommTreeRootFe = FieldElement.deserialize((byte[])endCumulativeScTxCommTreeRoot);
        FieldElement constantFe = FieldElement.deserialize((byte[])constant);
        FieldElement sidechainIdFe = FieldElement.deserialize((byte[])sidechainId);
        List<FieldElement> customFe = this.prepareCustomFieldElements(utxoMerkleTreeRoot);
        boolean verificationResult = NaiveThresholdSigProof.verifyProof(backwardTransfers, (FieldElement)sidechainIdFe, (int)epochNumber, (FieldElement)endCumulativeScTxCommTreeRootFe, (long)btrFee, (long)ftMinAmount, (FieldElement)constantFe, (long)quality, customFe, (byte[])proof, (boolean)checkProof, (String)verificationKeyPath, (boolean)checkVerificationKey);
        endCumulativeScTxCommTreeRootFe.freeFieldElement();
        sidechainIdFe.freeFieldElement();
        constantFe.freeFieldElement();
        customFe.forEach(fe -> fe.freeFieldElement());
        return verificationResult;
    }

    @Override
    public byte[] generateSysDataConstant(List<byte[]> publicKeysList, long threshold) {
        List<SchnorrPublicKey> schnorrPublicKeys = publicKeysList.stream().map(bytes -> SchnorrPublicKey.deserialize((byte[])bytes)).collect(Collectors.toList());
        FieldElement sysDataConstant = NaiveThresholdSigProof.getConstant(schnorrPublicKeys, (long)threshold);
        byte[] sysDataConstantBytes = sysDataConstant.serializeFieldElement();
        sysDataConstant.freeFieldElement();
        schnorrPublicKeys.forEach(SchnorrPublicKey::freePublicKey);
        return sysDataConstantBytes;
    }

    @Override
    public boolean generateCoboundaryMarlinSnarkKeys(long maxPks, String provingKeyPath, String verificationKeyPath, int customFieldsNum) {
        return NaiveThresholdSigProof.setup((ProvingSystemType)ProvingSystemType.COBOUNDARY_MARLIN, (long)maxPks, (int)customFieldsNum, Optional.of(131072), (String)provingKeyPath, (String)verificationKeyPath, (int)9216);
    }
}

