/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.horizen.block.SidechainBlock;
import com.horizen.websocket.server.EVENT_MESSAGE$;
import com.horizen.websocket.server.GET_MEMPOOL_TXS$;
import com.horizen.websocket.server.GET_NEW_BLOCK_HASHES_REQUEST_TYPE$;
import com.horizen.websocket.server.GET_RAW_MEMPOOL$;
import com.horizen.websocket.server.GET_SINGLE_BLOCK_REQUEST_TYPE$;
import com.horizen.websocket.server.RESPONSE_MESSAGE$;
import com.horizen.websocket.server.SidechainNodeChannelImpl;
import com.horizen.websocket.server.WebSocketServerEndpoint$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.ArrayList;
import java.util.Iterator;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.ScorexLogging;

@ServerEndpoint(value="/")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001\u0002\u000f\u001e\u0001\u0019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004F\u0001\u0001\u0006Ia\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019Y\u0005\u0001)A\u0005\u0011\")A\n\u0001C\u0001\u001b\")a\f\u0001C\u0001?\")Q\r\u0001C\u0001M\")!\u0010\u0001C\u0001w\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011F\u0004\b\u0003\u0003j\u0002\u0012BA\"\r\u0019aR\u0004#\u0003\u0002F!1Q'\u0004C\u0001\u0003\u000fB\u0011\"!\u0013\u000e\u0001\u0004%\t!a\u0013\t\u0013\u0005mS\u00021A\u0005\u0002\u0005u\u0003\u0002CA2\u001b\u0001\u0006K!!\u0014\t\u0011\u0005\u0015TB1A\u0005\u0002\u001dCq!a\u001a\u000eA\u0003%\u0001\nC\u0004:\u001b\t\u0007I\u0011\u0002\u001e\t\r\u0015k\u0001\u0015!\u0003<\u0011\u001d\tI'\u0004C\u0001\u0003WBq!a\u001c\u000e\t\u0003\t\t\bC\u0004\u0002v5!\t!a\u001e\t\u000f\u0005eT\u0002\"\u0001\u0002|!9\u00111R\u0007\u0005\u0002\u00055\u0005bBA[\u001b\u0011\u0005\u0011q\u0017\u0002\u0018/\u0016\u00147k\\2lKR\u001cVM\u001d<fe\u0016sG\r]8j]RT!AH\u0010\u0002\rM,'O^3s\u0015\t\u0001\u0013%A\u0005xK\n\u001cxnY6fi*\u0011!eI\u0001\bQ>\u0014\u0018N_3o\u0015\u0005!\u0013aA2p[\u000e\u00011c\u0001\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\tU$\u0018\u000e\u001c\u0006\u0002e\u000511oY8sKbL!\u0001N\u0018\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0007\u0005\u00029\u00015\tQ$\u0001\u0004nCB\u0004XM]\u000b\u0002wA\u0011AhQ\u0007\u0002{)\u0011ahP\u0001\tI\u0006$\u0018MY5oI*\u0011\u0001)Q\u0001\bU\u0006\u001c7n]8o\u0015\t\u00115%A\u0005gCN$XM\u001d=nY&\u0011A)\u0010\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\b[\u0006\u0004\b/\u001a:!\u0003Q\u0019\u0018\u000eZ3dQ\u0006LgNT8eK\u000eC\u0017M\u001c8fYV\t\u0001\n\u0005\u00029\u0013&\u0011!*\b\u0002\u0019'&$Wm\u00195bS:tu\u000eZ3DQ\u0006tg.\u001a7J[Bd\u0017!F:jI\u0016\u001c\u0007.Y5o\u001d>$Wm\u00115b]:,G\u000eI\u0001\u0007_:|\u0005/\u001a8\u0015\u00059\u000b\u0006C\u0001\u0015P\u0013\t\u0001\u0016F\u0001\u0003V]&$\b\"\u0002*\u0007\u0001\u0004\u0019\u0016aB:fgNLwN\u001c\t\u0003)bk\u0011!\u0016\u0006\u0003AYS\u0011aV\u0001\u0006U\u00064\u0018\r_\u0005\u00033V\u0013qaU3tg&|g\u000e\u000b\u0002\u00077B\u0011A\u000bX\u0005\u0003;V\u0013aa\u00148Pa\u0016t\u0017aB8o\u00072|7/\u001a\u000b\u0003\u001d\u0002DQAU\u0004A\u0002MC#a\u00022\u0011\u0005Q\u001b\u0017B\u00013V\u0005\u001dyen\u00117pg\u0016\fqa\u001c8FeJ|'\u000fF\u0002OO\"DQA\u0015\u0005A\u0002MCQ!\u001b\u0005A\u0002)\f\u0011\u0001\u001e\t\u0003WNt!\u0001\\9\u000f\u00055\u0004X\"\u00018\u000b\u0005=,\u0013A\u0002\u001fs_>$h(C\u0001+\u0013\t\u0011\u0018&A\u0004qC\u000e\\\u0017mZ3\n\u0005Q,(!\u0003+ie><\u0018M\u00197f\u0015\t\u0011\u0018\u0006\u000b\u0002\toB\u0011A\u000b_\u0005\u0003sV\u0013qa\u00148FeJ|'/A\tp]6+7o]1hKJ+7-Z5wK\u0012$2A\u0014?~\u0011\u0015\u0011\u0016\u00021\u0001T\u0011\u0015q\u0018\u00021\u0001\u0000\u0003\u001diWm]:bO\u0016\u0004B!!\u0001\u0002\n9!\u00111AA\u0003!\ti\u0017&C\u0002\u0002\b%\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004S!\u001a\u0011\"!\u0005\u0011\u0007Q\u000b\u0019\"C\u0002\u0002\u0016U\u0013\u0011b\u00148NKN\u001c\u0018mZ3\u0002\u001dA\u0014xnY3tgJ+\u0017/^3tiR)a*a\u0007\u0002&!9\u0011Q\u0004\u0006A\u0002\u0005}\u0011\u0001\u00026t_:\u00042\u0001PA\u0011\u0013\r\t\u0019#\u0010\u0002\t\u0015N|gNT8eK\")!K\u0003a\u0001'\u0006a\u0001O]8dKN\u001cXI\u001d:peR)a*a\u000b\u0002.!9\u0011QD\u0006A\u0002\u0005}\u0001\"\u0002*\f\u0001\u0004\u0019\u0006f\u0002\u0001\u00022\u0005m\u0012Q\b\t\u0005\u0003g\t9$\u0004\u0002\u00026)\u0011a$V\u0005\u0005\u0003s\t)D\u0001\bTKJ4XM]#oIB|\u0017N\u001c;\u0002\u000bY\fG.^3\"\u0005\u0005}\u0012!A\u0018\u0002/]+'mU8dW\u0016$8+\u001a:wKJ,e\u000e\u001a9pS:$\bC\u0001\u001d\u000e'\riq%\f\u000b\u0003\u0003\u0007\n\u0001b]3tg&|gn]\u000b\u0003\u0003\u001b\u0002R!a\u0014\u0002XMk!!!\u0015\u000b\u0007A\n\u0019F\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\tI&!\u0015\u0003\u0013\u0005\u0013(/Y=MSN$\u0018\u0001D:fgNLwN\\:`I\u0015\fHc\u0001(\u0002`!I\u0011\u0011\r\t\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0004q\u0012\n\u0014!C:fgNLwN\\:!\u0003a\u0019\u0018\u000eZ3dQ\u0006LgNT8eK\u000eC\u0017M\u001c8fY&k\u0007\u000f\\\u0001\u001ag&$Wm\u00195bS:tu\u000eZ3DQ\u0006tg.\u001a7J[Bd\u0007%\u0001\u0006bI\u0012\u001cVm]:j_:$2ATA7\u0011\u0015\u0011f\u00031\u0001T\u00035\u0011X-\\8wKN+7o]5p]R\u0019a*a\u001d\t\u000bI;\u0002\u0019A*\u0002)9|G/\u001b4z\u001b\u0016l\u0007o\\8m\u0007\"\fgnZ3e)\u0005q\u0015\u0001\n8pi&4\u0017pU3nC:$\u0018nY1mYf\u001cVoY2fgN4W\u000f\\'pI&4\u0017.\u001a:\u0015\u00079\u000bi\bC\u0004\u0002\u0000e\u0001\r!!!\u0002\u000b\tdwnY6\u0011\t\u0005\r\u0015qQ\u0007\u0003\u0003\u000bS1!a \"\u0013\u0011\tI)!\"\u0003\u001dMKG-Z2iC&t'\t\\8dW\u0006Y1/\u001a8e\u001b\u0016\u001c8/Y4f)-q\u0015qRAM\u0003;\u000b\t+!-\t\u000f\u0005E%\u00041\u0001\u0002\u0014\u00069Qn]4UsB,\u0007c\u0001\u0015\u0002\u0016&\u0019\u0011qS\u0015\u0003\u0007%sG\u000fC\u0004\u0002\u001cj\u0001\r!a%\u0002\u0013I,\u0017/^3ti&#\u0007bBAP5\u0001\u0007\u00111S\u0001\u000bC:\u001cx/\u001a:UsB,\u0007bBAR5\u0001\u0007\u0011QU\u0001\ba\u0006LHn\\1e!\u0011\t9+!,\u000e\u0005\u0005%&bAAV{\u0005!an\u001c3f\u0013\u0011\ty+!+\u0003\u0015=\u0013'.Z2u\u001d>$W\r\u0003\u0004\u00024j\u0001\raU\u0001\u0007G2LWM\u001c;\u0002\u0013M,g\u000eZ#se>\u0014Hc\u0003(\u0002:\u0006m\u0016QXAa\u0003\u000bDq!a'\u001c\u0001\u0004\t\u0019\nC\u0004\u0002 n\u0001\r!a%\t\u000f\u0005}6\u00041\u0001\u0002\u0014\u0006IQM\u001d:pe\u000e{G-\u001a\u0005\u0007\u0003\u0007\\\u0002\u0019A@\u0002\u001fI,7\u000f]8og\u0016\u0004\u0016-\u001f7pC\u0012Da!a-\u001c\u0001\u0004\u0019\u0006")
public class WebSocketServerEndpoint
implements ScorexLogging {
    private final ObjectMapper mapper;
    private final SidechainNodeChannelImpl sidechainNodeChannel;
    private final Logger logger;

    public static void sendError(int n, int n2, int n3, String string, Session session) {
        WebSocketServerEndpoint$.MODULE$.sendError(n, n2, n3, string, session);
    }

    public static void sendMessage(int n, int n2, int n3, ObjectNode objectNode, Session session) {
        WebSocketServerEndpoint$.MODULE$.sendMessage(n, n2, n3, objectNode, session);
    }

    public static void notifySemanticallySuccessfulModifier(SidechainBlock sidechainBlock) {
        WebSocketServerEndpoint$.MODULE$.notifySemanticallySuccessfulModifier(sidechainBlock);
    }

    public static void notifyMempoolChanged() {
        WebSocketServerEndpoint$.MODULE$.notifyMempoolChanged();
    }

    public static void removeSession(Session session) {
        WebSocketServerEndpoint$.MODULE$.removeSession(session);
    }

    public static void addSession(Session session) {
        WebSocketServerEndpoint$.MODULE$.addSession(session);
    }

    public static SidechainNodeChannelImpl sidechainNodeChannelImpl() {
        return WebSocketServerEndpoint$.MODULE$.sidechainNodeChannelImpl();
    }

    public static void sessions_$eq(ArrayList<Session> arrayList) {
        WebSocketServerEndpoint$.MODULE$.sessions_$eq(arrayList);
    }

    public static ArrayList<Session> sessions() {
        return WebSocketServerEndpoint$.MODULE$.sessions();
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public SidechainNodeChannelImpl sidechainNodeChannel() {
        return this.sidechainNodeChannel;
    }

    @OnOpen
    public synchronized void onOpen(Session session) {
        WebSocketServerEndpoint$.MODULE$.addSession(session);
    }

    @OnClose
    public synchronized void onClose(Session session) {
        WebSocketServerEndpoint$.MODULE$.removeSession(session);
    }

    @OnError
    public void onError(Session session, Throwable t) {
        BoxedUnit boxedUnit;
        if (this.log().underlying().isErrorEnabled()) {
            this.log().underlying().error(new StringBuilder(19).append("Error on session ").append(session.getId()).append(": ").append(t.toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        WebSocketServerEndpoint webSocketServerEndpoint = this;
        synchronized (webSocketServerEndpoint) {
            WebSocketServerEndpoint$.MODULE$.removeSession(session);
        }
    }

    @OnMessage
    public void onMessageReceived(Session session, String message) {
        block7: {
            try {
                JsonNode json = this.mapper().readTree(message);
                if (json.has("msgType")) {
                    int n = json.get("msgType").asInt();
                    switch (n) {
                        case 1: {
                            this.processRequest(json, session);
                            break;
                        }
                        case 2: {
                            this.processError(json, session);
                            break;
                        }
                        default: {
                            this.processError(json, session);
                            System.out.println(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
                            break;
                        }
                    }
                    break block7;
                }
                this.processError(json, session);
                System.out.println("Unknown message received!");
            }
            catch (Throwable ex) {
                this.processError((JsonNode)this.mapper().createObjectNode(), session);
                System.out.println(new StringBuilder(51).append("On receive message processing exception occurred = ").append(ex.getMessage()).toString());
            }
        }
    }

    public void processRequest(JsonNode json, Session session) {
        int requestType;
        JsonNode requestPayload = json.get("requestPayload");
        int requestId = json.get("requestId").asInt();
        int n = requestType = json.get("requestType").asInt();
        if (GET_SINGLE_BLOCK_REQUEST_TYPE$.MODULE$.code() == n) {
            BoxedUnit boxedUnit;
            if (requestPayload.has("hash")) {
                String hash = requestPayload.get("hash").asText();
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getBlockInfoByHash(hash);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit3;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(49).append("Error inside GET_SINGLE_BLOCK websocket request: ").append(ex.toString()).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 5, "Invalid parameter", session);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else if (requestPayload.has("height")) {
                int height = requestPayload.get("height").asInt();
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getBlockInfoByHeight(height);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit6;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(49).append("Error inside GET_SINGLE_BLOCK websocket request: ").append(ex.toString()).toString());
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 5, "Invalid parameter", session);
                    BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.processError(json, session);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (GET_NEW_BLOCK_HASHES_REQUEST_TYPE$.MODULE$.code() == n) {
            BoxedUnit boxedUnit;
            Iterator afterHash = requestPayload.get("locatorHashes").elements();
            Seq hashes = (Seq)Nil$.MODULE$;
            while (afterHash.hasNext()) {
                hashes = (Seq)hashes.$colon$plus((Object)((JsonNode)afterHash.next()).asText(), Seq$.MODULE$.canBuildFrom());
            }
            int limit = requestPayload.get("limit").asInt();
            if (limit > 50) {
                WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Invalid limit size! Max limit is 50", session);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getNewBlockHashes((Seq<String>)hashes, limit);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit10;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(53).append("Error inside GET_NEW_BLOCK_HASHES websocket request: ").append(ex.toString()).toString());
                        boxedUnit10 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit10 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Couldn't find new block hashes", session);
                    BoxedUnit boxedUnit11 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (GET_MEMPOOL_TXS$.MODULE$.code() == n) {
            BoxedUnit boxedUnit;
            Iterator txids = requestPayload.get("hash").elements();
            Seq hashes = (Seq)Nil$.MODULE$;
            while (txids.hasNext()) {
                hashes = (Seq)hashes.$colon$plus((Object)((JsonNode)txids.next()).asText(), Seq$.MODULE$.canBuildFrom());
            }
            if (hashes.size() > 10) {
                WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Exceed max number of transactions (10)!", session);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Try<ObjectNode> try_ = this.sidechainNodeChannel().getMempoolTxs((Seq<String>)hashes);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ObjectNode responsePayload = (ObjectNode)success.value();
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    BoxedUnit boxedUnit13 = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit14;
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug(new StringBuilder(48).append("Error inside GET_MEMPOOL_TXS websocket request: ").append(ex.toString()).toString());
                        boxedUnit14 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit14 = BoxedUnit.UNIT;
                    }
                    WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Couldn't find mempool txs", session);
                    BoxedUnit boxedUnit15 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit16 = boxedUnit;
        } else if (GET_RAW_MEMPOOL$.MODULE$.code() == n) {
            Try<ObjectNode> try_ = this.sidechainNodeChannel().getRawMempool();
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                ObjectNode responsePayload = (ObjectNode)success.value();
                if (requestId == -1) {
                    WebSocketServerEndpoint$.MODULE$.sendMessage(EVENT_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    WebSocketServerEndpoint$.MODULE$.sendMessage(RESPONSE_MESSAGE$.MODULE$.code(), requestId, requestType, responsePayload, session);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit17 = boxedUnit;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug(new StringBuilder(48).append("Error inside GET_RAW_MEMPOOL websocket request: ").append(ex.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 4, "Couldn't query mempool", session);
                BoxedUnit boxedUnit18 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.out.println(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void processError(JsonNode json, Session session) {
        int requestId = -1;
        if (json.has("requestId")) {
            requestId = json.get("requestId").asInt();
        }
        int requestType = -1;
        if (json.has("requestType")) {
            requestType = json.get("requestType").asInt();
        }
        WebSocketServerEndpoint$.MODULE$.sendError(requestId, requestType, 5, "WebSocket message error!", session);
    }

    public WebSocketServerEndpoint() {
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.sidechainNodeChannel = new SidechainNodeChannelImpl();
    }
}

