/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.client;

import com.horizen.block.MainchainBlockReference;
import com.horizen.block.MainchainBlockReference$;
import com.horizen.block.MainchainHeader;
import com.horizen.block.MainchainHeader$;
import com.horizen.block.SidechainCreationVersions$;
import com.horizen.block.SidechainsVersionsManager;
import com.horizen.mainchain.api.SendCertificateRequest;
import com.horizen.mainchain.api.SendCertificateResponse;
import com.horizen.params.NetworkParams;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.BytesUtils;
import com.horizen.websocket.client.BackwardTransfer;
import com.horizen.websocket.client.BlockHeadersResponsePayload;
import com.horizen.websocket.client.BlockResponsePayload;
import com.horizen.websocket.client.BlocksResponsePayload;
import com.horizen.websocket.client.CertificateResponsePayload;
import com.horizen.websocket.client.CommunicationClient;
import com.horizen.websocket.client.GET_MULTIPLE_BLOCK_HASHES_REQUEST_TYPE$;
import com.horizen.websocket.client.GET_MULTIPLE_HEADERS_REQUEST_TYPE$;
import com.horizen.websocket.client.GET_NEW_BLOCK_HASHES_REQUEST_TYPE$;
import com.horizen.websocket.client.GET_SIDECHAIN_VERSIONS_TYPE$;
import com.horizen.websocket.client.GET_SINGLE_BLOCK_REQUEST_TYPE$;
import com.horizen.websocket.client.GET_TOP_QUALITY_CERTIFICATES_TYPE$;
import com.horizen.websocket.client.GetBlockByHashRequestPayload;
import com.horizen.websocket.client.GetBlockByHeightRequestPayload;
import com.horizen.websocket.client.GetBlockHeadersRequestPayload;
import com.horizen.websocket.client.GetBlocksAfterHashRequestPayload;
import com.horizen.websocket.client.GetBlocksAfterHeightRequestPayload;
import com.horizen.websocket.client.GetNewBlocksRequestPayload;
import com.horizen.websocket.client.GetSidechainVersionsRequestPayload;
import com.horizen.websocket.client.GetSidechainVersionsResponsePayload;
import com.horizen.websocket.client.MainchainNodeChannel;
import com.horizen.websocket.client.MainchainNodeChannelImpl$;
import com.horizen.websocket.client.NewBlocksResponsePayload;
import com.horizen.websocket.client.OnUpdateTipEventHandler;
import com.horizen.websocket.client.OnUpdateTipEventPayload;
import com.horizen.websocket.client.SEND_CERTIFICATE_REQUEST_TYPE$;
import com.horizen.websocket.client.SendCertificateRequestPayload;
import com.horizen.websocket.client.SidechainVersionsInfo;
import com.horizen.websocket.client.TopQualityCertificatePayload;
import com.horizen.websocket.client.TopQualityCertificateResponsePayload;
import com.horizen.websocket.client.TopQualityCertificates;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u000f\u001f\u0001\u001dB\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)\u0011\t\u0001C\u0001\u0005\"9a\t\u0001a\u0001\n\u00039\u0005b\u00024\u0001\u0001\u0004%\ta\u001a\u0005\u0007[\u0002\u0001\u000b\u0015\u0002%\t\u000b9\u0004A\u0011I8\t\u000by\u0004A\u0011I@\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003{\u0003A\u0011BA`\u0011\u001d\tY\r\u0001C!\u0003\u001bDq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002d\u0002!\t%!:\t\u000f\u00055\b\u0001\"\u0011\u0002p\u001e9\u0011q \u0010\t\u0002\t\u0005aAB\u000f\u001f\u0011\u0003\u0011\u0019\u0001\u0003\u0004B3\u0011\u0005!Q\u0001\u0005\n\u0005\u000fI\"\u0019!C\u0001\u0005\u0013AqAa\u0003\u001aA\u0003%1P\u0001\rNC&t7\r[1j]:{G-Z\"iC:tW\r\\%na2T!a\b\u0011\u0002\r\rd\u0017.\u001a8u\u0015\t\t#%A\u0005xK\n\u001cxnY6fi*\u00111\u0005J\u0001\bQ>\u0014\u0018N_3o\u0015\u0005)\u0013aA2p[\u000e\u00011\u0003\u0002\u0001)]I\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00181\u001b\u0005q\u0012BA\u0019\u001f\u0005Qi\u0015-\u001b8dQ\u0006LgNT8eK\u000eC\u0017M\u001c8fYB\u00111GN\u0007\u0002i)\u0011QGI\u0001\u0006E2|7m[\u0005\u0003oQ\u0012\u0011dU5eK\u000eD\u0017-\u001b8t-\u0016\u00148/[8og6\u000bg.Y4feB\u0011q&O\u0005\u0003uy\u00111cQ8n[Vt\u0017nY1uS>t7\t\\5f]R\fa\u0001]1sC6\u001c\bCA\u001f@\u001b\u0005q$BA\u001e#\u0013\t\u0001eHA\u0007OKR<xN]6QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r#U\t\u0005\u00020\u0001!)qd\u0001a\u0001q!)1h\u0001a\u0001y\u000592/\u001b3fG\"\f\u0017N\\:WKJ\u001c\u0018n\u001c8t\u0007\u0006\u001c\u0007.Z\u000b\u0002\u0011B!\u0011\nU*Z\u001d\tQe\n\u0005\u0002LU5\tAJ\u0003\u0002NM\u00051AH]8pizJ!a\u0014\u0016\u0002\rA\u0013X\rZ3g\u0013\t\t&KA\u0002NCBT!a\u0014\u0016\u0011\u0005Q;V\"A+\u000b\u0005Y\u0013\u0013!B;uS2\u001c\u0018B\u0001-V\u0005A\u0011\u0015\u0010^3BeJ\f\u0017p\u0016:baB,'\u000f\u0005\u0002[G:\u00111,\u0019\b\u00039\u0002t!!X0\u000f\u0005-s\u0016\"A\u0013\n\u0005\r\"\u0013BA\u001b#\u0013\t\u0011G'A\rTS\u0012,7\r[1j]\u000e\u0013X-\u0019;j_:4VM]:j_:\u001c\u0018B\u00013f\u0005a\u0019\u0016\u000eZ3dQ\u0006Lgn\u0011:fCRLwN\u001c,feNLwN\u001c\u0006\u0003ER\n1d]5eK\u000eD\u0017-\u001b8t-\u0016\u00148/[8og\u000e\u000b7\r[3`I\u0015\fHC\u00015l!\tI\u0013.\u0003\u0002kU\t!QK\\5u\u0011\u001daW!!AA\u0002!\u000b1\u0001\u001f\u00132\u0003a\u0019\u0018\u000eZ3dQ\u0006Lgn\u001d,feNLwN\\:DC\u000eDW\rI\u0001\u0011O\u0016$(\t\\8dW\nK\b*Z5hQR$\"\u0001]=\u0011\u0007E$h/D\u0001s\u0015\t\u0019(&\u0001\u0003vi&d\u0017BA;s\u0005\r!&/\u001f\t\u0003g]L!\u0001\u001f\u001b\u0003/5\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0007\"\u0002>\b\u0001\u0004Y\u0018A\u00025fS\u001eDG\u000f\u0005\u0002*y&\u0011QP\u000b\u0002\u0004\u0013:$\u0018AD4fi\ncwnY6Cs\"\u000b7\u000f\u001b\u000b\u0004a\u0006\u0005\u0001bBA\u0002\u0011\u0001\u0007\u0011QA\u0001\u0005Q\u0006\u001c\b\u000eE\u0002J\u0003\u000fI1!!\u0003S\u0005\u0019\u0019FO]5oO\u0006Y\u0002O]8dKN\u001c(\t\\8dWJ+7\u000f]8og\u0016\u0004\u0016-\u001f7pC\u0012$2\u0001]A\b\u0011\u001d\t\t\"\u0003a\u0001\u0003'\taAZ;ukJ,\u0007CBA\u000b\u00037\ty\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u001e\u0005]!A\u0002$viV\u0014X\rE\u00020\u0003CI1!a\t\u001f\u0005Q\u0011En\\2l%\u0016\u001c\bo\u001c8tKB\u000b\u0017\u0010\\8bI\u0006Ir-\u001a;CY>\u001c7\u000eS1tQ\u0016\u001c\u0018I\u001a;fe\"+\u0017n\u001a5u)\u0019\tI#!\u0010\u0002@A!\u0011\u000f^A\u0016!\u0019\ti#a\u000e\u0002\u00069!\u0011qFA\u001a\u001d\rY\u0015\u0011G\u0005\u0002W%\u0019\u0011Q\u0007\u0016\u0002\u000fA\f7m[1hK&!\u0011\u0011HA\u001e\u0005\r\u0019V-\u001d\u0006\u0004\u0003kQ\u0003\"\u0002>\u000b\u0001\u0004Y\bBBA!\u0015\u0001\u000710A\u0003mS6LG/A\fhKR\u0014En\\2l\u0011\u0006\u001c\b.Z:BMR,'\u000fS1tQR1\u0011\u0011FA$\u0003\u0013Bq!a\u0001\f\u0001\u0004\t)\u0001\u0003\u0004\u0002B-\u0001\ra_\u0001\u0012O\u0016$h*Z<CY>\u001c7\u000eS1tQ\u0016\u001cHCBA(\u0003/\nY\u0006\u0005\u0003ri\u0006E\u0003CB\u0015\u0002Tm\fY#C\u0002\u0002V)\u0012a\u0001V;qY\u0016\u0014\u0004bBA-\u0019\u0001\u0007\u00111F\u0001\u000eY>\u001c\u0017\r^8s\u0011\u0006\u001c\b.Z:\t\r\u0005\u0005C\u00021\u0001|\u0003I9W\r\u001e\"fgR\u001cu.\\7p]B{\u0017N\u001c;\u0015\t\u0005\u0005\u0014Q\r\t\u0005cR\f\u0019\u0007\u0005\u0004*\u0003'Z\u0018Q\u0001\u0005\b\u00033j\u0001\u0019AA\u0016\u0003=9W\r\u001e\"m_\u000e\\\u0007*Z1eKJ\u001cH\u0003BA6\u0003k\u0002B!\u001d;\u0002nA1\u0011QFA\u001c\u0003_\u00022aMA9\u0013\r\t\u0019\b\u000e\u0002\u0010\u001b\u0006Lgn\u00195bS:DU-\u00193fe\"9\u0011q\u000f\bA\u0002\u0005-\u0012A\u00025bg\",7/\u0001\u0012qe>\u001cWm]:CY>\u001c7\u000eS3bI\u0016\u00148OU3ta>t7/\u001a)bs2|\u0017\r\u001a\u000b\u0005\u0003W\ni\bC\u0004\u0002\u0012=\u0001\r!a \u0011\r\u0005U\u00111DAA!\ry\u00131Q\u0005\u0004\u0003\u000bs\"a\u0007\"m_\u000e\\\u0007*Z1eKJ\u001c(+Z:q_:\u001cX\rU1zY>\fG-A\rtk\n\u001c8M]5cK>sW\u000b\u001d3bi\u0016$\u0016\u000e]#wK:$H\u0003BAF\u0003\u001b\u00032!\u001d;i\u0011\u001d\ty\t\u0005a\u0001\u0003#\u000bq\u0001[1oI2,'\u000fE\u00020\u0003'K1!!&\u001f\u0005]ye.\u00169eCR,G+\u001b9Fm\u0016tG\u000fS1oI2,'/A\u000ev]N,(m]2sS\n,wJ\\+qI\u0006$X\rV5q\u000bZ,g\u000e\u001e\u000b\u0004Q\u0006m\u0005bBAH#\u0001\u0007\u0011\u0011S\u0001\u0010g\u0016tGmQ3si&4\u0017nY1uKR!\u0011\u0011UAZ!\u0011\tH/a)\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006\u0019\u0011\r]5\u000b\u0007\u00055&%A\u0005nC&t7\r[1j]&!\u0011\u0011WAT\u0005]\u0019VM\u001c3DKJ$\u0018NZ5dCR,'+Z:q_:\u001cX\rC\u0004\u00026J\u0001\r!a.\u0002%\r,'\u000f^5gS\u000e\fG/\u001a*fcV,7\u000f\u001e\t\u0005\u0003K\u000bI,\u0003\u0003\u0002<\u0006\u001d&AF*f]\u0012\u001cUM\u001d;jM&\u001c\u0017\r^3SKF,Xm\u001d;\u0002CA\u0014xnY3tg\u000e+'\u000f^5gS\u000e\fG/\u001a*fgB|gn]3QCfdw.\u00193\u0015\t\u0005\r\u0016\u0011\u0019\u0005\b\u0003#\u0019\u0002\u0019AAb!\u0019\t)\"a\u0007\u0002FB\u0019q&a2\n\u0007\u0005%gD\u0001\u000eDKJ$\u0018NZ5dCR,'+Z:q_:\u001cX\rU1zY>\fG-A\rhKR$v\u000e])vC2LG/_\"feRLg-[2bi\u0016\u001cH\u0003BAh\u0003/\u0004B!\u001d;\u0002RB\u0019q&a5\n\u0007\u0005UgD\u0001\fU_B\fV/\u00197jif\u001cUM\u001d;jM&\u001c\u0017\r^3t\u0011\u001d\tI\u000e\u0006a\u0001\u0003\u000b\tAa]2JI\u0006Qq-\u001a;WKJ\u001c\u0018n\u001c8\u0015\u0007e\u000by\u000e\u0003\u0004\u0002bV\u0001\raU\u0001\fg&$Wm\u00195bS:LE-A\u0006hKR4VM]:j_:\u001cHc\u0001%\u0002h\"9\u0011\u0011\u001e\fA\u0002\u0005-\u0018\u0001D:jI\u0016\u001c\u0007.Y5o\u0013\u0012\u001c\b#BA\u0017\u0003o\u0019\u0016\u0001F4fiNKG-Z2iC&tg+\u001a:tS>t7\u000f\u0006\u0003\u0002r\u0006m\b\u0003B9u\u0003g\u0004b!!\f\u00028\u0005U\bcA\u0018\u0002x&\u0019\u0011\u0011 \u0010\u0003+MKG-Z2iC&tg+\u001a:tS>t7/\u00138g_\"9\u0011Q`\fA\u0002\u0005-\u0012!B:d\u0013\u0012\u001c\u0018\u0001G'bS:\u001c\u0007.Y5o\u001d>$Wm\u00115b]:,G.S7qYB\u0011q&G\n\u00033!\"\"A!\u0001\u0002-5\u000b\u0005lX*J\t\u0016\u001b\u0005*Q%O'~\u0013V)U+F'R+\u0012a_\u0001\u0018\u001b\u0006CvlU%E\u000b\u000eC\u0015)\u0013(T?J+\u0015+V#T)\u0002\u0002")
public class MainchainNodeChannelImpl
implements MainchainNodeChannel,
SidechainsVersionsManager {
    private final CommunicationClient client;
    private final NetworkParams params;
    private Map<ByteArrayWrapper, Enumeration.Value> sidechainsVersionsCache;

    public static int MAX_SIDECHAINS_REQUEST() {
        return MainchainNodeChannelImpl$.MODULE$.MAX_SIDECHAINS_REQUEST();
    }

    public Map<ByteArrayWrapper, Enumeration.Value> sidechainsVersionsCache() {
        return this.sidechainsVersionsCache;
    }

    public void sidechainsVersionsCache_$eq(Map<ByteArrayWrapper, Enumeration.Value> x$1) {
        this.sidechainsVersionsCache = x$1;
    }

    @Override
    public Try<MainchainBlockReference> getBlockByHeight(int height) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockResponsePayload> future = $this.client.sendRequest(GET_SINGLE_BLOCK_REQUEST_TYPE$.MODULE$, new GetBlockByHeightRequestPayload(height), BlockResponsePayload.class);
            return (MainchainBlockReference)this.processBlockResponsePayload(future).get();
        });
    }

    @Override
    public Try<MainchainBlockReference> getBlockByHash(String hash) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockResponsePayload> future = $this.client.sendRequest(GET_SINGLE_BLOCK_REQUEST_TYPE$.MODULE$, new GetBlockByHashRequestPayload(hash), BlockResponsePayload.class);
            return (MainchainBlockReference)this.processBlockResponsePayload(future).get();
        });
    }

    private Try<MainchainBlockReference> processBlockResponsePayload(Future<BlockResponsePayload> future) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BlockResponsePayload response = (BlockResponsePayload)Await$.MODULE$.result((Awaitable)future, (Duration)$this.client.requestTimeoutDuration());
            byte[] blockBytes = BytesUtils.fromHexString(response.block());
            return (MainchainBlockReference)MainchainBlockReference$.MODULE$.create(blockBytes, $this.params, this).get();
        });
    }

    @Override
    public Try<Seq<String>> getBlockHashesAfterHeight(int height, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlocksResponsePayload> future = $this.client.sendRequest(GET_MULTIPLE_BLOCK_HASHES_REQUEST_TYPE$.MODULE$, new GetBlocksAfterHeightRequestPayload(height, limit), BlocksResponsePayload.class);
            BlocksResponsePayload response = (BlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.hashes();
        });
    }

    @Override
    public Try<Seq<String>> getBlockHashesAfterHash(String hash, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlocksResponsePayload> future = $this.client.sendRequest(GET_MULTIPLE_BLOCK_HASHES_REQUEST_TYPE$.MODULE$, new GetBlocksAfterHashRequestPayload(hash, limit), BlocksResponsePayload.class);
            BlocksResponsePayload response = (BlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.hashes();
        });
    }

    @Override
    public Try<Tuple2<Object, Seq<String>>> getNewBlockHashes(Seq<String> locatorHashes, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<NewBlocksResponsePayload> future = $this.client.sendRequest(GET_NEW_BLOCK_HASHES_REQUEST_TYPE$.MODULE$, new GetNewBlocksRequestPayload(locatorHashes, limit), NewBlocksResponsePayload.class);
            NewBlocksResponsePayload response = (NewBlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)response.height()), response.hashes());
        });
    }

    @Override
    public Try<Tuple2<Object, String>> getBestCommonPoint(Seq<String> locatorHashes) {
        Success success;
        Tuple2 tuple2;
        Try<Tuple2<Object, Seq<String>>> try_ = this.getNewBlockHashes(locatorHashes, 1);
        if (!(try_ instanceof Success) || (tuple2 = (Tuple2)(success = (Success)try_).value()) == null) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError(try_);
        }
        int height = tuple2._1$mcI$sp();
        Seq hashes = (Seq)tuple2._2();
        Success success2 = new Success((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)height), hashes.head()));
        return success2;
    }

    @Override
    public Try<Seq<MainchainHeader>> getBlockHeaders(Seq<String> hashes) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockHeadersResponsePayload> future = $this.client.sendRequest(GET_MULTIPLE_HEADERS_REQUEST_TYPE$.MODULE$, new GetBlockHeadersRequestPayload(hashes), BlockHeadersResponsePayload.class);
            return (Seq)this.processBlockHeadersResponsePayload(future).get();
        });
    }

    private Try<Seq<MainchainHeader>> processBlockHeadersResponsePayload(Future<BlockHeadersResponsePayload> future) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BlockHeadersResponsePayload response = (BlockHeadersResponsePayload)Await$.MODULE$.result((Awaitable)future, (Duration)$this.client.requestTimeoutDuration());
            Seq<String> strHeaders = response.headers();
            Seq headers = (Seq)strHeaders.map((Function1 & Serializable & scala.Serializable)str -> (MainchainHeader)MainchainHeader$.MODULE$.create(BytesUtils.fromHexString(str), 0).get(), Seq$.MODULE$.canBuildFrom());
            return headers;
        });
    }

    @Override
    public Try<BoxedUnit> subscribeOnUpdateTipEvent(OnUpdateTipEventHandler handler) {
        return this.client.registerEventHandler(0, handler, OnUpdateTipEventPayload.class);
    }

    @Override
    public void unsubscribeOnUpdateTipEvent(OnUpdateTipEventHandler handler) {
        this.client.unregisterEventHandler(0, handler);
    }

    @Override
    public Try<SendCertificateResponse> sendCertificate(SendCertificateRequest certificateRequest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            Seq backwardTransfers = (Seq)certificateRequest.backwardTransfers().map((Function1 & Serializable & scala.Serializable)bt -> new BackwardTransfer(bt.address(), bt.amount()), Seq$.MODULE$.canBuildFrom());
            Option<String> option = certificateRequest.fee();
            if (option instanceof Some) {
                String fee;
                Some some = (Some)option;
                string = fee = (String)some.value();
            } else if (None$.MODULE$.equals(option)) {
                string = "-1";
            } else {
                throw new MatchError(option);
            }
            String fee = string;
            SendCertificateRequestPayload requestPayload = new SendCertificateRequestPayload(BytesUtils.toHexString(certificateRequest.sidechainId()), certificateRequest.epochNumber(), certificateRequest.quality(), BytesUtils.toHexString(certificateRequest.endEpochCumCommTreeHash()), BytesUtils.toHexString(certificateRequest.proofBytes()), (Seq<BackwardTransfer>)backwardTransfers, certificateRequest.ftrMinAmount(), certificateRequest.btrMinFee(), fee, (Seq<String>)((Seq)certificateRequest.fieldElementCertificateFields().map((Function1 & Serializable & scala.Serializable)bytes -> BytesUtils.toHexString(bytes), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)certificateRequest.bitVectorCertificateFields().map((Function1 & Serializable & scala.Serializable)bytes -> BytesUtils.toHexString(bytes), Seq$.MODULE$.canBuildFrom())));
            Future<CertificateResponsePayload> future = $this.client.sendRequest(SEND_CERTIFICATE_REQUEST_TYPE$.MODULE$, requestPayload, CertificateResponsePayload.class);
            return this.processCertificateResponsePayload(future);
        });
    }

    private SendCertificateResponse processCertificateResponsePayload(Future<CertificateResponsePayload> future) {
        CertificateResponsePayload response = (CertificateResponsePayload)Await$.MODULE$.result(future, (Duration)this.client.requestTimeoutDuration());
        return new SendCertificateResponse(BytesUtils.fromHexString(response.certificateHash()));
    }

    @Override
    public Try<TopQualityCertificates> getTopQualityCertificates(String scId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<TopQualityCertificateResponsePayload> future = $this.client.sendRequest(GET_TOP_QUALITY_CERTIFICATES_TYPE$.MODULE$, new TopQualityCertificatePayload(scId), TopQualityCertificateResponsePayload.class);
            TopQualityCertificateResponsePayload response = (TopQualityCertificateResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return new TopQualityCertificates(response.mempoolTopQualityCert(), response.chainTopQualityCert());
        });
    }

    @Override
    public Enumeration.Value getVersion(ByteArrayWrapper sidechainId) {
        return (Enumeration.Value)((Tuple2)this.getVersions((Seq<ByteArrayWrapper>)((Seq)new .colon.colon((Object)sidechainId, (List)Nil$.MODULE$))).head())._2();
    }

    @Override
    public Map<ByteArrayWrapper, Enumeration.Value> getVersions(Seq<ByteArrayWrapper> sidechainIds) {
        Seq unknown = (Seq)sidechainIds.filterNot((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)MainchainNodeChannelImpl.$anonfun$getVersions$1(this, id)));
        unknown.grouped(MainchainNodeChannelImpl$.MODULE$.MAX_SIDECHAINS_REQUEST()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            MainchainNodeChannelImpl.$anonfun$getVersions$2(this, group);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)sidechainIds.map((Function1 & Serializable & scala.Serializable)id -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(id), this.sidechainsVersionsCache().apply(id)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Try<Seq<SidechainVersionsInfo>> getSidechainVersions(Seq<String> scIds) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<GetSidechainVersionsResponsePayload> future = $this.client.sendRequest(GET_SIDECHAIN_VERSIONS_TYPE$.MODULE$, new GetSidechainVersionsRequestPayload(scIds), GetSidechainVersionsResponsePayload.class);
            GetSidechainVersionsResponsePayload response = (GetSidechainVersionsResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.sidechainVersions();
        });
    }

    public static final /* synthetic */ boolean $anonfun$getVersions$1(MainchainNodeChannelImpl $this, ByteArrayWrapper id) {
        return $this.sidechainsVersionsCache().contains((Object)id);
    }

    public static final /* synthetic */ boolean $anonfun$getVersions$4(SidechainVersionsInfo check$ifrefutable$1) {
        SidechainVersionsInfo sidechainVersionsInfo = check$ifrefutable$1;
        boolean bl = sidechainVersionsInfo != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$getVersions$2(MainchainNodeChannelImpl $this, Seq group) {
        Try<Seq<SidechainVersionsInfo>> try_ = $this.getSidechainVersions((Seq<String>)((Seq)group.map((Function1 & Serializable & scala.Serializable)id -> BytesUtils.toHexString(BytesUtils.reverseBytes(id.data())), Seq$.MODULE$.canBuildFrom())));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new RuntimeException("Can't retrieve sidechain versions.", exception);
            }
            throw new MatchError(try_);
        }
        Success success = (Success)try_;
        Seq res = (Seq)success.value();
        res.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MainchainNodeChannelImpl.$anonfun$getVersions$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)info -> {
            $this.sidechainsVersionsCache_$eq((Map<ByteArrayWrapper, Enumeration.Value>)$this.sidechainsVersionsCache().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ByteArrayWrapper(BytesUtils.reverseBytes(BytesUtils.fromHexString(info.scId())))), (Object)SidechainCreationVersions$.MODULE$.getVersion(info.version()))));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public MainchainNodeChannelImpl(CommunicationClient client, NetworkParams params) {
        this.client = client;
        this.params = params;
        this.sidechainsVersionsCache = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

