/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import java.util.HashMap;
import java.util.Map;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;
import scorex.util.serialization.Reader;
import scorex.util.serialization.Writer;

public class DynamicTypedSerializer<T extends BytesSerializable, S extends ScorexSerializer<T>>
implements ScorexSerializer<T> {
    protected HashMap<Byte, S> coreSerializers;
    protected HashMap<Class, Byte> coreSerializersClasses;
    protected HashMap<Byte, S> customSerializers;
    protected HashMap<Class, Byte> customSerializersClasses;
    protected byte CUSTOM_SERIALIZER_TYPE = (byte)127;

    public DynamicTypedSerializer(HashMap<Byte, S> coreSerializers, HashMap<Byte, S> customSerializers) {
        this.coreSerializers = coreSerializers;
        this.customSerializers = customSerializers;
        this.coreSerializersClasses = new HashMap();
        for (Map.Entry<Byte, S> entry : this.coreSerializers.entrySet()) {
            this.coreSerializersClasses.put(((ScorexSerializer)entry.getValue()).getClass(), entry.getKey());
        }
        if (this.coreSerializers.size() != this.coreSerializersClasses.size()) {
            throw new IllegalArgumentException("Core Serializers class types expected to be unique.");
        }
        this.customSerializersClasses = new HashMap();
        for (Map.Entry<Byte, S> entry : this.customSerializers.entrySet()) {
            this.customSerializersClasses.put(((ScorexSerializer)entry.getValue()).getClass(), entry.getKey());
        }
        if (this.customSerializers.size() != this.customSerializersClasses.size()) {
            throw new IllegalArgumentException("Custom Serializers class types expected to be unique.");
        }
    }

    public void serialize(T obj, Writer writer) {
        ScorexSerializer serializer = obj.serializer();
        if (this.coreSerializersClasses.containsKey(serializer.getClass())) {
            byte idOfSerializer = this.coreSerializersClasses.get(serializer.getClass());
            writer.put(idOfSerializer);
            serializer.serialize(obj, writer);
        } else if (this.customSerializersClasses.containsKey(serializer.getClass())) {
            byte idOfSerializer = this.customSerializersClasses.get(serializer.getClass());
            writer.put(this.CUSTOM_SERIALIZER_TYPE);
            writer.put(idOfSerializer);
            serializer.serialize(obj, writer);
        } else {
            throw new IllegalArgumentException("Object without defined serializer occurred.");
        }
    }

    public T parse(Reader reader) {
        if (reader.remaining() < 1) {
            throw new IllegalArgumentException("Unknown custom type id.");
        }
        byte type = reader.getByte();
        if (type == this.CUSTOM_SERIALIZER_TYPE) {
            byte customType = reader.getByte();
            ScorexSerializer serializer = (ScorexSerializer)this.customSerializers.get(customType);
            if (serializer != null) {
                return (T)((BytesSerializable)serializer.parse(reader));
            }
            throw new IllegalArgumentException("Unknown custom type id.");
        }
        ScorexSerializer serializer = (ScorexSerializer)this.coreSerializers.get(type);
        if (serializer != null) {
            return (T)((BytesSerializable)serializer.parse(reader));
        }
        throw new IllegalArgumentException("Unknown core type id.");
    }
}

