/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.utils;

import com.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.util.Arrays;

public class ByteArrayWrapper
implements Serializable,
Comparable<ByteArrayWrapper> {
    private byte[] data;

    public int size() {
        return this.data.length;
    }

    public byte[] data() {
        return this.data;
    }

    public ByteArrayWrapper(byte[] data) {
        assert (data != null);
        this.data = data;
    }

    public ByteArrayWrapper(Integer size) {
        this.data = new byte[size.intValue()];
    }

    public ByteArrayWrapper(ByteArrayWrapper wrapper) {
        this(wrapper.data);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (String)(this.size() == 8 ? String.valueOf(BytesUtils.getLong(this.data, 0)) + "L" : BytesUtils.toHexString(this.data)) + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return Arrays.equals(this.data, ((ByteArrayWrapper)obj).data);
    }

    public int hashCode() {
        int h = 1;
        for (byte b : this.data) {
            h = h * -1640531527 + b;
        }
        return h;
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        return ByteArrayWrapper.compare(this.data, o.data);
    }

    public static int compare(byte[] o1, byte[] o2) {
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            int b1 = o1[i] & 0xFF;
            int b2 = o2[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return o1.length - o2.length;
    }
}

