/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import com.horizen.box.ForgerBox;
import com.horizen.box.data.ForgerBoxData;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.proposition.VrfPublicKey;
import com.horizen.transaction.mainchain.SidechainCreationSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.Utils;
import java.util.Optional;
import scala.compat.java8.OptionConverters;
import scorex.crypto.hash.Blake2b256;

public final class SidechainCreation
implements SidechainRelatedMainchainOutput<ForgerBox> {
    private MainchainTxSidechainCreationCrosschainOutput output;
    private byte[] containingTxHash;
    private int index;

    public SidechainCreation(MainchainTxSidechainCreationCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{this.output.hash(), this.containingTxHash, BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public byte[] transactionHash() {
        return this.containingTxHash;
    }

    @Override
    public byte[] sidechainId() {
        return this.output.sidechainId();
    }

    @Override
    public ForgerBox getBox() {
        PublicKey25519Proposition proposition = new PublicKey25519Proposition(BytesUtils.reverseBytes(this.output.address()));
        long value = this.output.amount();
        VrfPublicKey vrfPublicKey = new VrfPublicKey(this.output.customCreationData());
        ForgerBoxData forgerBoxData = new ForgerBoxData(proposition, value, proposition, vrfPublicKey);
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.containingTxHash, Ints.toByteArray((int)this.index)}));
        long nonce = BytesUtils.getLong(hash, 0);
        return forgerBoxData.getBox(nonce);
    }

    @Override
    public int transactionIndex() {
        return this.index;
    }

    public MainchainTxSidechainCreationCrosschainOutput getScCrOutput() {
        return this.output;
    }

    public Optional<byte[]> getGenSysConstantOpt() {
        return OptionConverters.toJava(this.output.constantOpt());
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return SidechainCreationSerializer.getSerializer();
    }

    public int withdrawalEpochLength() {
        return this.output.withdrawalEpochLength();
    }
}

