/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import com.horizen.box.ZenBox;
import com.horizen.box.data.ZenBoxData;
import com.horizen.proposition.PublicKey25519Proposition;
import com.horizen.transaction.mainchain.ForwardTransferSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.Utils;
import scorex.crypto.hash.Blake2b256;

public final class ForwardTransfer
implements SidechainRelatedMainchainOutput<ZenBox> {
    private MainchainTxForwardTransferCrosschainOutput output;
    private byte[] containingTxHash;
    private int index;

    public ForwardTransfer(MainchainTxForwardTransferCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{this.output.hash(), this.containingTxHash, BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public byte[] transactionHash() {
        return this.containingTxHash;
    }

    @Override
    public int transactionIndex() {
        return this.index;
    }

    @Override
    public byte[] sidechainId() {
        return this.output.sidechainId();
    }

    @Override
    public ZenBox getBox() {
        byte[] hash = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.containingTxHash, Ints.toByteArray((int)this.index)}));
        long nonce = BytesUtils.getLong(hash, 0);
        return new ZenBox(new ZenBoxData(new PublicKey25519Proposition(BytesUtils.reverseBytes(this.output.propositionBytes())), this.output.amount()), nonce);
    }

    public MainchainTxForwardTransferCrosschainOutput getFtOutput() {
        return this.output;
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return ForwardTransferSerializer.getSerializer();
    }

    public String toString() {
        return String.format("ForwardTransfer {\ntxHash = %s\nindex = %d\nftoutput = %s\n}", BytesUtils.toHexString(this.containingTxHash), this.index, this.output);
    }
}

