/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.block.MainchainTxBwtRequestCrosschainOutput;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.transaction.mainchain.BwtRequestSerializer;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import com.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.Utils;

public final class BwtRequest
implements SidechainRelatedMainchainOutput<WithdrawalRequestBox> {
    private final MainchainTxBwtRequestCrosschainOutput output;
    private final byte[] containingTxHash;
    private final int index;

    public BwtRequest(MainchainTxBwtRequestCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{this.output.hash(), this.containingTxHash, BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public byte[] transactionHash() {
        return this.containingTxHash;
    }

    @Override
    public byte[] sidechainId() {
        return this.output.sidechainId();
    }

    @Override
    public WithdrawalRequestBox getBox() {
        throw new UnsupportedOperationException("There is no support of BwtRequest processing at the moment.");
    }

    @Override
    public int transactionIndex() {
        return this.index;
    }

    public MainchainTxBwtRequestCrosschainOutput getBwtOutput() {
        return this.output;
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return BwtRequestSerializer.getSerializer();
    }
}

