/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.horizen.box.Box;
import com.horizen.box.data.BoxData;
import com.horizen.proposition.Proposition;
import com.horizen.transaction.SidechainTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SidechainNoncedTransaction<P extends Proposition, B extends Box<P>, D extends BoxData<P, B>>
extends SidechainTransaction<P, B> {
    private List<B> newBoxes;
    private List<P> newBoxesPropositions;

    protected abstract List<D> getOutputData();

    @Override
    protected final List<P> newBoxesPropositions() {
        if (this.newBoxesPropositions == null) {
            this.newBoxesPropositions = this.getOutputData().stream().map(BoxData::proposition).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.newBoxesPropositions);
    }

    @Override
    public final synchronized List<B> newBoxes() {
        if (this.newBoxes == null) {
            List<D> outputsData = this.getOutputData();
            this.newBoxes = new ArrayList<B>();
            for (int i = 0; i < outputsData.size(); ++i) {
                BoxData boxData = (BoxData)outputsData.get(i);
                long nonce = this.getNewBoxNonce(boxData.proposition(), i);
                this.newBoxes.add(boxData.getBox(nonce));
            }
        }
        return Collections.unmodifiableList(this.newBoxes);
    }
}

