/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage.leveldb;

import com.horizen.storage.StorageIterator;
import com.horizen.storage.leveldb.ChangeSet;
import com.horizen.storage.leveldb.ChangeSetSerializer$;
import com.horizen.storage.leveldb.DatabaseIterator;
import com.horizen.storage.leveldb.KVStore;
import com.horizen.storage.leveldb.package$Algos$;
import com.horizen.storage.leveldb.package$Constants$;
import com.horizen.utils.ByteArrayWrapper;
import java.io.Serializable;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\u000b\u0016\u0005yA\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0002\f\u0005\tm\u0001\u0011\t\u0011)A\u0005[!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003?\u0001\u0011\u0005q\bC\u0004D\u0001\t\u0007I\u0011\u0001#\t\r-\u0003\u0001\u0015!\u0003F\u0011\u001da\u0005A1A\u0005\u00025CaA\u0014\u0001!\u0002\u0013A\u0005\"B(\u0001\t\u0003\u0001\u0006bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F\u001d)A-\u0006E\u0001K\u001a)A#\u0006E\u0001M\")a(\u0005C\u0001U\u0016!1.\u0005\u0001F\u0005M1VM]:j_:,G\r\u0014#C\u0017Z\u001bFo\u001c:f\u0015\t1r#A\u0004mKZ,G\u000e\u001a2\u000b\u0005aI\u0012aB:u_J\fw-\u001a\u0006\u00035m\tq\u0001[8sSj,gNC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\r\u0001qd\n\t\u0003A\u0015j\u0011!\t\u0006\u0003E\r\nA\u0001\\1oO*\tA%\u0001\u0003kCZ\f\u0017B\u0001\u0014\"\u0005\u0019y%M[3diB\u0011\u0001&K\u0007\u0002+%\u0011!&\u0006\u0002\b\u0017Z\u001bFo\u001c:f\u0003\t!'-F\u0001.!\tqC'D\u00010\u0015\t1\u0002G\u0003\u00022e\u0005!\u0011.\u001d\u001d1\u0015\u0005\u0019\u0014aA8sO&\u0011Qg\f\u0002\u0003\t\n\u000b1\u0001\u001a2!\u00031YW-\u001a9WKJ\u001c\u0018n\u001c8t!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\u000b%\t\u0005\u0002)\u0001!)1\u0006\u0002a\u0001[!)q\u0007\u0002a\u0001q\u0005Ya+\u001a:tS>t7oS3z+\u0005)\u0005cA\u001dG\u0011&\u0011qI\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003s%K!A\u0013\u001e\u0003\t\tKH/Z\u0001\r-\u0016\u00148/[8og.+\u0017\u0010I\u0001\u0010\u0007\"\fgnZ3TKR\u0004&/\u001a4jqV\t\u0001*\u0001\tDQ\u0006tw-Z*fiB\u0013XMZ5yA\u00051Q\u000f\u001d3bi\u0016$B!\u00157\u0002\u0004Q\u0011!+\u0016\t\u0003sMK!\u0001\u0016\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006-&\u0001\raV\u0001\bm\u0016\u00148/[8o!\tA6C\u0004\u0002Z!9\u0011!l\u0019\b\u00037\nt!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}k\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\tQ2$\u0003\u0002\u00193%\u0011acF\u0001\u0014-\u0016\u00148/[8oK\u0012dEIQ&W'R|'/\u001a\t\u0003QE\u0019\"!E4\u0011\u0005eB\u0017BA5;\u0005\u0019\te.\u001f*fMR\tQMA\u0005WKJ\u001c\u0018n\u001c8JI\")Q.\u0003a\u0001]\u0006AAo\\%og\u0016\u0014H\u000fE\u0002pi^t!\u0001\u001d:\u000f\u0005u\u000b\u0018\"A\u001e\n\u0005MT\u0014a\u00029bG.\fw-Z\u0005\u0003kZ\u00141aU3r\u0015\t\u0019(\b\u0005\u0003:qjt\u0018BA=;\u0005\u0019!V\u000f\u001d7feA\u00111\u0010`\u0007\u0002\u0001%\u0011Q0\u000b\u0002\u0002\u0017B\u00111p`\u0005\u0004\u0003\u0003I#!\u0001,\t\u000f\u0005\u0015\u0011\u00021\u0001\u0002\b\u0005AAo\u001c*f[>4X\rE\u0002pij\fa!\u001b8tKJ$H\u0003BA\u0007\u0003#!2AUA\b\u0011\u00151&\u00021\u0001X\u0011\u0015i'\u00021\u0001o\u0003\u0019\u0011X-\\8wKR!\u0011qCA\u000e)\r\u0011\u0016\u0011\u0004\u0005\u0006-.\u0001\ra\u0016\u0005\b\u0003\u000bY\u0001\u0019AA\u0004\u0003)\u0011x\u000e\u001c7cC\u000e\\Gk\u001c\u000b\u0005\u0003C\ti\u0003E\u0003\u0002$\u0005%\"+\u0004\u0002\u0002&)\u0019\u0011q\u0005\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\t)CA\u0002UefDa!a\f\r\u0001\u00049\u0016!\u0003<feNLwN\\%e\u0003!1XM]:j_:\u001cXCAA\u001b!\ryGoV\u0001\u0010m\u0016\u00148/[8o\u0013\u0012,\u00050[:ugR!\u00111HA!!\rI\u0014QH\u0005\u0004\u0003\u007fQ$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003_q\u0001\u0019A,\u0002\u0017\u001d,G/\u0013;fe\u0006$xN\u001d\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002L5\tq#C\u0002\u0002N]\u0011qb\u0015;pe\u0006<W-\u0013;fe\u0006$xN\u001d")
public final class VersionedLDBKVStore
implements KVStore {
    private final DB db;
    private final int keepVersions;
    private final byte[] VersionsKey;
    private final byte ChangeSetPrefix;

    @Override
    public Option<byte[]> get(byte[] key) {
        return KVStore.get$((KVStore)this, key);
    }

    @Override
    public Seq<Tuple2<byte[], byte[]>> getAll(Function2<byte[], byte[], Object> cond) {
        return KVStore.getAll$(this, cond);
    }

    @Override
    public Seq<Tuple2<byte[], byte[]>> getAll() {
        return KVStore.getAll$(this);
    }

    @Override
    public byte[] getOrElse(byte[] key, Function0<byte[]> function0) {
        return KVStore.getOrElse$(this, key, function0);
    }

    @Override
    public Seq<Tuple2<byte[], Option<byte[]>>> get(Seq<byte[]> keys) {
        return KVStore.get$((KVStore)this, keys);
    }

    @Override
    public void close() {
        KVStore.close$(this);
    }

    @Override
    public DB db() {
        return this.db;
    }

    public byte[] VersionsKey() {
        return this.VersionsKey;
    }

    public byte ChangeSetPrefix() {
        return this.ChangeSetPrefix;
    }

    public void update(Seq<Tuple2<byte[], byte[]>> toInsert, Seq<byte[]> toRemove, byte[] version) {
        Predef$.MODULE$.require(version.length == package$Constants$.MODULE$.HashLength(), (Function0 & Serializable & scala.Serializable)() -> "Illegal version id size");
        ReadOptions ro = new ReadOptions();
        ro.snapshot(this.db().getSnapshot());
        Predef$.MODULE$.require(Option$.MODULE$.apply((Object)this.db().get(version, ro)).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Version id is already used");
        ArrayBuffer insertedKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer altered = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        toInsert.foreach((Function1 & Serializable & scala.Serializable)x -> {
            VersionedLDBKVStore.$anonfun$update$3(this, ro, insertedKeys, altered, x);
            return BoxedUnit.UNIT;
        });
        Seq removed = (Seq)toRemove.flatMap((Function1 & Serializable & scala.Serializable)k -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.db().get(k, ro)).map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), x$1))), Seq$.MODULE$.canBuildFrom());
        ChangeSet changeSet = new ChangeSet((Seq<byte[]>)insertedKeys, (Seq<Tuple2<byte[], byte[]>>)removed, (Seq<Tuple2<byte[], byte[]>>)altered);
        Tuple2 tuple2 = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey(), ro)).map((Function1 & Serializable & scala.Serializable)x$2 -> (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(version)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> version))).splitAt(package$Constants$.MODULE$.HashLength() * this.keepVersions);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] updatedVersions = (byte[])tuple2._1();
        byte[] versionsToShrink = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)updatedVersions, (Object)versionsToShrink);
        Tuple2 tuple23 = tuple22;
        byte[] updatedVersions2 = (byte[])tuple23._1();
        byte[] versionsToShrink2 = (byte[])tuple23._2();
        Iterator versionIdsToShrink = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(versionsToShrink2)).grouped(package$Constants$.MODULE$.HashLength());
        WriteBatch batch = this.db().createWriteBatch();
        try {
            batch.put(this.VersionsKey(), updatedVersions2);
            versionIdsToShrink.foreach((Function1 & Serializable & scala.Serializable)key -> batch.delete(key));
            byte by = this.ChangeSetPrefix();
            batch.put(version, (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(ChangeSetSerializer$.MODULE$.toBytes(changeSet))).$plus$colon((Object)BoxesRunTime.boxToByte((byte)by), ClassTag$.MODULE$.Byte()));
            toInsert.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                byte[] k = (byte[])tuple2._1();
                byte[] v = (byte[])tuple2._2();
                WriteBatch writeBatch = batch.put(k, v);
                return writeBatch;
            });
            toRemove.foreach((Function1 & Serializable & scala.Serializable)key -> batch.delete(key));
            this.db().write(batch);
        }
        finally {
            batch.close();
            ro.snapshot().close();
        }
    }

    public void insert(Seq<Tuple2<byte[], byte[]>> toInsert, byte[] version) {
        this.update(toInsert, (Seq<byte[]>)((Seq)Nil$.MODULE$), version);
    }

    public void remove(Seq<byte[]> toRemove, byte[] version) {
        this.update((Seq<Tuple2<byte[], byte[]>>)((Seq)Nil$.MODULE$), toRemove, version);
    }

    public Try<BoxedUnit> rollbackTo(byte[] versionId) {
        Failure failure;
        ReadOptions ro = new ReadOptions();
        ro.snapshot(this.db().getSnapshot());
        Option option = Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey()));
        if (option instanceof Some) {
            Success success;
            Some some = (Some)option;
            byte[] bytes = (byte[])some.value();
            WriteBatch batch = this.db().createWriteBatch();
            try {
                Iterator versionsToRollBack = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).grouped(package$Constants$.MODULE$.HashLength()).takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$rollbackTo$1(versionId, x$5)));
                ((IterableLike)versionsToRollBack.foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Seq acc = (Seq)tuple2._1();
                    byte[] verId = (byte[])tuple2._2();
                    Option changeSetOpt = Option$.MODULE$.apply((Object)this.db().get(verId, ro)).flatMap((Function1 & Serializable & scala.Serializable)changeSetBytes -> ChangeSetSerializer$.MODULE$.parseBytesTry((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(changeSetBytes)).tail()).toOption());
                    Predef$.MODULE$.require(changeSetOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Inconsistent versioned storage state");
                    Seq seq = (Seq)acc.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(changeSetOpt).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)verId), x$6), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    return seq;
                })).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    byte[] verId = (byte[])tuple2._1();
                    ChangeSet changeSet = (ChangeSet)tuple2._2();
                    changeSet.insertedKeys().foreach((Function1 & Serializable & scala.Serializable)k -> batch.delete(k));
                    changeSet.removed().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte[] k = (byte[])tuple2._1();
                        byte[] v = (byte[])tuple2._2();
                        WriteBatch writeBatch = batch.put(k, v);
                        return writeBatch;
                    });
                    changeSet.altered().foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        byte[] k = (byte[])tuple2._1();
                        byte[] oldV = (byte[])tuple2._2();
                        WriteBatch writeBatch = batch.put(k, oldV);
                        return writeBatch;
                    });
                    WriteBatch writeBatch = batch.delete(verId);
                    return writeBatch;
                });
                ByteArrayWrapper wrappedVersionId = new ByteArrayWrapper(versionId);
                byte[] updatedVersions = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).grouped(package$Constants$.MODULE$.HashLength()).map((Function1 & Serializable & scala.Serializable)x$7 -> new ByteArrayWrapper((byte[])x$7)).dropWhile((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$rollbackTo$11(wrappedVersionId, x$8))).foldLeft(Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Function2 & Serializable & scala.Serializable)(x0$5, x1$2) -> {
                    Tuple2 tuple2 = new Tuple2(x0$5, x1$2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    byte[] acc = (byte[])tuple2._1();
                    ByteArrayWrapper arr = (ByteArrayWrapper)tuple2._2();
                    byte[] byArray = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(acc)).$plus$plus((GenTraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr.data())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                    return byArray;
                });
                versionsToRollBack.foreach((Function1 & Serializable & scala.Serializable)key -> batch.delete(key));
                batch.put(this.VersionsKey(), updatedVersions);
                this.db().write(batch);
                success = new Success((Object)BoxedUnit.UNIT);
            }
            finally {
                batch.close();
                ro.snapshot().close();
            }
            failure = success;
        } else if (None$.MODULE$.equals(option)) {
            failure = new Failure((Throwable)new Exception(new StringBuilder(18).append("Version ").append(package$Algos$.MODULE$.encode(versionId)).append(" not found").toString()));
        } else {
            throw new MatchError((Object)option);
        }
        return failure;
    }

    public Seq<byte[]> versions() {
        return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.db().get(this.VersionsKey()))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(x$9)).grouped(package$Constants$.MODULE$.HashLength()), Seq$.MODULE$.canBuildFrom());
    }

    public boolean versionIdExists(byte[] versionId) {
        return this.versions().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)VersionedLDBKVStore.$anonfun$versionIdExists$1(versionId, x$10)));
    }

    public StorageIterator getIterator() {
        return new DatabaseIterator(this.db().iterator());
    }

    public static final /* synthetic */ void $anonfun$update$3(VersionedLDBKVStore $this, ReadOptions ro$1, ArrayBuffer insertedKeys$1, ArrayBuffer altered$1, Tuple2 x) {
        Option$.MODULE$.apply((Object)$this.db().get((byte[])x._1(), ro$1)).fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> insertedKeys$1.$plus$eq(x._1()), (Function1 & Serializable & scala.Serializable)oldValue -> {
            altered$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)oldValue));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$rollbackTo$1(byte[] versionId$1, byte[] x$5) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(x$5);
        ByteArrayWrapper byteArrayWrapper2 = new ByteArrayWrapper(versionId$1);
        return byteArrayWrapper == null ? byteArrayWrapper2 != null : !((Object)byteArrayWrapper).equals(byteArrayWrapper2);
    }

    public static final /* synthetic */ boolean $anonfun$rollbackTo$11(ByteArrayWrapper wrappedVersionId$1, ByteArrayWrapper x$8) {
        ByteArrayWrapper byteArrayWrapper = x$8;
        ByteArrayWrapper byteArrayWrapper2 = wrappedVersionId$1;
        return byteArrayWrapper == null ? byteArrayWrapper2 != null : !((Object)byteArrayWrapper).equals(byteArrayWrapper2);
    }

    public static final /* synthetic */ boolean $anonfun$versionIdExists$1(byte[] versionId$2, byte[] x$10) {
        ByteArrayWrapper byteArrayWrapper = new ByteArrayWrapper(x$10);
        ByteArrayWrapper byteArrayWrapper2 = new ByteArrayWrapper(versionId$2);
        return !(byteArrayWrapper != null ? !((Object)byteArrayWrapper).equals(byteArrayWrapper2) : byteArrayWrapper2 != null);
    }

    public VersionedLDBKVStore(DB db, int keepVersions) {
        this.db = db;
        this.keepVersions = keepVersions;
        KVStore.$init$(this);
        this.VersionsKey = package$Algos$.MODULE$.hash().apply("versions");
        this.ChangeSetPrefix = (byte)22;
    }
}

