/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.ForgerBoxSerializer;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\u0007\u000e\u0001QA\u0001B\u0004\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006]\u0001!\ta\f\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u0019Q\u0004\u0001)A\u0005i!)1\b\u0001C\u0001y!)1\n\u0001C\u0001\u0019\")\u0011\f\u0001C\u00015\")A\u000f\u0001C!k\")q\u000f\u0001C\u0001q\")!\u0010\u0001C\u0001w\")Q\u0010\u0001C\u0001}\nq2+\u001b3fG\"\f\u0017N\\*uCR,gi\u001c:hKJ\u0014u\u000e_*u_J\fw-\u001a\u0006\u0003\u001d=\tqa\u001d;pe\u0006<WM\u0003\u0002\u0011#\u00059\u0001n\u001c:ju\u0016t'\"\u0001\n\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001)2dI\u0014\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003vi&d'\"\u0001\u0011\u0002\rM\u001cwN]3y\u0013\t\u0011SDA\u0007TG>\u0014X\r\u001f'pO\u001eLgn\u001a\t\u0003I\u0015j\u0011!D\u0005\u0003M5\u0011AcU5eK\u000eD\u0017-\u001b8Ti>\u0014\u0018mZ3J]\u001a|\u0007C\u0001\u0015*\u001b\u0005y\u0011B\u0001\u0016\u0010\u00059\u0019\u0016\u000eZ3dQ\u0006Lg\u000eV=qKN\u0004\"\u0001\n\u0017\n\u00055j!aB*u_J\fw-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\n\u0004C\u0001\u0013\u0001\u0011\u0015q!\u00011\u0001,\u0003M1wN]4fe\n{\u0007pU3sS\u0006d\u0017N_3s+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\u0010\u0003\r\u0011w\u000e_\u0005\u0003sY\u00121CR8sO\u0016\u0014(i\u001c=TKJL\u0017\r\\5{KJ\fACZ8sO\u0016\u0014(i\u001c=TKJL\u0017\r\\5{KJ\u0004\u0013\u0001D4fi\u001a{'oZ3s\u0005>DHCA\u001fD!\r1b\bQ\u0005\u0003\u007f]\u0011aa\u00149uS>t\u0007CA\u001bB\u0013\t\u0011eGA\u0005G_J<WM\u001d\"pq\")A)\u0002a\u0001\u000b\u0006)!m\u001c=JIB\u0019aC\u0012%\n\u0005\u001d;\"!B!se\u0006L\bC\u0001\fJ\u0013\tQuC\u0001\u0003CsR,\u0017!E4fi\u0006cGNR8sO\u0016\u0014(i\u001c=fgV\tQ\nE\u0002O-\u0002s!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005I\u001b\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t)v#A\u0004qC\u000e\\\u0017mZ3\n\u0005]C&aA*fc*\u0011QkF\u0001\u0007kB$\u0017\r^3\u0015\tm\u0003\u0007N\u001b\t\u00049z\u0003T\"A/\u000b\u0005y9\u0012BA0^\u0005\r!&/\u001f\u0005\u0006C\u001e\u0001\rAY\u0001\bm\u0016\u00148/[8o!\t\u0019g-D\u0001e\u0015\t)w\"A\u0003vi&d7/\u0003\u0002hI\n\u0001\")\u001f;f\u0003J\u0014\u0018-_,sCB\u0004XM\u001d\u0005\u0006S\u001e\u0001\r!T\u0001\u0013M>\u0014x-\u001a:C_b,\u0006\u000fZ1uKN+\u0017\u000fC\u0003l\u000f\u0001\u0007A.A\bc_bLEm\u001d*f[>4XmU3u!\ri\u0017O\u0019\b\u0003]>\u0004\"\u0001U\f\n\u0005A<\u0012A\u0002)sK\u0012,g-\u0003\u0002sg\n\u00191+\u001a;\u000b\u0005A<\u0012!\u00047bgR4VM]:j_:LE-F\u0001w!\r1bHY\u0001\u0011e>dGNY1dWZ+'o]5p]N,\u0012!\u001f\t\u0004\u001dZ\u0013\u0017\u0001\u0003:pY2\u0014\u0017mY6\u0015\u0005mc\b\"B1\u000b\u0001\u0004\u0011\u0017aB5t\u000b6\u0004H/_\u000b\u0002\u007fB\u0019a#!\u0001\n\u0007\u0005\rqCA\u0004C_>dW-\u00198")
public class SidechainStateForgerBoxStorage
implements ScorexLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final ForgerBoxSerializer forgerBoxSerializer;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ForgerBoxSerializer forgerBoxSerializer() {
        return this.forgerBoxSerializer;
    }

    public Option<ForgerBox> getForgerBox(byte[] boxId) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(Utils.calculateKey(boxId))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try try_ = this.forgerBoxSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ForgerBox box = (ForgerBox)success.value();
                option3 = Option$.MODULE$.apply((Object)box);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("SidechainStateForgerBoxStorage: Error while ForgerBox parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Seq<ForgerBox> getAllForgerBoxes() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).map((Function1 & Serializable & scala.Serializable)pair -> (ForgerBox)this.forgerBoxSerializer().parseBytes(((ByteArrayWrapper)pair.getValue()).data()), Buffer$.MODULE$.canBuildFrom());
    }

    public Try<SidechainStateForgerBoxStorage> update(ByteArrayWrapper version, Seq<ForgerBox> forgerBoxUpdateSeq, Set<ByteArrayWrapper> boxIdsRemoveSet) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(forgerBoxUpdateSeq != null, (Function0 & Serializable & scala.Serializable)() -> "List of ForgerBoxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            boxIdsRemoveSet.foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)removeList.add(Utils.calculateKey(id.data()))));
            forgerBoxUpdateSeq.foreach((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(box.id()), new ByteArrayWrapper(this.forgerBoxSerializer().toBytes(box))))));
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainStateForgerBoxStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainStateForgerBoxStorage: Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainStateForgerBoxStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.forgerBoxSerializer = ForgerBoxSerializer.getSerializer();
    }
}

