/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.ForgerBoxSerializer;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.consensus.package$ConsensusEpochNumber$;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.ForgerBoxMerklePathInfoSerializer$;
import com.horizen.utils.ForgingStakeMerklePathInfo;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.hash.Blake2b256$;
import scorex.util.ScorexLogging;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\f\u0019\u0001}A\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\u0007{\u0001!\tA\u0007 \t\u0011e\u0003!\u0019!C\u00015iCaa\u0017\u0001!\u0002\u0013y\u0004\u0002\u0003/\u0001\u0005\u0004%\tAG/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011!\u0011\u0007A1A\u0005\u0002i\u0019\u0007B\u00026\u0001A\u0003%A\r\u0003\u0005l\u0001\t\u0007I\u0011\u0001\u000em\u0011\u0019!\b\u0001)A\u0005[\")Q\u000f\u0001C\u00055\")a\u000f\u0001C\u0001o\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u0019\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003w\u0001A\u0011AA\u001f\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002J\u0001!\t!a\u0015\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004BBA5\u0001\u0011\u0005QLA\fG_J<\u0017N\\4C_b,7/\u00138g_N#xN]1hK*\u0011\u0011DG\u0001\bgR|'/Y4f\u0015\tYB$A\u0004i_JL'0\u001a8\u000b\u0003u\t1aY8n\u0007\u0001\u0019R\u0001\u0001\u0011'U9\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014)\u001b\u0005Q\u0012BA\u0015\u001b\u00059\u0019\u0016\u000eZ3dQ\u0006Lg\u000eV=qKN\u0004\"a\u000b\u0017\u000e\u0003aI!!\f\r\u0003)MKG-Z2iC&t7\u000b^8sC\u001e,\u0017J\u001c4p!\tyC'D\u00011\u0015\t\t$'\u0001\u0003vi&d'\"A\u001a\u0002\rM\u001cwN]3y\u0013\t)\u0004GA\u0007TG>\u0014X\r\u001f'pO\u001eLgn\u001a\t\u0003W]J!\u0001\u000f\r\u0003\u000fM#xN]1hK\u00061A(\u001b8jiz\"\"a\u000f\u001f\u0011\u0005-\u0002\u0001\"B\r\u0003\u0001\u00041\u0014\u0001C3q_\u000eD7*Z=\u0015\u0005}*\u0005C\u0001!D\u001b\u0005\t%B\u0001\"\u001b\u0003\u0015)H/\u001b7t\u0013\t!\u0015I\u0001\tCsR,\u0017I\u001d:bs^\u0013\u0018\r\u001d9fe\")ai\u0001a\u0001\u000f\u0006)Q\r]8dQB\u0011\u0001J\u0016\b\u0003\u0013Ns!AS)\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(\u001f\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002\u001c9%\u0011!KG\u0001\nG>t7/\u001a8tkNL!\u0001V+\u0002\u000fA\f7m[1hK*\u0011!KG\u0005\u0003/b\u0013AcQ8og\u0016t7/^:Fa>\u001c\u0007NT;nE\u0016\u0014(B\u0001+V\u000391wN]4fe\n{\u00070Z:LKf,\u0012aP\u0001\u0010M>\u0014x-\u001a:C_b,7oS3zA\u00059R.\u0019=Ok6\u0014WM](g'R|'/\u001a3Fa>\u001c\u0007n]\u000b\u0002=B\u0011\u0011eX\u0005\u0003A\n\u00121!\u00138u\u0003ai\u0017\r\u001f(v[\n,'o\u00144Ti>\u0014X\rZ#q_\u000eD7\u000fI\u0001)M>\u0014x-\u001b8h'R\f7.Z'fe.dW\rU1uQ&sgm\u001c'jgR\u001cVM]5bY&TXM]\u000b\u0002IB\u0019\u0001)Z4\n\u0005\u0019\f%A\u0004'jgR\u001cVM]5bY&TXM\u001d\t\u0003\u0001\"L!![!\u00035\u0019{'oZ5oON#\u0018m[3NKJ\\G.\u001a)bi\"LeNZ8\u0002S\u0019|'oZ5oON#\u0018m[3NKJ\\G.\u001a)bi\"LeNZ8MSN$8+\u001a:jC2L'0\u001a:!\u0003]1wN]4fe\n{\u0007\u0010T5tiN+'/[1mSj,'/F\u0001n!\r\u0001UM\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003cj\t1AY8y\u0013\t\u0019\bOA\u0005G_J<WM\u001d\"pq\u0006Abm\u001c:hKJ\u0014u\u000e\u001f'jgR\u001cVM]5bY&TXM\u001d\u0011\u0002\u00179,\u0007\u0010\u001e,feNLwN\\\u0001!kB$\u0017\r^3G_J<\u0017N\\4Ti\u0006\\W-T3sW2,\u0007+\u0019;i\u0013:4w\u000eF\u0002y{z\u00042!_><\u001b\u0005Q(BA\u0019#\u0013\ta(PA\u0002UefDQAR\u0007A\u0002\u001dCaa`\u0007A\u0002\u0005\u0005\u0011\u0001\u00062pq6+'o\u001b7f!\u0006$\b.\u00138g_N+\u0017\u000fE\u0003\u0002\u0004\u0005-qM\u0004\u0003\u0002\u0006\u0005%ab\u0001'\u0002\b%\t1%\u0003\u0002UE%!\u0011QBA\b\u0005\r\u0019V-\u001d\u0006\u0003)\n\n\u0011#\u001e9eCR,gi\u001c:hKJ\u0014u\u000e_3t)\u001dA\u0018QCA\r\u0003?Aa!a\u0006\u000f\u0001\u0004y\u0014a\u0002<feNLwN\u001c\u0005\b\u00037q\u0001\u0019AA\u000f\u0003Y1wN]4fe\n{\u00070Z:U_\u0006\u0003\b/\u001a8e'\u0016\f\b#BA\u0002\u0003\u0017q\u0007bBA\u0011\u001d\u0001\u0007\u00111E\u0001\u0010E>D\u0018\nZ:SK6|g/Z*fcB1\u00111AA\u0006\u0003K\u0001R!IA\u0014\u0003WI1!!\u000b#\u0005\u0015\t%O]1z!\r\t\u0013QF\u0005\u0004\u0003_\u0011#\u0001\u0002\"zi\u0016\fabZ3u\r>\u0014x-\u001a:C_b,7/\u0006\u0002\u00026A)\u0011%a\u000e\u0002\u001e%\u0019\u0011\u0011\b\u0012\u0003\r=\u0003H/[8o\u0003\u0015:W\r\u001e$pe\u001eLgnZ*uC.,W*\u001a:lY\u0016\u0004\u0016\r\u001e5J]\u001a|gi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u0002@\u0005\u0005\u0003#B\u0011\u00028\u0005\u0005\u0001\"\u0002$\u0011\u0001\u00049\u0015!\u00047bgR4VM]:j_:LE-\u0006\u0002\u0002HA!\u0011%a\u000e@\u0003A\u0011x\u000e\u001c7cC\u000e\\g+\u001a:tS>t7\u000f\u0006\u0002\u0002NA)\u00111AA(\u007f%!\u0011\u0011KA\b\u0005\u0011a\u0015n\u001d;\u0015\t\u00055\u0013Q\u000b\u0005\u0007\u0003/\u001a\u0002\u0019\u00010\u0002'5\f\u0007PT;nE\u0016\u0014xJ\u001a,feNLwN\\:\u0002\u0011I|G\u000e\u001c2bG.$2\u0001_A/\u0011\u0019\t9\u0002\u0006a\u0001\u007f\u00059\u0011n]#naRLXCAA2!\r\t\u0013QM\u0005\u0004\u0003O\u0012#a\u0002\"p_2,\u0017M\\\u0001\u0011]Vl'-\u001a:PMZ+'o]5p]N\u0004")
public class ForgingBoxesInfoStorage
implements SidechainTypes,
SidechainStorageInfo,
ScorexLogging {
    private final Storage storage;
    private final ByteArrayWrapper forgerBoxesKey;
    private final int maxNumberOfStoredEpochs;
    private final ListSerializer<ForgingStakeMerklePathInfo> forgingStakeMerklePathInfoListSerializer;
    private final ListSerializer<ForgerBox> forgerBoxListSerializer;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper epochKey(int epoch) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(5).append("epoch").append(epoch).toString()));
    }

    public ByteArrayWrapper forgerBoxesKey() {
        return this.forgerBoxesKey;
    }

    public int maxNumberOfStoredEpochs() {
        return this.maxNumberOfStoredEpochs;
    }

    public ListSerializer<ForgingStakeMerklePathInfo> forgingStakeMerklePathInfoListSerializer() {
        return this.forgingStakeMerklePathInfoListSerializer;
    }

    public ListSerializer<ForgerBox> forgerBoxListSerializer() {
        return this.forgerBoxListSerializer;
    }

    private ByteArrayWrapper nextVersion() {
        byte[] version = new byte[32];
        Option<ByteArrayWrapper> option = this.lastVersionId();
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper lastVersion = (ByteArrayWrapper)some.value();
            new Random(lastVersion.hashCode()).nextBytes(version);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Random$.MODULE$.nextBytes(version);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return new ByteArrayWrapper(version);
    }

    public Try<ForgingBoxesInfoStorage> updateForgingStakeMerklePathInfo(int epoch, Seq<ForgingStakeMerklePathInfo> boxMerklePathInfoSeq) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(boxMerklePathInfoSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of boxMerklePathInfoSeq to append must be NOT NULL. Use empty Seq instead.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            removeList.add(this.epochKey(BoxesRunTime.unboxToInt((Object)package$ConsensusEpochNumber$.MODULE$.$at$at(BoxesRunTime.boxToInteger((int)(epoch - this.maxNumberOfStoredEpochs())), package.Tagger$.MODULE$.baseRaw()))));
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.epochKey(epoch), new ByteArrayWrapper(this.forgingStakeMerklePathInfoListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(boxMerklePathInfoSeq).asJava()))));
            $this.storage.update(this.nextVersion(), updateList, removeList);
            return this;
        });
    }

    public Try<ForgingBoxesInfoStorage> updateForgerBoxes(ByteArrayWrapper version, Seq<ForgerBox> forgerBoxesToAppendSeq, Seq<byte[]> boxIdsRemoveSeq) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            Seq currentForgerBoxSeq = (Seq)this.getForgerBoxes().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            Seq existentForgerBoxSeq = (Seq)currentForgerBoxSeq.filterNot((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)boxIdsRemoveSeq.exists((Function1 & Serializable & scala.Serializable)removedId -> BoxesRunTime.boxToBoolean((boolean)ForgingBoxesInfoStorage.$anonfun$updateForgerBoxes$4(box, removedId)))));
            Seq newForgerBoxSeq = (Seq)existentForgerBoxSeq.$plus$plus((GenTraversableOnce)forgerBoxesToAppendSeq, Seq$.MODULE$.canBuildFrom());
            Object object = existentForgerBoxSeq.size() != currentForgerBoxSeq.size() || forgerBoxesToAppendSeq.nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerBoxesKey(), new ByteArrayWrapper(this.forgerBoxListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(newForgerBoxSeq).asJava()))))) : BoxedUnit.UNIT;
            $this.storage.update(version, toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<Seq<ForgerBox>> getForgerBoxes() {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgerBoxesKey())));
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = this.forgerBoxListSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List forgerBoxes = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(forgerBoxes).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while forger boxes list parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Seq<ForgingStakeMerklePathInfo>> getForgingStakeMerklePathInfoForEpoch(int epoch) {
        None$ none$;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.epochKey(epoch))));
        if (option instanceof Some) {
            Some some;
            Some some2 = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = this.forgingStakeMerklePathInfoListSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                java.util.List boxMerklePathsInfo = (java.util.List)success.value();
                some = new Some(JavaConverters$.MODULE$.asScalaBufferConverter(boxMerklePathsInfo).asScala());
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while box merkle paths info parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<ForgingBoxesInfoStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public int numberOfVersions() {
        return this.storage.numberOfVersions();
    }

    public static final /* synthetic */ boolean $anonfun$updateForgerBoxes$4(ForgerBox box$1, byte[] removedId) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(box$1.id())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(removedId));
    }

    public ForgingBoxesInfoStorage(Storage storage) {
        this.storage = storage;
        SidechainTypes.$init$(this);
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.forgerBoxesKey = new ByteArrayWrapper(Blake2b256$.MODULE$.hash("forgerBoxesKey".getBytes()));
        this.maxNumberOfStoredEpochs = 3;
        this.forgingStakeMerklePathInfoListSerializer = new ListSerializer<ForgingStakeMerklePathInfo>(ForgerBoxMerklePathInfoSerializer$.MODULE$);
        this.forgerBoxListSerializer = new ListSerializer<ForgerBox>(ForgerBoxSerializer.getSerializer());
    }
}

