/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.secret;

import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.proof.SchnorrProof;
import com.horizen.proposition.ProofOfKnowledgeProposition;
import com.horizen.proposition.SchnorrProposition;
import com.horizen.secret.SchnorrSecretSerializer;
import com.horizen.secret.Secret;
import com.horizen.secret.SecretSerializer;
import com.horizen.secret.SecretsIdsEnum;
import java.util.Arrays;
import java.util.Objects;

public class SchnorrSecret
implements Secret {
    public static final int SECRET_KEY_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrSecretKeyLength();
    public static final int PUBLIC_KEY_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrPublicKeyLength();
    final byte[] secretBytes;
    final byte[] publicBytes;

    public SchnorrSecret(byte[] secretKey, byte[] publicKey) {
        Objects.requireNonNull(secretKey, "Secret key can't be null");
        Objects.requireNonNull(publicKey, "Public key can't be null");
        this.secretBytes = Arrays.copyOf(secretKey, secretKey.length);
        this.publicBytes = Arrays.copyOf(publicKey, publicKey.length);
    }

    private byte[] getSecretBytes() {
        return Arrays.copyOf(this.secretBytes, this.secretBytes.length);
    }

    public byte[] getPublicBytes() {
        return this.publicBytes;
    }

    @Override
    public byte secretTypeId() {
        return SecretsIdsEnum.SchnorrSecretKeyId.id();
    }

    @Override
    public SchnorrProposition publicImage() {
        byte[] publicKey = Arrays.copyOf(this.publicBytes, this.publicBytes.length);
        return new SchnorrProposition(publicKey);
    }

    @Override
    public SecretSerializer serializer() {
        return SchnorrSecretSerializer.getSerializer();
    }

    @Override
    public boolean owns(ProofOfKnowledgeProposition proposition) {
        return Arrays.equals(this.publicBytes, proposition.pubKeyBytes());
    }

    @Override
    public SchnorrProof sign(byte[] message) {
        return new SchnorrProof(CryptoLibProvider.schnorrFunctions().sign(this.getSecretBytes(), this.getPublicBytes(), message));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrSecret that = (SchnorrSecret)o;
        return Arrays.equals(this.secretBytes, that.secretBytes) && Arrays.equals(this.publicBytes, that.publicBytes);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.secretBytes);
        result = 31 * result + Arrays.hashCode(this.publicBytes);
        return result;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }
}

