/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proposition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.proof.SchnorrProof;
import com.horizen.proposition.AbstractSingleSecretProofOfKnowledgeProposition;
import com.horizen.proposition.PropositionSerializer;
import com.horizen.proposition.SchnorrPropositionSerializer;
import com.horizen.secret.SchnorrSecret;
import com.horizen.serialization.Views;
import java.util.Arrays;
import java.util.Objects;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"valid"})
public class SchnorrProposition
extends AbstractSingleSecretProofOfKnowledgeProposition<SchnorrSecret> {
    public static final int KEY_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrPublicKeyLength();
    private final byte[] publicBytes;

    public SchnorrProposition(byte[] publicKey) {
        Objects.requireNonNull(publicKey, "Public key can't be null");
        this.publicBytes = Arrays.copyOf(publicKey, publicKey.length);
    }

    public boolean verify(byte[] message, SchnorrProof signature) {
        return CryptoLibProvider.schnorrFunctions().verify(message, this.pubKeyBytes(), signature.bytes());
    }

    @Override
    @JsonProperty(value="publicKey")
    public byte[] pubKeyBytes() {
        return Arrays.copyOf(this.publicBytes, this.publicBytes.length);
    }

    @Override
    public PropositionSerializer serializer() {
        return SchnorrPropositionSerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrProposition that = (SchnorrProposition)o;
        return Arrays.equals(this.publicBytes, that.publicBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.publicBytes);
    }

    public String toString() {
        return "SchnorrPublicKey{publicBytes=" + Arrays.toString(this.publicBytes) + "}";
    }
}

