/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.cryptolibprovider.FieldElementUtils;
import com.horizen.cryptolibprovider.VrfFunctions;
import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.vrfnative.VRFKeyPair;
import com.horizen.vrfnative.VRFProof;
import com.horizen.vrfnative.VRFProveResult;
import com.horizen.vrfnative.VRFPublicKey;
import com.horizen.vrfnative.VRFSecretKey;
import java.util.EnumMap;
import java.util.Optional;

public class VrfFunctionsImplZendoo
implements VrfFunctions {
    @Override
    public EnumMap<VrfFunctions.KeyType, byte[]> generatePublicAndSecretKeys(byte[] seed) {
        VRFKeyPair generated = VRFKeyPair.generate();
        VRFSecretKey secretKey = generated.getSecretKey();
        VRFPublicKey publicKey = generated.getPublicKey();
        EnumMap<VrfFunctions.KeyType, byte[]> keysMap = new EnumMap<VrfFunctions.KeyType, byte[]>(VrfFunctions.KeyType.class);
        keysMap.put(VrfFunctions.KeyType.SECRET, secretKey.serializeSecretKey());
        keysMap.put(VrfFunctions.KeyType.PUBLIC, publicKey.serializePublicKey());
        secretKey.freeSecretKey();
        publicKey.freePublicKey();
        return keysMap;
    }

    @Override
    public EnumMap<VrfFunctions.ProofType, byte[]> createProof(byte[] secretKeyBytes, byte[] publicKeyBytes, byte[] message) {
        VRFSecretKey secretKey = VRFSecretKey.deserialize((byte[])secretKeyBytes);
        VRFPublicKey publicKey = VRFPublicKey.deserialize((byte[])publicKeyBytes);
        VRFKeyPair keyPair = new VRFKeyPair(secretKey, publicKey);
        FieldElement fieldElement = FieldElementUtils.messageToFieldElement(message);
        VRFProveResult vrfProofAndVrfOutput = keyPair.prove(fieldElement);
        byte[] vrfProofBytes = vrfProofAndVrfOutput.getVRFProof().serializeProof();
        byte[] vrfOutputBytes = vrfProofAndVrfOutput.getVRFOutput().serializeFieldElement();
        EnumMap<VrfFunctions.ProofType, byte[]> proofsMap = new EnumMap<VrfFunctions.ProofType, byte[]>(VrfFunctions.ProofType.class);
        proofsMap.put(VrfFunctions.ProofType.VRF_PROOF, vrfProofBytes);
        proofsMap.put(VrfFunctions.ProofType.VRF_OUTPUT, vrfOutputBytes);
        secretKey.freeSecretKey();
        publicKey.freePublicKey();
        vrfProofAndVrfOutput.getVRFProof().freeProof();
        vrfProofAndVrfOutput.getVRFOutput().freeFieldElement();
        fieldElement.freeFieldElement();
        return proofsMap;
    }

    @Override
    public boolean verifyProof(byte[] message, byte[] publicKeyBytes, byte[] proofBytes) {
        return this.proofToOutput(publicKeyBytes, message, proofBytes).isPresent();
    }

    @Override
    public boolean publicKeyIsValid(byte[] publicKeyBytes) {
        VRFPublicKey publicKey = VRFPublicKey.deserialize((byte[])publicKeyBytes);
        boolean keyIsValid = publicKey.verifyKey();
        publicKey.freePublicKey();
        return keyIsValid;
    }

    @Override
    public Optional<byte[]> proofToOutput(byte[] publicKeyBytes, byte[] message, byte[] proofBytes) {
        Optional<byte[]> output;
        VRFPublicKey publicKey = VRFPublicKey.deserialize((byte[])publicKeyBytes);
        VRFProof vrfProof = VRFProof.deserialize((byte[])proofBytes);
        FieldElement messageAsFieldElement = FieldElementUtils.messageToFieldElement(message);
        if (publicKey == null || vrfProof == null || messageAsFieldElement == null) {
            if (publicKey != null) {
                publicKey.freePublicKey();
            }
            if (vrfProof != null) {
                vrfProof.freeProof();
            }
            if (messageAsFieldElement != null) {
                messageAsFieldElement.freeFieldElement();
            }
            return Optional.empty();
        }
        FieldElement vrfOutput = publicKey.proofToHash(vrfProof, messageAsFieldElement);
        if (vrfOutput != null) {
            output = Optional.of(vrfOutput.serializeFieldElement());
            vrfOutput.freeFieldElement();
        } else {
            output = Optional.empty();
        }
        publicKey.freePublicKey();
        vrfProof.freeProof();
        messageAsFieldElement.freeFieldElement();
        return output;
    }

    @Override
    public int vrfSecretKeyLength() {
        return Constants.VRF_SK_LENGTH();
    }

    @Override
    public int vrfPublicKeyLen() {
        return Constants.VRF_PK_LENGTH();
    }

    @Override
    public int vrfProofLen() {
        return Constants.VRF_PROOF_LENGTH();
    }

    @Override
    public int vrfOutputLen() {
        return Constants.FIELD_ELEMENT_LENGTH();
    }
}

