/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.librustsidechains.Constants;
import com.horizen.librustsidechains.FieldElement;
import com.horizen.utils.BytesUtils;
import java.util.Arrays;

public class FieldElementUtils {
    public static int fieldElementLength() {
        return Constants.FIELD_ELEMENT_LENGTH();
    }

    static FieldElement messageToFieldElement(byte[] message) {
        if (message.length > FieldElementUtils.fieldElementLength()) {
            throw new IllegalArgumentException("Message length is exceed allowed message len. Message len " + message.length + " but it shall be less than " + FieldElementUtils.fieldElementLength());
        }
        return FieldElement.deserialize((byte[])Arrays.copyOf(message, FieldElementUtils.fieldElementLength()));
    }

    public static FieldElement hashToFieldElement(String hexByte) {
        byte[] hashBytes = BytesUtils.fromHexString(hexByte);
        if (hashBytes.length > FieldElementUtils.fieldElementLength()) {
            throw new IllegalArgumentException("Hash length is exceed Poseidon hash len. Hash len " + hashBytes.length + " but it shall be " + FieldElementUtils.fieldElementLength());
        }
        return FieldElement.deserialize((byte[])Arrays.copyOf(hashBytes, FieldElementUtils.fieldElementLength()));
    }

    public static byte[] randomFieldElementBytes() {
        FieldElement fe = FieldElement.createRandom();
        byte[] feBytes = fe.serializeFieldElement();
        fe.freeFieldElement();
        return feBytes;
    }

    public static byte[] randomFieldElementBytes(long seed) {
        FieldElement fe = FieldElement.createRandom((long)seed);
        byte[] feBytes = fe.serializeFieldElement();
        fe.freeFieldElement();
        return feBytes;
    }
}

