/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.block;

import com.google.common.primitives.Ints;
import com.horizen.utils.BytesUtils;
import java.math.BigInteger;
import org.bouncycastle.crypto.digests.Blake2bDigest;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Equihash$ {
    public static Equihash$ MODULE$;

    static {
        new Equihash$();
    }

    public int[] getIndicesFromMinimal(byte[] minimal, int collisionBitLength) {
        Predef$.MODULE$.assert((collisionBitLength + 1 + 7) / 8 <= 4);
        int lenIndices = 32 * minimal.length / (collisionBitLength + 1);
        int bytePad = 4 - (collisionBitLength + 1 + 7) / 8;
        byte[] arr = this.expandArray(minimal, lenIndices, collisionBitLength + 1, bytePad);
        ArrayBuffer res = new ArrayBuffer(lenIndices / 4);
        for (int i = 0; i < lenIndices; i += 4) {
            res.append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BytesUtils.getInt(arr, i)}));
        }
        return (int[])res.toArray(ClassTag$.MODULE$.Int());
    }

    public byte[] getMinimalFromIndices(int[] indices, int colissionBitLength) {
        Predef$.MODULE$.assert((colissionBitLength + 1 + 7) / 8 <= 4);
        int lenIndices = indices.length * 4;
        int minLen = (colissionBitLength + 1) * lenIndices / 32;
        int bytePad = 4 - (colissionBitLength + 1 + 7) / 8;
        ObjectRef array = ObjectRef.create((Object)new byte[lenIndices]);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).indices().withFilter((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)check$ifrefutable$2 -> {
            int n = check$ifrefutable$2;
            boolean bl = true;
            return bl;
        }).foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> Array$.MODULE$.copy((Object)Ints.toByteArray((int)indices[i]), 0, (Object)((byte[])array$1.elem), i * 4, 4));
        return this.compressArray((byte[])array.elem, minLen, colissionBitLength + 1, bytePad);
    }

    public byte[] expandArray(byte[] in, int outLen, int bitLen, int bytePad) {
        Predef$.MODULE$.assert(bitLen >= 8);
        Predef$.MODULE$.assert(32 >= 7 + bitLen);
        BigInteger wordMask = BigInteger.ONE.shiftLeft(32).subtract(BigInteger.ONE);
        int outWidth = (bitLen + 7) / 8 + bytePad;
        Predef$.MODULE$.assert(outLen == 8 * outWidth * in.length / bitLen);
        byte[] out = new byte[outLen];
        BigInteger bitLenMask = BigInteger.valueOf((1 << bitLen) - 1);
        IntRef accBits = IntRef.create((int)0);
        ObjectRef accValue = ObjectRef.create((Object)BigInteger.ZERO);
        IntRef j = IntRef.create((int)0);
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(in)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            block0: {
                accValue$1.elem = ((BigInteger)accValue$1.elem).shiftLeft(8).and(wordMask).or(BigInteger.valueOf(in[i] & 0xFF));
                accBits$1.elem += 8;
                if (accBits$1.elem < bitLen) break block0;
                accBits$1.elem -= bitLen;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(bytePad), outWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)x -> {
                    BigInteger left = ((BigInteger)accValue$1.elem).shiftRight(accBits$1.elem + 8 * (outWidth - x - 1));
                    BigInteger right = bitLenMask.shiftRight(8 * (outWidth - x - 1)).and(BigInteger.valueOf(255L));
                    out$1[j$1.elem + x] = left.and(right).byteValue();
                });
                j$1.elem += outWidth;
            }
        });
        return out;
    }

    public int expandArray$default$4() {
        return 0;
    }

    public byte[] compressArray(byte[] in, int outLen, int bitLen, int bytePad) {
        Predef$.MODULE$.assert(bitLen >= 8);
        Predef$.MODULE$.assert(32 >= 7 + bitLen);
        BigInteger wordMask = BigInteger.ONE.shiftLeft(32).subtract(BigInteger.ONE);
        int inWidth = (bitLen + 7) / 8 + bytePad;
        Predef$.MODULE$.assert(outLen == bitLen * in.length / (8 * inWidth));
        byte[] out = new byte[outLen];
        BigInteger bitLenMask = BigInteger.valueOf((1 << bitLen) - 1);
        IntRef accBits = IntRef.create((int)0);
        ObjectRef accValue = ObjectRef.create((Object)BigInteger.ZERO);
        IntRef j = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outLen).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            if (accBits$2.elem < 8) {
                accValue$2.elem = ((BigInteger)accValue$2.elem).shiftLeft(bitLen).and(wordMask);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(bytePad), inWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)x -> {
                    BigInteger b = BigInteger.valueOf(in[j$2.elem + x]).and(bitLenMask.shiftRight(8 * (inWidth - x - 1)).and(BigInteger.valueOf(255L))).shiftLeft(8 * (inWidth - x - 1));
                    accValue$2.elem = ((BigInteger)accValue$2.elem).or(b);
                });
                j$2.elem += inWidth;
                accBits$2.elem += bitLen;
            }
            accBits$2.elem -= 8;
            out$2[i] = ((BigInteger)accValue$2.elem).shiftRight(accBits$2.elem).and(BigInteger.valueOf(255L)).byteValue();
        });
        return out;
    }

    public int compressArray$default$4() {
        return 0;
    }

    public byte[] com$horizen$block$Equihash$$generateHash(Blake2bDigest baseDigest, int index, int hashOutputLength) {
        if (baseDigest.getDigestSize() != hashOutputLength) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Blake2bDigest instance has wrong dagest size(%d), expected (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)baseDigest.getDigestSize()), BoxesRunTime.boxToInteger((int)hashOutputLength)})));
        }
        Blake2bDigest digest = new Blake2bDigest(baseDigest);
        digest.update(BytesUtils.reverseBytes(Ints.toByteArray((int)index)), 0, 4);
        byte[] hash = new byte[hashOutputLength];
        digest.doFinal(hash, 0);
        return hash;
    }

    private Equihash$() {
        MODULE$ = this;
    }
}

