/*
 * Decompiled with CFR 0.152.
 */
package com.horizen;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.horizen.backup.BoxIterator;
import com.horizen.box.Box;
import com.horizen.box.BoxSerializer;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.storage.BackupStorage;
import com.horizen.storage.BoxBackupInterface;
import com.horizen.storage.SidechainStateStorage;
import com.horizen.storage.Storage;
import com.horizen.storage.StorageIterator;
import com.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.BytesUtils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0007\u000f\u0001MA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005I!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003D\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bA\u0003A\u0011A)\t\u000fA\u0004!\u0019!C\tc\"1\u0001\u0010\u0001Q\u0001\nIDq!\u001f\u0001C\u0002\u0013E!\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\u0003\u001fMKG-Z2iC&t')Y2lkBT!a\u0004\t\u0002\u000f!|'/\u001b>f]*\t\u0011#A\u0002d_6\u001c\u0001aE\u0002\u0001)i\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011)H/\u001b7\u000b\u0003}\taa]2pe\u0016D\u0018BA\u0011\u001d\u00055\u00196m\u001c:fq2{wmZ5oO\u0006!2-^:u_6\u0014u\u000e_*fe&\fG.\u001b>feN,\u0012\u0001\n\t\u0005K%Z\u0013'D\u0001'\u0015\tirEC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)2#a\u0002%bg\"l\u0015\r\u001d\t\u0003Y=j\u0011!\f\u0006\u0003]\u001d\nA\u0001\\1oO&\u0011\u0001'\f\u0002\u0005\u0005f$X\rE\u00023k]j\u0011a\r\u0006\u0003i9\t1AY8y\u0013\t14GA\u0007C_b\u001cVM]5bY&TXM\u001d\t\u0004eaR\u0014BA\u001d4\u0005\r\u0011u\u000e\u001f\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{9\t1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&\u0011q\b\u0010\u0002\f!J|\u0007o\\:ji&|g.A\u000bdkN$x.\u001c\"pqN+'/[1mSj,'o\u001d\u0011\u0002\u001b\t\f7m[+q'R|'/Y4f+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$\u000f\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001S#\u0003\u000fM#xN]1hK\u0006q!-Y2l+B\u001cFo\u001c:bO\u0016\u0004\u0013!\u00032bG.,\u0006\u000f]3s+\u0005a\u0005C\u0001#N\u0013\tqUI\u0001\nC_b\u0014\u0015mY6va&sG/\u001a:gC\u000e,\u0017A\u00032bG.,\u0006\u000f]3sA\u00051A(\u001b8jiz\"BA\u0015+dOB\u00111\u000bA\u0007\u0002\u001d!)!e\u0002a\u0001I!\"AK\u00161b!\t9f,D\u0001Y\u0015\tI&,\u0001\u0003oC6,'BA.]\u0003\u0019IgN[3di*\u0011Q\fE\u0001\u0007O>|w\r\\3\n\u0005}C&!\u0002(b[\u0016$\u0017!\u0002<bYV,\u0017%\u00012\u0002)\r+8\u000f^8n\u0005>D8+\u001a:jC2L'0\u001a:t\u0011\u0015\tu\u00011\u0001DQ\u0011\u0019g\u000bY3\"\u0003\u0019\fQBQ1dWV\u00048\u000b^8sC\u001e,\u0007\"\u0002&\b\u0001\u0004a\u0005\u0006B4WA&\f\u0013A[\u0001\n\u0005\u0006\u001c7.\u00169qKJD#a\u00027\u0011\u00055tW\"\u0001.\n\u0005=T&AB%oU\u0016\u001cG/A\ftS\u0012,7\r[1j]\n{\u00070Z:D_6\u0004\u0018M\\5p]V\t!\u000f\u0005\u0002tm6\tAO\u0003\u0002v\u001d\u0005I1m\\7qC:LwN\\\u0005\u0003oR\u0014qcU5eK\u000eD\u0017-\u001b8C_b,7oQ8na\u0006t\u0017n\u001c8\u00021MLG-Z2iC&t'i\u001c=fg\u000e{W\u000e]1oS>t\u0007%A\u0007cC\u000e\\W\u000f]*u_J\fw-Z\u000b\u0002wB\u0011A\t`\u0005\u0003{\u0016\u0013QBQ1dWV\u00048\u000b^8sC\u001e,\u0017A\u00042bG.,\bo\u0015;pe\u0006<W\rI\u0001\rGJ,\u0017\r^3CC\u000e\\W\u000f\u001d\u000b\t\u0003\u0007\tI!a\t\u0002(A\u0019Q#!\u0002\n\u0007\u0005\u001daC\u0001\u0003V]&$\bbBA\u0006\u0019\u0001\u0007\u0011QB\u0001\u0011gR\fG/Z*u_J\fw-\u001a)bi\"\u0004B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019BF\u0007\u0003\u0003+Q1!a\u0006\u0013\u0003\u0019a$o\\8u}%\u0019\u00111\u0004\f\u0002\rA\u0013X\rZ3g\u0013\u0011\ty\"!\t\u0003\rM#(/\u001b8h\u0015\r\tYB\u0006\u0005\b\u0003Ka\u0001\u0019AA\u0007\u0003i\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.LE\rV8S_2d'-Y2l\u0011\u001d\tI\u0003\u0004a\u0001\u0003W\t\u0001cY8qsN#\u0018\r^3Ti>\u0014\u0018mZ3\u0011\u0007U\ti#C\u0002\u00020Y\u0011qAQ8pY\u0016\fg\u000e")
public class SidechainBackup
implements ScorexLogging {
    private final HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers;
    private final Storage backUpStorage;
    private final BoxBackupInterface backUpper;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final BackupStorage backupStorage;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers() {
        return this.customBoxSerializers;
    }

    public Storage backUpStorage() {
        return this.backUpStorage;
    }

    public BoxBackupInterface backUpper() {
        return this.backUpper;
    }

    public SidechainBoxesCompanion sidechainBoxesCompanion() {
        return this.sidechainBoxesCompanion;
    }

    public BackupStorage backupStorage() {
        return this.backupStorage;
    }

    public void createBackup(String stateStoragePath, String sidechainBlockIdToRollback, boolean copyStateStorage) {
        VersionedLevelDbStorageAdapter storage;
        SidechainStateStorage sidechainStateStorage;
        Try<SidechainStateStorage> try_;
        String storagePath = stateStoragePath;
        if (copyStateStorage) {
            File stateStorage = new File(stateStoragePath);
            File stateStorageBackup = new File(new StringBuilder(16).append(stateStoragePath).append("_copy_for_backup").toString());
            try {
                FileUtils.copyDirectory((File)stateStorage, (File)stateStorageBackup);
                storagePath = new StringBuilder(16).append(stateStoragePath).append("_copy_for_backup").toString();
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error during the copy of the StateStorage: ", new Object[]{t.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(43).append("Error during the copy of the StateStorage: ").append(t.getMessage()).toString());
            }
        }
        if ((try_ = (sidechainStateStorage = new SidechainStateStorage(storage = new VersionedLevelDbStorageAdapter(new File(storagePath)), this.sidechainBoxesCompanion())).rollback(new ByteArrayWrapper(BytesUtils.fromHexString(sidechainBlockIdToRollback)))) instanceof Success) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Success success = (Success)try_;
            SidechainStateStorage stateStorage = (SidechainStateStorage)success.value();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Rollback of the SidechainStateStorage completed successfully!");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            StorageIterator stateIterator = stateStorage.getIterator();
            stateIterator.seekToFirst();
            try {
                this.backUpper().backup(new BoxIterator(stateIterator, this.sidechainBoxesCompanion()), this.backupStorage());
                storage.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit3;
                storage.close();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error during the Backup generation: ", new Object[]{t.getMessage()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(36).append("Error during the Backup generation: ").append(t.getMessage()).toString());
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Rollback of the SidechainStateStorage couldn't end successfully...", new Object[]{e.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }

    @Inject
    public SidechainBackup(@Named(value="CustomBoxSerializers") HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers, @Named(value="BackupStorage") Storage backUpStorage, @Named(value="BackUpper") BoxBackupInterface backUpper) {
        this.customBoxSerializers = customBoxSerializers;
        this.backUpStorage = backUpStorage;
        this.backUpper = backUpper;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.sidechainBoxesCompanion = new SidechainBoxesCompanion(customBoxSerializers);
        this.backupStorage = new BackupStorage(backUpStorage, this.sidechainBoxesCompanion());
    }
}

