/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proposition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.proof.VrfProof;
import com.horizen.proposition.ProofOfKnowledgeProposition;
import com.horizen.proposition.PropositionSerializer;
import com.horizen.proposition.VrfPublicKeySerializer;
import com.horizen.secret.VrfSecretKey;
import com.horizen.serialization.Views;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"valid"})
public class VrfPublicKey
implements ProofOfKnowledgeProposition<VrfSecretKey> {
    public static final int KEY_LENGTH = CryptoLibProvider.vrfFunctions().vrfPublicKeyLen();
    private final byte[] publicBytes;

    public VrfPublicKey(byte[] publicKey) {
        Objects.requireNonNull(publicKey, "Public key can't be null");
        this.publicBytes = Arrays.copyOf(publicKey, publicKey.length);
    }

    public boolean verify(byte[] message, VrfProof proof) {
        return CryptoLibProvider.vrfFunctions().verifyProof(message, this.pubKeyBytes(), proof.bytes());
    }

    public boolean isValid() {
        return CryptoLibProvider.vrfFunctions().publicKeyIsValid(this.pubKeyBytes());
    }

    @Override
    @JsonProperty(value="publicKey")
    public byte[] pubKeyBytes() {
        return Arrays.copyOf(this.publicBytes, this.publicBytes.length);
    }

    @Override
    public PropositionSerializer serializer() {
        return VrfPublicKeySerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VrfPublicKey that = (VrfPublicKey)o;
        return Arrays.equals(this.publicBytes, that.publicBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.publicBytes);
    }

    public String toString() {
        return "VrfPublicKey{publicBytes=" + ByteUtils.toHexString((byte[])this.publicBytes) + "}";
    }
}

