/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.proposition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.primitives.Bytes;
import com.horizen.ScorexEncoding;
import com.horizen.proposition.ProofOfKnowledgeProposition;
import com.horizen.proposition.PropositionSerializer;
import com.horizen.proposition.PublicKey25519PropositionSerializer;
import com.horizen.secret.PrivateKey25519;
import com.horizen.serialization.Views;
import com.horizen.utils.Ed25519;
import java.util.Arrays;
import scala.util.Try;
import scorex.crypto.hash.Blake2b256;

@JsonView(value={Views.Default.class})
public final class PublicKey25519Proposition
extends ScorexEncoding
implements ProofOfKnowledgeProposition<PrivateKey25519> {
    public static final byte ADDRESS_VERSION = 1;
    public static final int CHECKSUM_LENGTH = 4;
    public static final int KEY_LENGTH = Ed25519.publicKeyLength();
    public static final int ADDRESS_LENGTH = 1 + KEY_LENGTH + 4;
    @JsonProperty(value="publicKey")
    private byte[] _pubKeyBytes;

    public PublicKey25519Proposition(byte[] pubKeyBytes) {
        if (pubKeyBytes.length != KEY_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect pubKey length, %d expected, %d found", KEY_LENGTH, pubKeyBytes.length));
        }
        this._pubKeyBytes = Arrays.copyOf(pubKeyBytes, KEY_LENGTH);
    }

    @Override
    public byte[] pubKeyBytes() {
        return Arrays.copyOf(this._pubKeyBytes, KEY_LENGTH);
    }

    @Override
    public PropositionSerializer serializer() {
        return PublicKey25519PropositionSerializer.getSerializer();
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubKeyBytes());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKey25519Proposition)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Arrays.equals(this.pubKeyBytes(), ((PublicKey25519Proposition)obj).pubKeyBytes());
    }

    private byte[] pubKeyBytesWithVersion() {
        return Bytes.concat((byte[][])new byte[][]{{1}, this.pubKeyBytes()});
    }

    public static byte[] calcCheckSum(byte[] bytes) {
        return Arrays.copyOf(Blake2b256.hash((byte[])bytes), 4);
    }

    public String address() {
        return PublicKey25519Proposition.encoder().encode(Bytes.concat((byte[][])new byte[][]{this.pubKeyBytesWithVersion(), PublicKey25519Proposition.calcCheckSum(this.pubKeyBytesWithVersion())}));
    }

    public String toString() {
        return this.address();
    }

    public boolean verify(byte[] message, byte[] signature) {
        return Ed25519.verify(signature, message, this.pubKeyBytes());
    }

    public static PublicKey25519Proposition parseAddress(String address) {
        byte[] checkSumGenerated;
        Try res = PublicKey25519Proposition.encoder().decode(address);
        if (res.isFailure()) {
            throw new IllegalArgumentException("Wrong address encoding");
        }
        byte[] addressBytes = (byte[])res.get();
        if (addressBytes.length != ADDRESS_LENGTH) {
            throw new IllegalArgumentException("Wrong address length");
        }
        byte[] bytesWithVersion = Arrays.copyOf(addressBytes, addressBytes.length - 4);
        byte[] checksum = Arrays.copyOfRange(addressBytes, addressBytes.length - 4, addressBytes.length);
        if (!Arrays.equals(checksum, checkSumGenerated = PublicKey25519Proposition.calcCheckSum(bytesWithVersion))) {
            throw new IllegalArgumentException("Wrong checksum");
        }
        return new PublicKey25519Proposition(Arrays.copyOfRange(bytesWithVersion, 1, bytesWithVersion.length));
    }

    public static int getLength() {
        return KEY_LENGTH;
    }
}

