/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.box;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.ScorexEncoding;
import com.horizen.box.Box;
import com.horizen.box.CoinsBox;
import com.horizen.box.data.AbstractBoxData;
import com.horizen.proposition.Proposition;
import java.util.Arrays;
import java.util.Objects;
import scorex.crypto.hash.Blake2b256;

public abstract class AbstractBox<P extends Proposition, BD extends AbstractBoxData<P, B, BD>, B extends AbstractBox<P, BD, B>>
extends ScorexEncoding
implements Box<P> {
    protected final BD boxData;
    protected final long nonce;
    private byte[] id;
    private Integer hashcode;
    private static final byte[] coinsBoxFlag = new byte[]{1};
    private static final byte[] nonCoinsBoxFlag = new byte[]{0};

    public AbstractBox(BD boxData, long nonce) {
        Objects.requireNonNull(boxData, "boxData must be defined");
        this.boxData = boxData;
        this.nonce = nonce;
    }

    @Override
    public final long value() {
        return ((AbstractBoxData)this.boxData).value();
    }

    @Override
    public final P proposition() {
        return ((AbstractBoxData)this.boxData).proposition();
    }

    @Override
    public final long nonce() {
        return this.nonce;
    }

    @Override
    public final byte[] customFieldsHash() {
        return ((AbstractBoxData)this.boxData).customFieldsHash();
    }

    @Override
    public final byte[] id() {
        if (this.id == null) {
            this.id = Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this instanceof CoinsBox ? coinsBoxFlag : nonCoinsBoxFlag, Longs.toByteArray((long)this.value()), this.proposition().bytes(), Longs.toByteArray((long)this.nonce()), this.customFieldsHash()}));
        }
        return this.id;
    }

    public int hashCode() {
        if (this.hashcode == null) {
            this.hashcode = Objects.hash(this.boxData, this.nonce);
        }
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return Arrays.equals(this.id(), ((AbstractBox)obj).id());
    }

    public String toString() {
        return String.format("%s(id: %s, proposition: %s, value: %d, nonce: %d)", this.getClass().toString(), AbstractBox.encoder().encode(this.id()), this.proposition(), this.value(), this.nonce());
    }

    @Override
    public String typeName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Boolean isCustom() {
        return true;
    }
}

