/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.client;

import com.horizen.WebSocketSettings;
import com.horizen.websocket.client.DisconnectionCode$;
import com.horizen.websocket.client.WebSocketReconnectionHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import scala.Enumeration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001I4AAC\u0006\u0001)!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u00041\u0001\u0001\u0007I\u0011A\u0019\t\u000fU\u0002\u0001\u0019!C\u0001m!1A\b\u0001Q!\nIBQ!\u0010\u0001\u0005ByBQ\u0001\u0015\u0001\u0005BECQA\u001a\u0001\u0005B\u001dDQ\u0001\u001d\u0001\u0005BE\u00141\u0005R3gCVdGoV3c'>\u001c7.\u001a;SK\u000e|gN\\3di&|g\u000eS1oI2,'O\u0003\u0002\r\u001b\u000511\r\\5f]RT!AD\b\u0002\u0013],'m]8dW\u0016$(B\u0001\t\u0012\u0003\u001dAwN]5{K:T\u0011AE\u0001\u0004G>l7\u0001A\n\u0005\u0001UYr\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011aC\u0005\u0003=-\u0011AdV3c'>\u001c7.\u001a;SK\u000e|gN\\3di&|g\u000eS1oI2,'\u000f\u0005\u0002!K5\t\u0011E\u0003\u0002#G\u0005!Q\u000f^5m\u0015\u0005!\u0013AB:d_J,\u00070\u0003\u0002'C\ti1kY8sKbdunZ4j]\u001e\fAaY8oMB\u0011\u0011FK\u0007\u0002\u001f%\u00111f\u0004\u0002\u0012/\u0016\u00147k\\2lKR\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0011A\u0004\u0001\u0005\u0006O\t\u0001\r\u0001K\u0001\u0018_:\u001cuN\u001c8fGR4\u0015-\u001b7ve\u0016\u001cu.\u001e8uKJ,\u0012A\r\t\u0003-MJ!\u0001N\f\u0003\u0007%sG/A\u000ep]\u000e{gN\\3di\u001a\u000b\u0017\u000e\\;sK\u000e{WO\u001c;fe~#S-\u001d\u000b\u0003oi\u0002\"A\u0006\u001d\n\u0005e:\"\u0001B+oSRDqa\u000f\u0003\u0002\u0002\u0003\u0007!'A\u0002yIE\n\u0001d\u001c8D_:tWm\u0019;GC&dWO]3D_VtG/\u001a:!\u0003IygnQ8o]\u0016\u001cG/[8o\r\u0006LG.\u001a3\u0015\u0005}\u0012\u0005C\u0001\fA\u0013\t\tuCA\u0004C_>dW-\u00198\t\u000b\r3\u0001\u0019\u0001#\u0002\u000b\r\fWo]3\u0011\u0005\u0015keB\u0001$L\u001d\t9%*D\u0001I\u0015\tI5#\u0001\u0004=e>|GOP\u0005\u00021%\u0011AjF\u0001\ba\u0006\u001c7.Y4f\u0013\tquJA\u0005UQJ|w/\u00192mK*\u0011AjF\u0001\u0010_:$\u0015n]2p]:,7\r^5p]R\u0019qH\u0015/\t\u000bM;\u0001\u0019\u0001+\u0002\t\r|G-\u001a\t\u0003+bs!\u0001\b,\n\u0005][\u0011!\u0005#jg\u000e|gN\\3di&|gnQ8eK&\u0011\u0011L\u0017\u0002\u0006-\u0006dW/Z\u0005\u00037^\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\")Ql\u0002a\u0001=\u00061!/Z1t_:\u0004\"aX2\u000f\u0005\u0001\f\u0007CA$\u0018\u0013\t\u0011w#\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u0014aa\u0015;sS:<'B\u00012\u0018\u0003!9W\r\u001e#fY\u0006LX#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00055<\u0012AC2p]\u000e,(O]3oi&\u0011qN\u001b\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003MygnQ8o]\u0016\u001cG/[8o'V\u001c7-Z:t)\u00059\u0004")
public class DefaultWebSocketReconnectionHandler
implements WebSocketReconnectionHandler,
ScorexLogging {
    private final WebSocketSettings conf;
    private int onConnectFailureCounter;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int onConnectFailureCounter() {
        return this.onConnectFailureCounter;
    }

    public void onConnectFailureCounter_$eq(int x$1) {
        this.onConnectFailureCounter = x$1;
    }

    @Override
    public boolean onConnectionFailed(Throwable cause) {
        boolean bl;
        this.onConnectFailureCounter_$eq(this.onConnectFailureCounter() + 1);
        if (this.onConnectFailureCounter() <= this.conf.reconnectionMaxAttempts()) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder(45).append("onConnectFailure. Reconnecting... (attempt ").append(this.onConnectFailureCounter()).append(") ").append(cause.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onDisconnection(Enumeration.Value code, String reason) {
        BoxedUnit boxedUnit;
        this.onConnectFailureCounter_$eq(this.onConnectFailureCounter() + 1);
        if (this.onConnectFailureCounter() > this.conf.reconnectionMaxAttempts()) return false;
        Enumeration.Value value = code;
        Enumeration.Value value2 = DisconnectionCode$.MODULE$.ON_SUCCESS();
        if (value == null) {
            if (value2 == null) return false;
        } else if (value.equals(value2)) return false;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(40).append("onDisconnect. Reconnecting... (attempt ").append(this.onConnectFailureCounter()).append(")").toString());
            boxedUnit = BoxedUnit.UNIT;
            return true;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return true;
    }

    @Override
    public FiniteDuration getDelay() {
        return this.conf.reconnectionDelay();
    }

    @Override
    public void onConnectionSuccess() {
        this.onConnectFailureCounter_$eq(0);
    }

    public DefaultWebSocketReconnectionHandler(WebSocketSettings conf) {
        this.conf = conf;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.onConnectFailureCounter = 0;
    }
}

