/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.vrf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.horizen.cryptolibprovider.CryptoLibProvider;
import com.horizen.serialization.Views;
import com.horizen.vrf.VrfOutputSerializer;
import java.util.Arrays;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import scorex.core.serialization.BytesSerializable;
import scorex.core.serialization.ScorexSerializer;

@JsonView(value={Views.Default.class})
public class VrfOutput
implements BytesSerializable {
    public static final int OUTPUT_LENGTH = CryptoLibProvider.vrfFunctions().vrfOutputLen();
    @JsonProperty(value="bytes")
    final byte[] vrfOutputBytes;

    public VrfOutput(byte[] bytes) {
        if (bytes.length != OUTPUT_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect output length, %d expected, %d found", OUTPUT_LENGTH, bytes.length));
        }
        this.vrfOutputBytes = Arrays.copyOf(bytes, bytes.length);
    }

    public byte[] bytes() {
        return this.serializer().toBytes((Object)this);
    }

    public ScorexSerializer serializer() {
        return VrfOutputSerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VrfOutput vrfOutput = (VrfOutput)o;
        return Arrays.equals(this.vrfOutputBytes, vrfOutput.vrfOutputBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vrfOutputBytes);
    }

    public String toString() {
        return "VrfOutput{vrfOutputBytes=" + ByteUtils.toHexString((byte[])this.vrfOutputBytes) + "}";
    }
}

