/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.transaction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Longs;
import com.horizen.box.Box;
import com.horizen.box.BoxUnlocker;
import com.horizen.proposition.Proposition;
import com.horizen.serialization.Views;
import com.horizen.transaction.DefaultTransactionIncompatibilityChecker;
import com.horizen.transaction.Transaction;
import com.horizen.transaction.TransactionIncompatibilityChecker;
import com.horizen.transaction.exception.TransactionSemanticValidityException;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.BytesUtils;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import scorex.crypto.hash.Blake2b256;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"signatures", "encoder", "customFieldsData", "customDataMessageToSign", "transactionTypeId"})
public abstract class BoxTransaction<P extends Proposition, B extends Box<P>>
extends Transaction {
    private HashSet<ByteArrayWrapper> _boxIdsToOpen;
    public static final int MAX_TRANSACTION_SIZE = 500000;
    public static final int MAX_TRANSACTION_UNLOCKERS = 1000;
    public static final int MAX_TRANSACTION_NEW_BOXES = 1000;

    @JsonProperty(value="unlockers")
    public abstract List<BoxUnlocker<P>> unlockers();

    @JsonProperty(value="newBoxes")
    public abstract List<B> newBoxes();

    @JsonProperty(value="fee")
    public abstract long fee();

    @Override
    public abstract byte transactionTypeId();

    @Override
    @JsonProperty(value="version")
    public abstract byte version();

    @Override
    public byte[] bytes() {
        return this.serializer().toBytes((Object)this);
    }

    @JsonProperty(value="typeName")
    public String typeName() {
        return this.getClass().getSimpleName();
    }

    @JsonProperty(value="isCustom")
    public Boolean isCustom() {
        return true;
    }

    public abstract void semanticValidity() throws TransactionSemanticValidityException;

    public abstract byte[] customFieldsData();

    @Override
    @JsonProperty(value="id")
    public String id() {
        ByteArrayOutputStream proofsStream = new ByteArrayOutputStream();
        for (BoxUnlocker<P> u : this.unlockers()) {
            byte[] proofBytes = u.boxKey().bytes();
            proofsStream.write(proofBytes, 0, proofBytes.length);
        }
        return BytesUtils.toHexString(Blake2b256.hash((byte[])Bytes.concat((byte[][])new byte[][]{this.messageToSign(), proofsStream.toByteArray(), this.customFieldsData()})));
    }

    public final synchronized Set<ByteArrayWrapper> boxIdsToOpen() {
        if (this._boxIdsToOpen == null) {
            this._boxIdsToOpen = new HashSet();
            for (BoxUnlocker<P> u : this.unlockers()) {
                this._boxIdsToOpen.add(new ByteArrayWrapper(u.closedBoxId()));
            }
        }
        return Collections.unmodifiableSet(this._boxIdsToOpen);
    }

    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return new DefaultTransactionIncompatibilityChecker();
    }

    public abstract byte[] customDataMessageToSign();

    public byte[] messageToSign() {
        ByteArrayOutputStream unlockersStream = new ByteArrayOutputStream();
        for (BoxUnlocker<P> u : this.unlockers()) {
            byte[] boxId = u.closedBoxId();
            unlockersStream.write(boxId, 0, boxId.length);
        }
        ByteArrayOutputStream newBoxesStream = new ByteArrayOutputStream();
        for (Box box : this.newBoxes()) {
            byte[] boxBytes = box.bytes();
            newBoxesStream.write(boxBytes, 0, boxBytes.length);
        }
        return Bytes.concat((byte[][])new byte[][]{{this.version()}, unlockersStream.toByteArray(), newBoxesStream.toByteArray(), Longs.toByteArray((long)this.fee()), this.customDataMessageToSign()});
    }

    public String toString() {
        return String.format("Transaction(id = %s)", this.id());
    }
}

