/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.CswData;
import com.horizen.utils.CswDataSerializer$;
import com.horizen.utils.ListSerializer;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\n\u0015\u0001mA\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019!\u0005\u0001)A\u0005w!AQ\t\u0001b\u0001\n\u00031b\t\u0003\u0004K\u0001\u0001\u0006Ia\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019\u0001\u0006\u0001)A\u0005\u001b\"1\u0011\u000b\u0001C\u0001-ICa!\u0016\u0001\u0005\u0002Y1\u0006\"\u0002.\u0001\t\u0003Y\u0006\"\u00020\u0001\t\u0003a\u0005\"B0\u0001\t\u0003\u0001\u0007\"\u00028\u0001\t\u0003y\u0007\"\u0002>\u0001\t\u0003Z\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\ti2+\u001b3fG\"\f\u0017N\\,bY2,GoQ:x\t\u0006$\u0018m\u0015;pe\u0006<WM\u0003\u0002\u0016-\u000591\u000f^8sC\u001e,'BA\f\u0019\u0003\u001dAwN]5{K:T\u0011!G\u0001\u0004G>l7\u0001A\n\u0006\u0001q\u0011#F\f\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B;uS2T\u0011aJ\u0001\u0007g\u000e|'/\u001a=\n\u0005%\"#!D*d_J,\u0007\u0010T8hO&tw\r\u0005\u0002,Y5\tA#\u0003\u0002.)\t!2+\u001b3fG\"\f\u0017N\\*u_J\fw-Z%oM>\u0004\"a\f\u0019\u000e\u0003YI!!\r\f\u0003\u001dMKG-Z2iC&tG+\u001f9fgB\u00111fM\u0005\u0003iQ\u0011qa\u0015;pe\u0006<W-\u0001\u0004=S:LGO\u0010\u000b\u0003oa\u0002\"a\u000b\u0001\t\u000bU\u0011\u0001\u0019\u0001\u001a\u0002+\r\u001cx\u000fR1uC2K7\u000f^*fe&\fG.\u001b>feV\t1\bE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}Y\tQ!\u001e;jYNL!\u0001Q\u001f\u0003\u001d1K7\u000f^*fe&\fG.\u001b>feB\u0011AHQ\u0005\u0003\u0007v\u0012qaQ:x\t\u0006$\u0018-\u0001\fdg^$\u0015\r^1MSN$8+\u001a:jC2L'0\u001a:!\u0003I9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD7*Z=\u0016\u0003\u001d\u0003\"\u0001\u0010%\n\u0005%k$\u0001\u0005\"zi\u0016\f%O]1z/J\f\u0007\u000f]3s\u0003M9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD7*Z=!\u0003})h\u000eZ3gS:,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM]\u000b\u0002\u001bB\u0011QDT\u0005\u0003\u001fz\u00111!\u00138u\u0003\u0001*h\u000eZ3gS:,GmV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM\u001d\u0011\u00029\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"pk:$XM]&fsR\u0011qi\u0015\u0005\u0006)&\u0001\r!T\u0001\u0010o&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u0006iq-\u001a;Dg^$\u0015\r^1LKf$2aR,Y\u0011\u0015!&\u00021\u0001N\u0011\u0015I&\u00021\u0001N\u0003\u001d\u0019w.\u001e8uKJ\f\u0011dZ3u/&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u000e{WO\u001c;feR\u0011Q\n\u0018\u0005\u0006;.\u0001\r!T\u0001\u0006KB|7\r[\u0001\u0013O\u0016$x+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u0001\u0006hKR\u001c5o\u001e#bi\u0006$\"!Y7\u0011\u0007\tT\u0017I\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011aMG\u0001\u0007yI|w\u000e\u001e \n\u0003}I!!\u001b\u0010\u0002\u000fA\f7m[1hK&\u00111\u000e\u001c\u0002\u0004'\u0016\f(BA5\u001f\u0011\u0015!V\u00021\u0001N\u0003\u0019)\b\u000fZ1uKR!\u0001/^<y!\r\t8oN\u0007\u0002e*\u0011QEH\u0005\u0003iJ\u00141\u0001\u0016:z\u0011\u00151h\u00021\u0001H\u0003\u001d1XM]:j_:DQ\u0001\u0016\bA\u00025CQ!\u001f\bA\u0002\u0005\fqaY:x\t\u0006$\u0018-A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0002yB\u0019Q$`$\n\u0005yt\"AB(qi&|g.\u0001\ts_2d'-Y2l-\u0016\u00148/[8ogV\u0011\u00111\u0001\t\u0004E*<\u0015\u0001\u0003:pY2\u0014\u0017mY6\u0015\u0007A\fI\u0001C\u0003w#\u0001\u0007q)A\u0004jg\u0016k\u0007\u000f^=\u0016\u0005\u0005=\u0001cA\u000f\u0002\u0012%\u0019\u00111\u0003\u0010\u0003\u000f\t{w\u000e\\3b]\u0002")
public class SidechainWalletCswDataStorage
implements ScorexLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final ListSerializer<CswData> cswDataListSerializer;
    private final ByteArrayWrapper withdrawalEpochKey;
    private final int undefinedWithdrawalEpochCounter;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ListSerializer<CswData> cswDataListSerializer() {
        return this.cswDataListSerializer;
    }

    public ByteArrayWrapper withdrawalEpochKey() {
        return this.withdrawalEpochKey;
    }

    private int undefinedWithdrawalEpochCounter() {
        return this.undefinedWithdrawalEpochCounter;
    }

    public ByteArrayWrapper getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getCswDataKey(int withdrawalEpoch, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public int getWithdrawalEpochCounter(int epoch) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getWithdrawalEpochCounterKey(epoch))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedWithdrawalEpochCounter()));
        } else {
            n = this.undefinedWithdrawalEpochCounter();
        }
        return n;
    }

    public int getWithdrawalEpoch() {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochKey())));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = Ints.fromByteArray((byte[])baw.data());
        } else if (None$.MODULE$.equals(option)) {
            n = 0;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<CswData> getCswData(int withdrawalEpoch) {
        void var2_2;
        ListBuffer cswDataSeq = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getWithdrawalEpochCounter(withdrawalEpoch);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getCswDataKey(withdrawalEpoch, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try try_ = this.cswDataListSerializer().parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while csw data parsing.", exception);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                java.util.List list = (java.util.List)success.value();
                cswDataSeq.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while csw data retrieving: record is missing.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Try<SidechainWalletCswDataStorage> update(ByteArrayWrapper version, int withdrawalEpoch, Seq<CswData> cswData) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Object object2;
            boolean isEpochSwitched;
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            int currentWithdrawalEpoch = this.getWithdrawalEpoch();
            boolean bl = isEpochSwitched = withdrawalEpoch != currentWithdrawalEpoch;
            if (isEpochSwitched) {
                int epochToRemove = withdrawalEpoch - 4;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getWithdrawalEpochCounter(epochToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getCswDataKey(epochToRemove, counter)));
                object2 = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getWithdrawalEpochCounterKey(epochToRemove)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Object object3 = isEpochSwitched ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)withdrawalEpoch))))) : BoxedUnit.UNIT;
            if (cswData.nonEmpty()) {
                int nextWithdrawalEpochCounter = this.getWithdrawalEpochCounter(withdrawalEpoch) + 1;
                updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalEpochCounterKey(withdrawalEpoch), new ByteArrayWrapper(Ints.toByteArray((int)nextWithdrawalEpochCounter))));
                object = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getCswDataKey(withdrawalEpoch, nextWithdrawalEpochCounter), new ByteArrayWrapper(this.cswDataListSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(cswData).asJava())))));
            } else {
                object = BoxedUnit.UNIT;
            }
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletCswDataStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainWalletCswDataStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.cswDataListSerializer = new ListSerializer<CswData>(CswDataSerializer$.MODULE$);
        this.withdrawalEpochKey = Utils.calculateKey("withdrawalEpoch".getBytes());
        this.undefinedWithdrawalEpochCounter = -1;
    }
}

