/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.companion.SidechainSecretsCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.secret.Secret;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqView$;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\n\u0014\u0001iA\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)1\b\u0001C\u0001y!9\u0001\t\u0001b\u0001\n\u0013\t\u0005B\u0002,\u0001A\u0003%!\tC\u0003X\u0001\u0011\u0005\u0001\fC\u0003a\u0001\u0011%\u0011\rC\u0003f\u0001\u0011\u0005a\rC\u0003f\u0001\u0011\u00051\u000eC\u0003|\u0001\u0011\u0005A\u0010C\u0003~\u0001\u0011%a\u0010C\u0004\u0002\f\u0001!\t!!\u0004\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0011\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\t9\u0004\u0001C!\u0003s\u0011acU5eK\u000eD\u0017-\u001b8TK\u000e\u0014X\r^*u_J\fw-\u001a\u0006\u0003)U\tqa\u001d;pe\u0006<WM\u0003\u0002\u0017/\u00059\u0001n\u001c:ju\u0016t'\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001Y\u0012%J\u0015\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u00113%D\u0001\u0016\u0013\t!SC\u0001\bTS\u0012,7\r[1j]RK\b/Z:\u0011\u0005\u0019:S\"A\n\n\u0005!\u001a\"\u0001F*jI\u0016\u001c\u0007.Y5o'R|'/Y4f\u0013:4w\u000e\u0005\u0002+_5\t1F\u0003\u0002-[\u0005!Q\u000f^5m\u0015\u0005q\u0013AB:d_J,\u00070\u0003\u00021W\ti1kY8sKbdunZ4j]\u001e\u0004\"A\n\u001a\n\u0005M\u001a\"aB*u_J\fw-Z\u0001\u001ag&$Wm\u00195bS:\u001cVm\u0019:fiN\u001cu.\u001c9b]&|g\u000e\u0005\u00027s5\tqG\u0003\u00029+\u0005I1m\\7qC:LwN\\\u0005\u0003u]\u0012\u0011dU5eK\u000eD\u0017-\u001b8TK\u000e\u0014X\r^:D_6\u0004\u0018M\\5p]\u00061A(\u001b8jiz\"2!\u0010 @!\t1\u0003\u0001C\u0003\u0015\u0007\u0001\u0007\u0011\u0007C\u00035\u0007\u0001\u0007Q'A\u0004tK\u000e\u0014X\r^:\u0016\u0003\t\u0003Ba\u0011%K!6\tAI\u0003\u0002F\r\u00069Q.\u001e;bE2,'BA$\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0013\u0012\u0013Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bCA&O\u001b\u0005a%BA'\u0016\u0003\u0015)H/\u001b7t\u0013\tyEJ\u0001\tCsR,\u0017I\u001d:bs^\u0013\u0018\r\u001d9feB\u0011\u0011\u000bV\u0007\u0002%*\u00111+F\u0001\u0007g\u0016\u001c'/\u001a;\n\u0005U\u0013&AB*fGJ,G/\u0001\u0005tK\u000e\u0014X\r^:!\u00031\u0019\u0017\r\\2vY\u0006$XmS3z)\tQ\u0015\fC\u0003[\r\u0001\u00071,A\u0006qe>\u0004xn]5uS>t\u0007C\u0001/_\u001b\u0005i&B\u0001.\u0016\u0013\tyVLA\u0006Qe>\u0004xn]5uS>t\u0017a\u00037pC\u0012\u001cVm\u0019:fiN$\u0012A\u0019\t\u00039\rL!\u0001Z\u000f\u0003\tUs\u0017\u000e^\u0001\u0004O\u0016$HCA4k!\ra\u0002\u000eU\u0005\u0003Sv\u0011aa\u00149uS>t\u0007\"\u0002.\t\u0001\u0004YFC\u00017y!\riW\u000f\u0015\b\u0003]Nt!a\u001c:\u000e\u0003AT!!]\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001;\u001e\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\t1K7\u000f\u001e\u0006\u0003ivAQ!_\u0005A\u0002i\fA\u0002\u001d:pa>\u001c\u0018\u000e^5p]N\u00042!\\;\\\u0003\u00199W\r^!mYV\tA.A\u0006oKb$h+\u001a:tS>tW#A@\u0011\u000bq\t\t!!\u0002\n\u0007\u0005\rQDA\u0003BeJ\f\u0017\u0010E\u0002\u001d\u0003\u000fI1!!\u0003\u001e\u0005\u0011\u0011\u0015\u0010^3\u0002\u0007\u0005$G\r\u0006\u0003\u0002\u0010\u0005e\u0001#BA\t\u0003+iTBAA\n\u0015\taS$\u0003\u0003\u0002\u0018\u0005M!a\u0001+ss\")1\u000b\u0004a\u0001!R!\u0011qBA\u000f\u0011\u0019\ty\"\u0004a\u0001Y\u0006Q1/Z2sKRd\u0015n\u001d;\u0002\rI,Wn\u001c<f)\u0011\ty!!\n\t\u000bis\u0001\u0019A.\u0015\t\u0005=\u0011\u0011\u0006\u0005\u0007\u0003Wy\u0001\u0019\u0001>\u0002\u001fA\u0014x\u000e]8tSRLwN\u001c'jgR\fq![:F[B$\u00180\u0006\u0002\u00022A\u0019A$a\r\n\u0007\u0005URDA\u0004C_>dW-\u00198\u0002\u001b1\f7\u000f\u001e,feNLwN\\%e+\t\tY\u0004E\u0002\u001dQ*\u0003")
public class SidechainSecretStorage
implements SidechainTypes,
SidechainStorageInfo,
ScorexLogging {
    private final Storage storage;
    private final SidechainSecretsCompanion sidechainSecretsCompanion;
    private final LinkedHashMap<ByteArrayWrapper, Secret> secrets;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private LinkedHashMap<ByteArrayWrapper, Secret> secrets() {
        return this.secrets;
    }

    public ByteArrayWrapper calculateKey(Proposition proposition) {
        return Utils.calculateKey(proposition.bytes());
    }

    private void loadSecrets() {
        this.secrets().clear();
        Buffer storageData = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala();
        ((IterableLike)((TraversableViewLike)storageData.view().map((Function1 & Serializable & scala.Serializable)keyToSecretBytes -> ((ByteArrayWrapper)keyToSecretBytes.getValue()).data(), SeqView$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)secretBytes -> (Secret)$this.sidechainSecretsCompanion.parseBytes((byte[])secretBytes), SeqView$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)secret -> this.secrets().put((Object)this.calculateKey(secret.publicImage()), secret));
    }

    public Option<Secret> get(Proposition proposition) {
        return this.secrets().get((Object)this.calculateKey(proposition));
    }

    public List<Secret> get(List<Proposition> propositions) {
        return (List)propositions.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.option2Iterable(this.secrets().get((Object)this.calculateKey((Proposition)p))), List$.MODULE$.canBuildFrom());
    }

    public List<Secret> getAll() {
        return this.secrets().values().toList();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] nextVersion() {
        void var1_1;
        byte[] version = new byte[32];
        Random$.MODULE$.nextBytes(version);
        return var1_1;
    }

    public Try<SidechainSecretStorage> add(Secret secret) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(secret != null, (Function0 & Serializable & scala.Serializable)() -> "Secret must be NOT NULL.");
            ByteArrayWrapper key = this.calculateKey(secret.publicImage());
            Predef$.MODULE$.require(!this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(secret).toString());
            ByteArrayWrapper value = new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(secret));
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, value), (List)Nil$.MODULE$)).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
            this.secrets().put((Object)key, (Object)secret);
            return this;
        });
    }

    public Try<SidechainSecretStorage> add(List<Secret> secretList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!secretList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Secret must be NOT NULL.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            secretList.foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SidechainSecretStorage.$anonfun$add$6(this, updateList, s)));
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), updateList, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
            return this;
        });
    }

    public Try<SidechainSecretStorage> remove(Proposition proposition) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(proposition != null, (Function0 & Serializable & scala.Serializable)() -> "Proposition must be NOT NULL.");
            ByteArrayWrapper key = this.calculateKey(proposition);
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$)).asJava());
            this.secrets().remove((Object)key);
            return this;
        });
    }

    public Try<SidechainSecretStorage> remove(List<Proposition> propositionList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(!propositionList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Proposition must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            propositionList.foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainSecretStorage.$anonfun$remove$5(this, removeList, p)));
            $this.storage.update(new ByteArrayWrapper(this.nextVersion()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), removeList);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public static final /* synthetic */ boolean $anonfun$add$6(SidechainSecretStorage $this, ArrayList updateList$1, Secret s) {
        ByteArrayWrapper key = $this.calculateKey(s.publicImage());
        Predef$.MODULE$.require(!$this.secrets().contains((Object)key), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Key already exists - ").append(s).toString());
        $this.secrets().put((Object)key, (Object)s);
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(key, new ByteArrayWrapper($this.sidechainSecretsCompanion.toBytes(s))));
    }

    public static final /* synthetic */ boolean $anonfun$remove$5(SidechainSecretStorage $this, ArrayList removeList$1, Proposition p) {
        ByteArrayWrapper key = $this.calculateKey(p);
        $this.secrets().remove((Object)key);
        return removeList$1.add(key);
    }

    public SidechainSecretStorage(Storage storage, SidechainSecretsCompanion sidechainSecretsCompanion) {
        this.storage = storage;
        this.sidechainSecretsCompanion = sidechainSecretsCompanion;
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainSecretsCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainSecretsCompanion must be NOT NULL.");
        this.secrets = new LinkedHashMap();
        this.loadSecrets();
    }
}

