/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.settings;

import com.horizen.SidechainSettings;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogInitializer {
    private static boolean initDone = false;
    private static Set<String> levelSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public static void initLogManager(SidechainSettings info) {
        if (initDone) {
            return;
        }
        initDone = true;
        levelSet.add("off");
        levelSet.add("fatal");
        levelSet.add("error");
        levelSet.add("warn");
        levelSet.add("info");
        levelSet.add("debug");
        levelSet.add("trace");
        levelSet.add("all");
        String logDir = info.scorexSettings().logDir().toString();
        String logFileName = info.logInfo().logFileName();
        String logFileNameWithPath = logDir + File.separator + logFileName;
        String logFileLevel = LogInitializer.getCheckedLevel(info.logInfo().logFileLevel());
        String logConsoleLevel = LogInitializer.getCheckedLevel(info.logInfo().logConsoleLevel());
        System.setProperty("logFilename", logFileNameWithPath);
        System.setProperty("logFileLevel", logFileLevel);
        System.setProperty("logConsoleLevel", logConsoleLevel);
        Logger logger = LogManager.getLogger(LogInitializer.class);
        logger.log(Level.INFO, "Logging system started, log file: [" + logFileNameWithPath + "], file log level: [" + logFileLevel + "], console log level: [" + logConsoleLevel + "]");
    }

    public static String getCheckedLevel(String inLevel) {
        if (levelSet.contains(inLevel)) {
            return inLevel;
        }
        System.out.println("ERROR: specified log4j level: [" + inLevel + "] not valid: defaulting to [info]");
        return "info";
    }
}

