/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.horizen.block.SidechainBlock;
import com.horizen.websocket.server.ERROR_MESSAGE$;
import com.horizen.websocket.server.EVENT_MESSAGE$;
import com.horizen.websocket.server.SidechainNodeChannelImpl;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.ArrayList;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import scala.MatchError;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.util.ScorexLogging;

public final class WebSocketServerEndpoint$
implements ScorexLogging {
    public static WebSocketServerEndpoint$ MODULE$;
    private ArrayList<Session> sessions;
    private final SidechainNodeChannelImpl sidechainNodeChannelImpl;
    private final ObjectMapper mapper;
    private final Logger logger;

    static {
        new WebSocketServerEndpoint$();
    }

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ArrayList<Session> sessions() {
        return this.sessions;
    }

    public void sessions_$eq(ArrayList<Session> x$1) {
        this.sessions = x$1;
    }

    public SidechainNodeChannelImpl sidechainNodeChannelImpl() {
        return this.sidechainNodeChannelImpl;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public void addSession(Session session) {
        this.sessions().add(session);
    }

    public void removeSession(Session session) {
        this.sessions().remove(session);
    }

    public void notifyMempoolChanged() {
        Try<ObjectNode> try_ = this.sidechainNodeChannelImpl().getRawMempool();
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ObjectNode eventPayload = (ObjectNode)success.value();
            this.sessions().forEach(session -> MODULE$.sendMessage(EVENT_MESSAGE$.MODULE$.code(), -1, 2, eventPayload, (Session)session));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(32).append("Error on notifyMempoolChanged!: ").append(ex.toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void notifySemanticallySuccessfulModifier(SidechainBlock block) {
        Try<ObjectNode> try_ = this.sidechainNodeChannelImpl().getBlockInfo(block);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ObjectNode eventPayload = (ObjectNode)success.value();
            this.sessions().forEach(session -> MODULE$.sendMessage(EVENT_MESSAGE$.MODULE$.code(), -1, 0, eventPayload, (Session)session));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(48).append("Error on notifySemanticallySuccessfulModifier!: ").append(ex.toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }

    public void sendMessage(int msgType, int requestId, int answerType, ObjectNode payload, Session client) {
        block5: {
            try {
                JsonNode jsonNode;
                ObjectNode json = this.mapper().createObjectNode();
                if (msgType == 0) {
                    json.put("msgType", msgType);
                    json.put("answerType", answerType);
                    jsonNode = json.put("eventPayload", (JsonNode)payload);
                } else {
                    json.put("msgType", msgType);
                    json.put("requestId", requestId);
                    json.put("answerType", answerType);
                    jsonNode = json.put("responsePayload", (JsonNode)payload);
                }
                String message = json.toString();
                client.getAsyncRemote().sendText(message, new SendHandler(){

                    public void onResult(SendResult sendResult) {
                        BoxedUnit boxedUnit;
                        if (!sendResult.isOK()) {
                            BoxedUnit boxedUnit2;
                            if (WebSocketServerEndpoint$.MODULE$.log().underlying().isInfoEnabled()) {
                                WebSocketServerEndpoint$.MODULE$.log().underlying().info("Send message failed.");
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                        } else if (WebSocketServerEndpoint$.MODULE$.log().underlying().isInfoEnabled()) {
                            WebSocketServerEndpoint$.MODULE$.log().underlying().info("Message sent");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                });
            }
            catch (Throwable e) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("ERROR on sending message");
                    boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void sendError(int requestId, int answerType, int errorCode, String responsePayload, Session client) {
        block3: {
            try {
                ObjectNode json = this.mapper().createObjectNode();
                json.put("msgType", ERROR_MESSAGE$.MODULE$.code());
                json.put("requestId", requestId);
                json.put("answerType", answerType);
                json.put("errorCode", errorCode);
                json.put("responsePayload", responsePayload);
                String message = json.toString();
                client.getAsyncRemote().sendText(message, new SendHandler(){

                    public void onResult(SendResult sendResult) {
                        BoxedUnit boxedUnit;
                        if (!sendResult.isOK()) {
                            BoxedUnit boxedUnit2;
                            if (WebSocketServerEndpoint$.MODULE$.log().underlying().isInfoEnabled()) {
                                WebSocketServerEndpoint$.MODULE$.log().underlying().info("Send message failed.");
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                        } else if (WebSocketServerEndpoint$.MODULE$.log().underlying().isInfoEnabled()) {
                            WebSocketServerEndpoint$.MODULE$.log().underlying().info("Message sent");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                });
            }
            catch (Throwable e) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("ERROR on sending message");
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private WebSocketServerEndpoint$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.sessions = new ArrayList();
        this.sidechainNodeChannelImpl = new SidechainNodeChannelImpl();
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

