/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.storage;

import com.horizen.SidechainTypes;
import com.horizen.WalletBox;
import com.horizen.WalletBoxSerializer;
import com.horizen.box.Box;
import com.horizen.box.ForgerBox;
import com.horizen.box.WithdrawalRequestBox;
import com.horizen.box.ZenBox;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.storage.SidechainStorageInfo;
import com.horizen.storage.Storage;
import com.horizen.storage.StorageIterator;
import com.horizen.transaction.BoxTransaction;
import com.horizen.transaction.SidechainTransaction;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.utils.Pair;
import com.horizen.utils.Utils;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001\u0002\u000f\u001e\u0001\u0011B\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!)Q\t\u0001C\u0001\r\"9!\n\u0001b\u0001\n\u0013Y\u0005BB/\u0001A\u0003%A\nC\u0004_\u0001\t\u0007I\u0011B0\t\r9\u0004\u0001\u0015!\u0003a\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u000b\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001e\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bBq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002Z\u0001!I!a\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011\u0011\u000e\u0001\u0005\n\u0005\u0015\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003W\u0002A\u0011AAC\u0011\u001d\t)\u000b\u0001C\u0001\u0003OCq!!+\u0001\t\u0003\tY\u000bC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\n\u0001\u0011\u0005!Q\u0003\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005CAqA!\u000b\u0001\t\u0003\u0011YCA\rTS\u0012,7\r[1j]^\u000bG\u000e\\3u\u0005>D8\u000b^8sC\u001e,'B\u0001\u0010 \u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001I\u0011\u0002\u000f!|'/\u001b>f]*\t!%A\u0002d_6\u001c\u0001aE\u0003\u0001K-z3\u0007\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y5j\u0011aH\u0005\u0003]}\u0011abU5eK\u000eD\u0017-\u001b8UsB,7\u000f\u0005\u00021c5\tQ$\u0003\u00023;\t!2+\u001b3fG\"\f\u0017N\\*u_J\fw-Z%oM>\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u000511oY8sKbL!AO\u001b\u0003\u001bM\u001bwN]3y\u0019><w-\u001b8h!\t\u0001D(\u0003\u0002>;\t91\u000b^8sC\u001e,\u0017aF:jI\u0016\u001c\u0007.Y5o\u0005>DXm]\"p[B\fg.[8o!\t\u00015)D\u0001B\u0015\t\u0011u$A\u0005d_6\u0004\u0018M\\5p]&\u0011A)\u0011\u0002\u0018'&$Wm\u00195bS:\u0014u\u000e_3t\u0007>l\u0007/\u00198j_:\fa\u0001P5oSRtDcA$I\u0013B\u0011\u0001\u0007\u0001\u0005\u0006=\r\u0001\ra\u000f\u0005\u0006}\r\u0001\raP\u0001\r?^\fG\u000e\\3u\u0005>DXm]\u000b\u0002\u0019B!QJ\u0015+[\u001b\u0005q%BA(Q\u0003\u001diW\u000f^1cY\u0016T!!U\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002T\u001d\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004\"!\u0016-\u000e\u0003YS!aV\u0010\u0002\u000bU$\u0018\u000e\\:\n\u0005e3&\u0001\u0005\"zi\u0016\f%O]1z/J\f\u0007\u000f]3s!\ta3,\u0003\u0002]?\tIq+\u00197mKR\u0014u\u000e_\u0001\u000e?^\fG\u000e\\3u\u0005>DXm\u001d\u0011\u0002%};\u0018\r\u001c7fi\n{\u00070Z:CsRK\b/Z\u000b\u0002AB)QJU1\u0002\fA\u0012!\r\u001c\t\u0004G\"TW\"\u00013\u000b\u0005\u00154\u0017\u0001\u00027b]\u001eT\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\n)1\t\\1tgB\u00111\u000e\u001c\u0007\u0001\t%iw!!A\u0001\u0002\u000b\u0005qNA\u0002`IE\n1cX<bY2,GOQ8yKN\u0014\u0015\u0010V=qK\u0002\n\"\u0001]:\u0011\u0005\u0019\n\u0018B\u0001:(\u0005\u001dqu\u000e\u001e5j]\u001e\u0004$\u0001^>\u0011\u0007UD(0D\u0001w\u0015\t9x$A\u0002c_bL!!\u001f<\u0003\u0007\t{\u0007\u0010\u0005\u0002lw\u0012IA0`A\u0001\u0002\u0003\u0015\tA \u0002\u0004?\u0012\u0012D!C7\b\u0003\u0003\r\tQ!\u0001p#\t\u0001x\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aH\u0001\faJ|\u0007o\\:ji&|g.\u0003\u0003\u0002\n\u0005\r!a\u0003)s_B|7/\u001b;j_:\u0004R!TA\u0007)jK1!a\u0004O\u0005\ri\u0015\r]\u0001\u0015?^\fG\u000e\\3u\u0005>DXm\u001d\"bY\u0006t7-Z:\u0016\u0005\u0005U\u0001CB'S\u0003/\t\t\u0004\r\u0003\u0002\u001a\u0005u\u0001\u0003B2i\u00037\u00012a[A\u000f\t-\ty\"CA\u0001\u0002\u0003\u0015\t!a\t\u0003\u0007}#3'A\u000b`o\u0006dG.\u001a;C_b,7OQ1mC:\u001cWm\u001d\u0011\u0012\u0007A\f)\u0003\r\u0003\u0002(\u0005-\u0002\u0003B;y\u0003S\u00012a[A\u0016\t-\ti#a\f\u0002\u0002\u0003\u0005)\u0011\u0001@\u0003\u0007}#C\u0007B\u0006\u0002 %\t\t1!A\u0003\u0002\u0005\r\u0002c\u0001\u0014\u00024%\u0019\u0011QG\u0014\u0003\t1{gnZ\u0001\u0015?^\fG\u000e\\3u\u0005>D8+\u001a:jC2L'0\u001a:\u0016\u0005\u0005m\u0002c\u0001\u0017\u0002>%\u0019\u0011qH\u0010\u0003']\u000bG\u000e\\3u\u0005>D8+\u001a:jC2L'0\u001a:\u0002+};\u0018\r\u001c7fi\n{\u0007pU3sS\u0006d\u0017N_3sA\u000512-\u00197dk2\fG/\u001a\"pq\u0016\u001c()\u00197b]\u000e,7\u000f\u0006\u0002\u0002HA\u0019a%!\u0013\n\u0007\u0005-sE\u0001\u0003V]&$\u0018AE;qI\u0006$XMQ8yKN\u0014\u0015\r\\1oG\u0016$b!a\u0012\u0002R\u0005U\u0003BBA*\u001b\u0001\u0007!,\u0001\u0005c_b$v.\u00113e\u0011\u0019\t9&\u0004a\u00015\u0006Y!m\u001c=U_J+Wn\u001c<f\u0003I\tG\rZ,bY2,GOQ8y\u0005f$\u0016\u0010]3\u0015\t\u0005\u001d\u0013Q\f\u0005\u0007\u0003?r\u0001\u0019\u0001.\u0002\u0013]\fG\u000e\\3u\u0005>D\u0018!\u0006:f[>4XmV1mY\u0016$(i\u001c=CsRK\b/\u001a\u000b\u0005\u0003\u000f\n)\u0007\u0003\u0004\u0002h=\u0001\r\u0001V\u0001\u000eE>D\u0018\n\u001a+p%\u0016lwN^3\u0002\u001f1|\u0017\rZ,bY2,GOQ8yKN\f1aZ3u)\u0011\ty'!\u001e\u0011\t\u0019\n\tHW\u0005\u0004\u0003g:#AB(qi&|g\u000eC\u0004\u0002xE\u0001\r!!\u001f\u0002\u000b\t|\u00070\u00133\u0011\u000b\u0019\nY(a \n\u0007\u0005utEA\u0003BeJ\f\u0017\u0010E\u0002'\u0003\u0003K1!a!(\u0005\u0011\u0011\u0015\u0010^3\u0015\t\u0005\u001d\u0015q\u0014\t\u0006\u0003\u0013\u000bIJ\u0017\b\u0005\u0003\u0017\u000b)J\u0004\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\tjI\u0001\u0007yI|w\u000e\u001e \n\u0003!J1!a&(\u0003\u001d\u0001\u0018mY6bO\u0016LA!a'\u0002\u001e\n!A*[:u\u0015\r\t9j\n\u0005\b\u0003C\u0013\u0002\u0019AAR\u0003\u0019\u0011w\u000e_%egB1\u0011\u0011RAM\u0003s\naaZ3u\u00032dWCAAD\u0003%9W\r\u001e\"z)f\u0004X\r\u0006\u0003\u0002\b\u00065\u0006bBAX)\u0001\u0007\u0011\u0011W\u0001\bE>DH+\u001f9fa\u0011\t\u0019,a1\u0011\r\u0005U\u0016QXAa\u001d\u0011\t9,!/\u0011\u0007\u00055u%C\u0002\u0002<\u001e\na\u0001\u0015:fI\u00164\u0017bA5\u0002@*\u0019\u00111X\u0014\u0011\u0007-\f\u0019\r\u0002\u0007\u0002F\u00065\u0016\u0011!A\u0001\u0006\u0003\t9MA\u0002`IU\n2\u0001]Aea\u0011\tY-a4\u0011\tUD\u0018Q\u001a\t\u0004W\u0006=GaCAi\u0003'\f\t\u0011!A\u0003\u0002y\u00141a\u0018\u00137\t1\t)-!,\u0002\u0002\u0007\u0005)\u0011AAd\u0003=9W\r\u001e\"pq\u0016\u001c()\u00197b]\u000e,G\u0003BA\u0019\u00033Dq!a,\u0016\u0001\u0004\tY\u000e\r\u0003\u0002^\u0006\u0005\bCBA[\u0003{\u000by\u000eE\u0002l\u0003C$A\"a9\u0002Z\u0006\u0005\t\u0011!B\u0001\u0003K\u00141a\u0018\u00138#\r\u0001\u0018q\u001d\u0019\u0005\u0003S\fi\u000f\u0005\u0003vq\u0006-\bcA6\u0002n\u0012Y\u0011q^Ay\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryF\u0005\u000f\u0003\r\u0003G\fI.!A\u0002\u0002\u000b\u0005\u0011Q]\u0001\u0007kB$\u0017\r^3\u0015\u0011\u0005](\u0011\u0001B\u0003\u0005\u0013\u0001R!!?\u0002~\u001ek!!a?\u000b\u0005Y:\u0013\u0002BA\u0000\u0003w\u00141\u0001\u0016:z\u0011\u0019\u0011\u0019A\u0006a\u0001)\u00069a/\u001a:tS>t\u0007b\u0002B\u0004-\u0001\u0007\u0011qQ\u0001\u0014o\u0006dG.\u001a;C_b,\u0006\u000fZ1uK2K7\u000f\u001e\u0005\b\u0005\u00171\u0002\u0019AAR\u0003A\u0011w\u000e_%egJ+Wn\u001c<f\u0019&\u001cH/A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0003\u0005#\u0001BAJA9)\u0006\u0001\"o\u001c7mE\u0006\u001c7NV3sg&|gn]\u000b\u0003\u0005/\u0001R!!#\u0002\u001aR\u000b\u0001B]8mY\n\f7m\u001b\u000b\u0005\u0003o\u0014i\u0002\u0003\u0004\u0003\u0004e\u0001\r\u0001V\u0001\bSN,U\u000e\u001d;z+\t\u0011\u0019\u0003E\u0002'\u0005KI1Aa\n(\u0005\u001d\u0011un\u001c7fC:\f1bZ3u\u0013R,'/\u0019;peV\u0011!Q\u0006\t\u0004a\t=\u0012b\u0001B\u0019;\ty1\u000b^8sC\u001e,\u0017\n^3sCR|'\u000f")
public class SidechainWalletBoxStorage
implements SidechainTypes,
SidechainStorageInfo,
ScorexLogging {
    private final Storage storage;
    private final LinkedHashMap<ByteArrayWrapper, WalletBox> _walletBoxes;
    private final LinkedHashMap<Class<? extends Box<? extends Proposition>>, Map<ByteArrayWrapper, WalletBox>> _walletBoxesByType;
    private final LinkedHashMap<Class<? extends Box<? extends Proposition>>, Object> _walletBoxesBalances;
    private final WalletBoxSerializer _walletBoxSerializer;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private LinkedHashMap<ByteArrayWrapper, WalletBox> _walletBoxes() {
        return this._walletBoxes;
    }

    private LinkedHashMap<Class<? extends Box<? extends Proposition>>, Map<ByteArrayWrapper, WalletBox>> _walletBoxesByType() {
        return this._walletBoxesByType;
    }

    private LinkedHashMap<Class<? extends Box<? extends Proposition>>, Object> _walletBoxesBalances() {
        return this._walletBoxesBalances;
    }

    private WalletBoxSerializer _walletBoxSerializer() {
        return this._walletBoxSerializer;
    }

    private void calculateBoxesBalances() {
        this._walletBoxesByType().keys().foreach((Function1 & Serializable & scala.Serializable)bc -> this._walletBoxesBalances().put(bc, ((TraversableOnce)((TraversableLike)this._walletBoxesByType().apply(bc)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SidechainWalletBoxStorage.$anonfun$calculateBoxesBalances$2(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    private void updateBoxesBalance(WalletBox boxToAdd, WalletBox boxToRemove) {
        block2: {
            BoxedUnit boxedUnit;
            if (boxToAdd != null) {
                Class<?> bca = boxToAdd.box().getClass();
                boxedUnit = this._walletBoxesBalances().put(bca, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(bca, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) + boxToAdd.box().value())));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (boxToRemove == null) break block2;
            Class<?> bcr = boxToRemove.box().getClass();
            this._walletBoxesBalances().put(bcr, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(bcr, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - boxToRemove.box().value())));
        }
    }

    private void addWalletBoxByType(WalletBox walletBox) {
        Class<?> bc = walletBox.box().getClass();
        ByteArrayWrapper key = Utils.calculateKey(walletBox.box().id());
        Option t = this._walletBoxesByType().get(bc);
        if (t.isEmpty()) {
            LinkedHashMap m = new LinkedHashMap();
            m.put((Object)key, (Object)walletBox);
            this._walletBoxesByType().put(bc, (Object)m);
        } else {
            ((MapLike)t.get()).put((Object)key, (Object)walletBox);
        }
    }

    private void removeWalletBoxByType(ByteArrayWrapper boxIdToRemove) {
        this._walletBoxesByType().keys().foreach((Function1 & Serializable & scala.Serializable)bc -> ((MapLike)this._walletBoxesByType().apply(bc)).remove((Object)boxIdToRemove));
    }

    private void loadWalletBoxes() {
        this._walletBoxes().clear();
        this._walletBoxesByType().clear();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).foreach((Function1 & Serializable & scala.Serializable)wb -> {
            SidechainWalletBoxStorage.$anonfun$loadWalletBoxes$1(this, wb);
            return BoxedUnit.UNIT;
        });
        this.calculateBoxesBalances();
    }

    public Option<WalletBox> get(byte[] boxId) {
        return this._walletBoxes().get((Object)Utils.calculateKey(boxId));
    }

    public List<WalletBox> get(List<byte[]> boxIds) {
        return (List)((TraversableLike)boxIds.map((Function1 & Serializable & scala.Serializable)data -> Utils.calculateKey(data), List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)SidechainWalletBoxStorage.$anonfun$get$2(this, id))).map((Function1 & Serializable & scala.Serializable)id -> (WalletBox)this._walletBoxes().apply(id), List$.MODULE$.canBuildFrom());
    }

    public List<WalletBox> getAll() {
        return this._walletBoxes().values().toList();
    }

    public List<WalletBox> getByType(Class<? extends Box<? extends Proposition>> boxType) {
        Nil$ nil$;
        Option option = this._walletBoxesByType().get(boxType);
        if (option instanceof Some) {
            Some some = (Some)option;
            Map v = (Map)some.value();
            nil$ = v.values().toList();
        } else if (None$.MODULE$.equals(option)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return nil$;
    }

    public long getBoxesBalance(Class<? extends Box<? extends Proposition>> boxType) {
        return BoxesRunTime.unboxToLong((Object)this._walletBoxesBalances().getOrElse(boxType, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Try<SidechainWalletBoxStorage> update(ByteArrayWrapper version, List<WalletBox> walletBoxUpdateList, List<byte[]> boxIdsRemoveList) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(walletBoxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of WalletBoxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!walletBoxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WalletBox to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            removeList.addAll(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)boxIdsRemoveList.map((Function1 & Serializable & scala.Serializable)x$2 -> Utils.calculateKey(x$2), List$.MODULE$.canBuildFrom())).asJavaCollection());
            walletBoxUpdateList.foreach((Function1 & Serializable & scala.Serializable)wb -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(wb.box().id()), new ByteArrayWrapper(this._walletBoxSerializer().toBytes(wb))))));
            $this.storage.update(version, updateList, removeList);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(removeList).asScala()).foreach((Function1 & Serializable & scala.Serializable)key -> {
                SidechainWalletBoxStorage.$anonfun$update$8(this, key);
                return BoxedUnit.UNIT;
            });
            walletBoxUpdateList.foreach((Function1 & Serializable & scala.Serializable)wba -> {
                SidechainWalletBoxStorage.$anonfun$update$9(this, wba);
                return BoxedUnit.UNIT;
            });
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public List<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainWalletBoxStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            this.loadWalletBoxes();
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public StorageIterator getIterator() {
        return this.storage.getIterator();
    }

    public static final /* synthetic */ long $anonfun$calculateBoxesBalances$2(Tuple2 x$1) {
        return ((WalletBox)x$1._2()).box().value();
    }

    public static final /* synthetic */ void $anonfun$loadWalletBoxes$1(SidechainWalletBoxStorage $this, Pair wb) {
        BoxedUnit boxedUnit;
        Try<WalletBox> walletBox = $this._walletBoxSerializer().parseBytesTry(((ByteArrayWrapper)wb.getValue()).data());
        if (walletBox.isSuccess()) {
            $this._walletBoxes().put((Object)Utils.calculateKey(((WalletBox)walletBox.get()).box().id()), walletBox.get());
            $this.addWalletBoxByType((WalletBox)walletBox.get());
        } else if ($this.log().underlying().isErrorEnabled()) {
            $this.log().underlying().error("Error while WalletBox parsing.", new Object[]{walletBox});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$get$2(SidechainWalletBoxStorage $this, ByteArrayWrapper id) {
        return $this._walletBoxes().get((Object)id).isDefined();
    }

    public static final /* synthetic */ void $anonfun$update$8(SidechainWalletBoxStorage $this, ByteArrayWrapper key) {
        block0: {
            Option btr = $this._walletBoxes().remove((Object)key);
            $this.removeWalletBoxByType(key);
            if (!btr.isDefined()) break block0;
            $this.updateBoxesBalance(null, (WalletBox)btr.get());
        }
    }

    public static final /* synthetic */ void $anonfun$update$9(SidechainWalletBoxStorage $this, WalletBox wba) {
        block0: {
            ByteArrayWrapper key = Utils.calculateKey(wba.box().id());
            Option bta = $this._walletBoxes().put((Object)key, (Object)wba);
            $this.addWalletBoxByType(wba);
            if (!bta.isEmpty()) break block0;
            $this.updateBoxesBalance(wba, null);
        }
    }

    public SidechainWalletBoxStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.storage = storage;
        SidechainTypes.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this._walletBoxes = new LinkedHashMap();
        this._walletBoxesByType = new LinkedHashMap();
        this._walletBoxesBalances = new LinkedHashMap();
        this._walletBoxSerializer = new WalletBoxSerializer(sidechainBoxesCompanion);
        this.loadWalletBoxes();
    }
}

