/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.cryptolibprovider;

import com.horizen.provingsystemnative.ProvingSystem;
import com.horizen.provingsystemnative.ProvingSystemType;
import com.horizen.utils.BytesUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class CommonCircuit {
    private static final int maxSegmentSize = 262144;
    public static final int maxProofPlusVkSize = 9216;
    public static final int customFieldsNumber = 2;

    public boolean generateCoboundaryMarlinDLogKeys() {
        return ProvingSystem.generateDLogKeys((ProvingSystemType)ProvingSystemType.COBOUNDARY_MARLIN, (int)262144);
    }

    public String getCoboundaryMarlinSnarkVerificationKeyHex(String verificationKeyPath) {
        if (!Files.exists(Paths.get(verificationKeyPath, new String[0]), new LinkOption[0])) {
            return "";
        }
        try {
            return BytesUtils.toHexString(Files.readAllBytes(Paths.get(verificationKeyPath, new String[0])));
        }
        catch (IOException e) {
            return "";
        }
    }
}

