/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.backup;

import com.horizen.backup.BackupBox;
import com.horizen.box.Box;
import com.horizen.box.CoinsBox;
import com.horizen.companion.SidechainBoxesCompanion;
import com.horizen.proposition.Proposition;
import com.horizen.storage.StorageIterator;
import com.horizen.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import scala.util.Try;
import scorex.util.serialization.Reader;
import scorex.util.serialization.VLQByteBufferReader;

public class BoxIterator {
    private final StorageIterator iterator;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;

    public BoxIterator(StorageIterator iterator, SidechainBoxesCompanion sidechainBoxesCompanion) {
        this.iterator = iterator;
        this.sidechainBoxesCompanion = sidechainBoxesCompanion;
        this.iterator.seekToFirst();
    }

    public void seekToFirst() {
        this.iterator.seekToFirst();
    }

    public void seekIterator(byte[] key) {
        this.iterator.seek(key);
    }

    public Optional<BackupBox> nextBox(boolean ignoreCoinBox) throws RuntimeException {
        while (this.iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            VLQByteBufferReader reader = new VLQByteBufferReader(ByteBuffer.wrap((byte[])entry.getValue()));
            Try tryBox = this.sidechainBoxesCompanion.parseTry((Reader)reader);
            if (!tryBox.isSuccess() || reader.remaining() != 0) continue;
            Box currBox = (Box)tryBox.get();
            if (!this.verifyBox((byte[])entry.getKey(), currBox.id())) continue;
            if (!(currBox instanceof CoinsBox)) {
                return Optional.of(new BackupBox(currBox, (byte[])entry.getKey(), (byte[])entry.getValue()));
            }
            if (ignoreCoinBox) continue;
            throw new RuntimeException("Coin boxes are not eligible to be restored!");
        }
        return Optional.empty();
    }

    public Optional<BackupBox> nextBox() throws RuntimeException {
        return this.nextBox(false);
    }

    public List<Box<Proposition>> getNextBoxes(int nElement, Optional<byte[]> keyToSeek) {
        if (keyToSeek.isPresent()) {
            this.seekIterator(Utils.calculateKey(keyToSeek.get()).data());
            this.nextBox();
        } else {
            this.seekToFirst();
        }
        ArrayList<Box<Proposition>> boxes = new ArrayList<Box<Proposition>>();
        Optional<BackupBox> nextBox = this.nextBox();
        while (boxes.size() < nElement && nextBox.isPresent()) {
            boxes.add(nextBox.get().getBox());
            nextBox = this.nextBox();
        }
        return boxes;
    }

    private boolean verifyBox(byte[] recordId, byte[] boxId) {
        return Arrays.equals(recordId, Utils.calculateKey(boxId).data());
    }
}

