/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket;

import com.horizen.websocket.DisconnectionCode$;
import com.horizen.websocket.WebSocketConnector;
import com.horizen.websocket.WebSocketMessageHandler;
import com.horizen.websocket.WebSocketReconnectionHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import scala.Function0;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ClientEndpoint
@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\n\u0014\u0001iA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015i\u0005\u0001\"\u0001O\u0011%!\u0006\u00011AA\u0002\u0013%Q\u000bC\u0005^\u0001\u0001\u0007\t\u0019!C\u0005=\"IA\r\u0001a\u0001\u0002\u0003\u0006KA\u0016\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019\u0011\b\u0001)A\u0005O\"91\u000f\u0001b\u0001\n\u0013!\bB\u0002?\u0001A\u0003%Q\u000fC\u0003~\u0001\u0011\u0005c\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u0004\u0001\u0005B\u0005\u001d\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0002\u0017/\u0016\u00147k\\2lKR\u001cuN\u001c8fGR|'/S7qY*\u0011A#F\u0001\no\u0016\u00147o\\2lKRT!AF\f\u0002\u000f!|'/\u001b>f]*\t\u0001$A\u0002d_6\u001c\u0001aE\u0003\u00017\u0005*\u0003\u0006\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\rj\u0011aE\u0005\u0003IM\u0011!cV3c'>\u001c7.\u001a;D_:tWm\u0019;peB\u0011!EJ\u0005\u0003OM\u0011\u0001cV3c'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013\u0001B;uS2T\u0011!L\u0001\u0007g\u000e|'/\u001a=\n\u0005=R#!D*d_J,\u0007\u0010T8hO&tw-A\u0006cS:$\u0017\t\u001a3sKN\u001c\bC\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025;5\tQG\u0003\u000273\u00051AH]8pizJ!\u0001O\u000f\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qu\t\u0011cY8o]\u0016\u001cG/[8o)&lWm\\;u!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005ekJ\fG/[8o\u0015\t\u0011U$\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001R \u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006qQ.Z:tC\u001e,\u0007*\u00198eY\u0016\u0014\bC\u0001\u0012H\u0013\tA5CA\fXK\n\u001cvnY6fi6+7o]1hK\"\u000bg\u000e\u001a7fe\u0006\u0019\"/Z2p]:,7\r^5p]\"\u000bg\u000e\u001a7feB\u0011!eS\u0005\u0003\u0019N\u0011AdV3c'>\u001c7.\u001a;SK\u000e|gN\\3di&|g\u000eS1oI2,'/\u0001\u0004=S:LGO\u0010\u000b\u0006\u001fB\u000b&k\u0015\t\u0003E\u0001AQ\u0001M\u0003A\u0002EBQ\u0001P\u0003A\u0002uBQ!R\u0003A\u0002\u0019CQ!S\u0003A\u0002)\u000b1\"^:feN+7o]5p]V\ta\u000b\u0005\u0002X76\t\u0001L\u0003\u0002\u00153*\t!,A\u0003kCZ\f\u00070\u0003\u0002]1\n91+Z:tS>t\u0017aD;tKJ\u001cVm]:j_:|F%Z9\u0015\u0005}\u0013\u0007C\u0001\u000fa\u0013\t\tWD\u0001\u0003V]&$\bbB2\b\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014\u0001D;tKJ\u001cVm]:j_:\u0004\u0013AB2mS\u0016tG/F\u0001h!\tA\u0007/D\u0001j\u0015\t)'N\u0003\u0002lY\u0006)A/\u001f:vg*\u0011QN\\\u0001\nO2\f7o\u001d4jg\"T\u0011a\\\u0001\u0004_J<\u0017BA9j\u00055\u0019E.[3oi6\u000bg.Y4fe\u000691\r\\5f]R\u0004\u0013\u0001\u0005:fG>tg.Z2u\u0011\u0006tG\r\\3s+\u0005)\bC\u0001<z\u001d\tAw/\u0003\u0002yS\u0006i1\t\\5f]Rl\u0015M\\1hKJL!A_>\u0003!I+7m\u001c8oK\u000e$\b*\u00198eY\u0016\u0014(B\u0001=j\u0003E\u0011XmY8o]\u0016\u001cG\u000fS1oI2,'\u000fI\u0001\nSN\u001cF/\u0019:uK\u0012$\u0012a \t\u00049\u0005\u0005\u0011bAA\u0002;\t9!i\\8mK\u0006t\u0017!B:uCJ$HCAA\u0005!\u0015\tY!a\u0004`\u001b\t\tiA\u0003\u0002,;%!\u0011\u0011CA\u0007\u0005\r!&/_\u0001\u000bCNLhnY*uCJ$HCAA\f!\u0019\tI\"a\u0007\u0002\n5\t\u0011)C\u0002\u0002\u001e\u0005\u0013aAR;ukJ,\u0017\u0001B:u_B\f1b]3oI6+7o]1hKR\u0019q,!\n\t\r\u0005\u001d\u0012\u00031\u00012\u0003\u001diWm]:bO\u0016D3\u0001AA\u0016!\r9\u0016QF\u0005\u0004\u0003_A&AD\"mS\u0016tG/\u00128ea>Lg\u000e\u001e")
public class WebSocketConnectorImpl
implements WebSocketConnector,
ScorexLogging {
    private final String bindAddress;
    private final FiniteDuration connectionTimeout;
    public final WebSocketMessageHandler com$horizen$websocket$WebSocketConnectorImpl$$messageHandler;
    public final WebSocketReconnectionHandler com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler;
    private Session userSession;
    private final ClientManager client;
    private final ClientManager.ReconnectHandler reconnectHandler;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Session userSession() {
        return this.userSession;
    }

    private void userSession_$eq(Session x$1) {
        this.userSession = x$1;
    }

    private ClientManager client() {
        return this.client;
    }

    private ClientManager.ReconnectHandler reconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public boolean isStarted() {
        return this.userSession() != null && this.userSession().isOpen();
    }

    @Override
    public Try<BoxedUnit> start() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.isStarted()) {
                throw new IllegalStateException("Connector is already started.");
            }
            this.client().getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", this.reconnectHandler());
            this.client().getProperties().put("org.glassfish.tyrus.client.ClientManager.ContainerTimeout", String.valueOf($this.connectionTimeout.toMillis()));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Starting web socket connector...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.userSession_$eq(this.client().connectToServer((Object)this, new URI($this.bindAddress)));
            $this.com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler.onConnectionSuccess();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Web socket connector started.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.userSession().addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(this){
                private final /* synthetic */ WebSocketConnectorImpl $outer;

                public void onMessage(String t) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.log().underlying().isInfoEnabled()) {
                        this.$outer.log().underlying().info(new StringBuilder(30).append("Message received from server: ").append(t).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.com$horizen$websocket$WebSocketConnectorImpl$$messageHandler.onReceivedMessage(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        });
    }

    @Override
    public Future<Try<BoxedUnit>> asyncStart() {
        Promise promise = Promise$.MODULE$.apply();
        new Thread(new Runnable(this, promise){
            private final /* synthetic */ WebSocketConnectorImpl $outer;
            private final Promise promise$1;

            public void run() {
                this.promise$1.success(this.$outer.start());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
            }
        }).start();
        return promise.future();
    }

    @Override
    public Try<BoxedUnit> stop() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Stopping web socket connector...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.userSession().close();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Web socket connector stopped.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    @Override
    public void sendMessage(String message) {
        try {
            this.userSession().getAsyncRemote().sendText(message, new SendHandler(this, message){
                private final /* synthetic */ WebSocketConnectorImpl $outer;
                private final String message$1;

                public void onResult(SendResult sendResult) {
                    BoxedUnit boxedUnit;
                    if (!sendResult.isOK()) {
                        BoxedUnit boxedUnit2;
                        if (this.$outer.log().underlying().isInfoEnabled()) {
                            this.$outer.log().underlying().info("Send message failed.");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        this.$outer.com$horizen$websocket$WebSocketConnectorImpl$$messageHandler.onSendMessageErrorOccurred(this.message$1, sendResult.getException());
                    } else if (this.$outer.log().underlying().isInfoEnabled()) {
                        this.$outer.log().underlying().info("Message sent");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.message$1 = message$1;
                }
            });
        }
        catch (Throwable e) {
            this.com$horizen$websocket$WebSocketConnectorImpl$$messageHandler.onSendMessageErrorOccurred(message, e);
        }
    }

    public WebSocketConnectorImpl(String bindAddress, FiniteDuration connectionTimeout, WebSocketMessageHandler messageHandler, WebSocketReconnectionHandler reconnectionHandler) {
        this.bindAddress = bindAddress;
        this.connectionTimeout = connectionTimeout;
        this.com$horizen$websocket$WebSocketConnectorImpl$$messageHandler = messageHandler;
        this.com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler = reconnectionHandler;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.client = ClientManager.createClient();
        this.reconnectHandler = new ClientManager.ReconnectHandler(this){
            private final /* synthetic */ WebSocketConnectorImpl $outer;

            public long getDelay() {
                return this.$outer.com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler.getDelay().toSeconds();
            }

            public boolean onDisconnect(CloseReason closeReason) {
                BoxedUnit boxedUnit;
                if (this.$outer.log().underlying().isInfoEnabled()) {
                    this.$outer.log().underlying().info(new StringBuilder(22).append("onDisconnect. Reason: ").append(closeReason.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return closeReason.getCloseCode().getCode() == 1000 ? this.$outer.com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler.onDisconnection(DisconnectionCode$.MODULE$.ON_SUCCESS(), closeReason.getReasonPhrase()) : this.$outer.com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler.onDisconnection(DisconnectionCode$.MODULE$.UNEXPECTED(), closeReason.getReasonPhrase());
            }

            public boolean onConnectFailure(Exception exception) {
                return this.$outer.com$horizen$websocket$WebSocketConnectorImpl$$reconnectionHandler.onConnectionFailed(exception);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

