/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.horizen.websocket.EventHandler;
import com.horizen.websocket.EventPayload;
import com.horizen.websocket.RequestPayload;
import com.horizen.websocket.ResponsePayload;
import com.horizen.websocket.WebSocketChannel;
import com.horizen.websocket.WebSocketChannelCommunicationClient;
import com.horizen.websocket.WebSocketCommunicationClient;
import com.horizen.websocket.WebSocketCommunicationClient$Error$2$;
import com.horizen.websocket.WebSocketMessageHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u000e\u001c\u0001\tBQ\u0001\u000f\u0001\u0005\u0002eBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004H\u0001\u0001\u0006I!\u0010\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0011\u001dY\u0007\u00011A\u0005\n1DaA\u001d\u0001!B\u0013Q\u0005bB:\u0001\u0001\u0004%I\u0001\u001e\u0005\n\u0003+\u0001\u0001\u0019!C\u0005\u0003/Aq!a\u0007\u0001A\u0003&Q\u000fC\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0001bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003SA1\"!\f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\"!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u00024!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA)\u0001\u0011\u0005\u00131\u000b\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t\t\f\u0001C!\u0003gCq!!1\u0001\t\u0003\n\u0019\rC\u0004\u0002J\u0002!I!a3\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAr\u0001\u0011\u0005\u0013Q\u001d\u0005\b\u0003g\u0004A\u0011BA{\u0011\u001d\t9\u0010\u0001C!\u0003s\u0014AdV3c'>\u001c7.\u001a;D_6lWO\\5dCRLwN\\\"mS\u0016tGO\u0003\u0002\u001d;\u0005Iq/\u001a2t_\u000e\\W\r\u001e\u0006\u0003=}\tq\u0001[8sSj,gNC\u0001!\u0003\r\u0019w.\\\u0002\u0001'\u0015\u00011%K\u00171!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002$/\u0016\u00147k\\2lKR\u001c\u0005.\u00198oK2\u001cu.\\7v]&\u001c\u0017\r^5p]\u000ec\u0017.\u001a8u!\tQc&\u0003\u000207\t9r+\u001a2T_\u000e\\W\r^'fgN\fw-\u001a%b]\u0012dWM\u001d\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA!\u001e;jY*\tQ'\u0001\u0004tG>\u0014X\r_\u0005\u0003oI\u0012QbU2pe\u0016DHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001;!\tQ\u0003!\u0001\u0004nCB\u0004XM]\u000b\u0002{A\u0011a(R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\tI\u0006$\u0018MY5oI*\u0011!iQ\u0001\bU\u0006\u001c7n]8o\u0015\t!u$A\u0005gCN$XM\u001d=nY&\u0011ai\u0010\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\b[\u0006\u0004\b/\u001a:!\u00031\u0011X-];fgR\u001c\bk\\8m+\u0005Q\u0005\u0003B&Q%vk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b!bY8oGV\u0014(/\u001a8u\u0015\tyU%\u0001\u0006d_2dWm\u0019;j_:L!!\u0015'\u0003\u000fQ\u0013\u0018.Z'baB\u00111K\u0017\b\u0003)b\u0003\"!V\u0013\u000e\u0003YS!aV\u0011\u0002\rq\u0012xn\u001c;?\u0013\tIV%\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-&!\u0011!c\f\u00195\n\u0005}+#A\u0002+va2,'\u0007E\u0002bG\u0016l\u0011A\u0019\u0006\u0003\u001b\u0016J!\u0001\u001a2\u0003\u000fA\u0013x.\\5tKB\u0011!FZ\u0005\u0003On\u0011qBU3ta>t7/\u001a)bs2|\u0017\r\u001a\t\u0004'&,\u0017B\u00016]\u0005\u0015\u0019E.Y:t\u0003A\u0011X-];fgR\u001c\bk\\8m?\u0012*\u0017\u000f\u0006\u0002naB\u0011AE\\\u0005\u0003_\u0016\u0012A!\u00168ji\"9\u0011/BA\u0001\u0002\u0004Q\u0015a\u0001=%c\u0005i!/Z9vKN$8\u000fU8pY\u0002\n\u0011#\u001a<f]RD\u0015M\u001c3mKJ\u001c\bk\\8m+\u0005)\b\u0003B&Qmf\u0004\"\u0001J<\n\u0005a,#aA%oiB!!p`A\u0003\u001d\tYXP\u0004\u0002Vy&\ta%\u0003\u0002\u007fK\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u00111aU3r\u0015\tqX\u0005\u0005\u0004%=\u0006\u001d\u00111\u0003\t\u0006U\u0005%\u0011QB\u0005\u0004\u0003\u0017Y\"\u0001D#wK:$\b*\u00198eY\u0016\u0014\bc\u0001\u0016\u0002\u0010%\u0019\u0011\u0011C\u000e\u0003\u0019\u00153XM\u001c;QCfdw.\u00193\u0011\tMK\u0017QB\u0001\u0016KZ,g\u000e\u001e%b]\u0012dWM]:Q_>dw\fJ3r)\ri\u0017\u0011\u0004\u0005\bc\"\t\t\u00111\u0001v\u0003I)g/\u001a8u\u0011\u0006tG\r\\3sgB{w\u000e\u001c\u0011\u0002!],'mU8dW\u0016$8\t[1o]\u0016dWCAA\u0011!\rQ\u00131E\u0005\u0004\u0003KY\"\u0001E,fEN{7m[3u\u0007\"\fgN\\3m\u0003Q9XMY*pG.,Go\u00115b]:,Gn\u0018\u0013fcR\u0019Q.a\u000b\t\u0011E\\\u0011\u0011!a\u0001\u0003C\t\u0011c^3c'>\u001c7.\u001a;DQ\u0006tg.\u001a7!\u0003\u001d\u0019w.\u001e8uKJ,\"!a\r\u0011\t\u0005U\u00121I\u0007\u0003\u0003oQA!!\u000f\u0002<\u00051\u0011\r^8nS\u000eT1!TA\u001f\u0015\r\u0019\u0014q\b\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QIA\u001c\u00055\tEo\\7jG&sG/Z4fe\u0006A1m\\;oi\u0016\u0014\b%A\ntKR<VMY*pG.,Go\u00115b]:,G\u000eF\u0002n\u0003\u001bBq!a\u0014\u0010\u0001\u0004\t\t#A\u0004dQ\u0006tg.\u001a7\u0002\u0017M,g\u000e\u001a*fcV,7\u000f^\u000b\u0007\u0003+\n9(!\u0019\u0015\u0011\u0005]\u0013QNA9\u0003\u0007\u0003R!YA-\u0003;J1!a\u0017c\u0005\u00191U\u000f^;sKB!\u0011qLA1\u0019\u0001!q!a\u0019\u0011\u0005\u0004\t)G\u0001\u0003SKN\u0004\u0018cAA4KB\u0019A%!\u001b\n\u0007\u0005-TEA\u0004O_RD\u0017N\\4\t\r\u0005=\u0004\u00031\u0001w\u0003-\u0011X-];fgR$\u0016\u0010]3\t\u000f\u0005M\u0004\u00031\u0001\u0002v\u00059!/Z9vKN$\b\u0003BA0\u0003o\"q!!\u001f\u0011\u0005\u0004\tYHA\u0002SKF\fB!a\u001a\u0002~A\u0019!&a \n\u0007\u0005\u00055D\u0001\bSKF,Xm\u001d;QCfdw.\u00193\t\u000f\u0005\u0015\u0005\u00031\u0001\u0002\b\u0006i!/Z:q_:\u001cXm\u00117buj\u0004BaU5\u0002^\u0005!\"/Z4jgR,'/\u0012<f]RD\u0015M\u001c3mKJ,B!!$\u0002&RA\u0011qRAM\u0003;\u000bY\u000bE\u0003\u0002\u0012\u0006UU.\u0004\u0002\u0002\u0014*\u00111'J\u0005\u0005\u0003/\u000b\u0019JA\u0002UefDa!a'\u0012\u0001\u00041\u0018!C3wK:$H+\u001f9f\u0011\u001d\ty*\u0005a\u0001\u0003C\u000bq\u0001[1oI2,'\u000fE\u0003+\u0003\u0013\t\u0019\u000b\u0005\u0003\u0002`\u0005\u0015FaBAT#\t\u0007\u0011\u0011\u0016\u0002\u0002\u000bF!\u0011qMA\u0007\u0011\u001d\ti+\u0005a\u0001\u0003_\u000b!\"\u001a<f]R\u001cE.\u0019>{!\u0011\u0019\u0016.a)\u0002-Ut'/Z4jgR,'/\u0012<f]RD\u0015M\u001c3mKJ,B!!.\u0002@R)Q.a.\u0002:\"1\u00111\u0014\nA\u0002YDq!a(\u0013\u0001\u0004\tY\fE\u0003+\u0003\u0013\ti\f\u0005\u0003\u0002`\u0005}FaBAT%\t\u0007\u0011\u0011V\u0001\u0012_:\u0014VmY3jm\u0016$W*Z:tC\u001e,GcA7\u0002F\"1\u0011qY\nA\u0002I\u000bq!\\3tg\u0006<W-\u0001\u0007qe>\u001cWm]:FeJ|'\u000fF\u0002n\u0003\u001bDq!a4\u0015\u0001\u0004\t\t.\u0001\u0003kg>t\u0007c\u0001 \u0002T&\u0019\u0011Q[ \u0003\u0011)\u001bxN\u001c(pI\u0016\fA\u0002\u001d:pG\u0016\u001c8/\u0012<f]R$2!\\An\u0011\u001d\ty-\u0006a\u0001\u0003#\fq\u0002\u001d:pG\u0016\u001c8OU3ta>t7/\u001a\u000b\u0004[\u0006\u0005\bbBAh-\u0001\u0007\u0011\u0011[\u0001\u001b_:\u001cVM\u001c3NKN\u001c\u0018mZ3FeJ|'oT2dkJ\u0014X\r\u001a\u000b\u0006[\u0006\u001d\u0018\u0011\u001e\u0005\u0007\u0003\u000f<\u0002\u0019\u0001*\t\u000f\u0005-x\u00031\u0001\u0002n\u0006)1-Y;tKB\u0019!0a<\n\t\u0005E\u00181\u0001\u0002\n)\"\u0014xn^1cY\u0016\f\u0011cZ3oKJ\fG/\u001a*fcV,7\u000f^%e+\u0005\u0011\u0016A\u0006:fcV,7\u000f\u001e+j[\u0016|W\u000f\u001e#ve\u0006$\u0018n\u001c8\u0015\u0005\u0005m\b\u0003BA\u007f\u0005\u0007i!!a@\u000b\u0007\t\u0005!-\u0001\u0005ekJ\fG/[8o\u0013\u0011\u0011)!a@\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0002")
public class WebSocketCommunicationClient
implements WebSocketChannelCommunicationClient,
WebSocketMessageHandler,
ScorexLogging {
    private final ObjectMapper mapper;
    private TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> requestsPool;
    private TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> eventHandlersPool;
    private WebSocketChannel webSocketChannel;
    private final AtomicInteger counter;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> requestsPool() {
        return this.requestsPool;
    }

    private void requestsPool_$eq(TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> x$1) {
        this.requestsPool = x$1;
    }

    private TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> eventHandlersPool() {
        return this.eventHandlersPool;
    }

    private void eventHandlersPool_$eq(TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> x$1) {
        this.eventHandlersPool = x$1;
    }

    private WebSocketChannel webSocketChannel() {
        return this.webSocketChannel;
    }

    private void webSocketChannel_$eq(WebSocketChannel x$1) {
        this.webSocketChannel = x$1;
    }

    private AtomicInteger counter() {
        return this.counter;
    }

    @Override
    public void setWebSocketChannel(WebSocketChannel channel) {
        this.webSocketChannel_$eq(channel);
    }

    @Override
    public <Req extends RequestPayload, Resp extends ResponsePayload> Future<Resp> sendRequest(int requestType, Req request, Class<Resp> responseClazz) {
        Future future;
        if (this.webSocketChannel() != null) {
            String requestId = this.generateRequestId();
            ObjectNode json = this.mapper().createObjectNode();
            json.put("msgType", 1);
            json.put("requestType", requestType);
            json.put("requestId", requestId);
            json.put("requestPayload", this.mapper().valueToTree(request));
            String message = json.toString();
            Promise promise = Promise$.MODULE$.apply();
            this.requestsPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requestId), (Object)new Tuple2((Object)promise, responseClazz)));
            this.webSocketChannel().sendMessage(message);
            future = promise.future();
        } else {
            future = Promise$.MODULE$.apply().failure((Throwable)new IllegalStateException("The web socket channel must be not null.")).future();
        }
        return future;
    }

    @Override
    public <E extends EventPayload> Try<BoxedUnit> registerEventHandler(int eventType, EventHandler<E> handler, Class<E> eventClazz) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            WebSocketCommunicationClient webSocketCommunicationClient = this;
            synchronized (webSocketCommunicationClient) {
                Seq eventHandlers = (Seq)this.eventHandlersPool().getOrElse((Object)BoxesRunTime.boxToInteger((int)eventType), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                if (eventHandlers.exists((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)WebSocketCommunicationClient.$anonfun$registerEventHandler$3(handler, h)))) {
                    throw new IllegalArgumentException("Handler is already registered.");
                }
                Seq updatedHandlers = (Seq)eventHandlers.$colon$plus((Object)new Tuple2((Object)handler, (Object)eventClazz), Seq$.MODULE$.canBuildFrom());
                this.eventHandlersPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)eventType)), (Object)updatedHandlers));
            }
        });
    }

    @Override
    public <E extends EventPayload> void unregisterEventHandler(int eventType, EventHandler<E> handler) {
        WebSocketCommunicationClient webSocketCommunicationClient = this;
        synchronized (webSocketCommunicationClient) {
            Option option = this.eventHandlersPool().get((Object)BoxesRunTime.boxToInteger((int)eventType));
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Seq handlers = (Seq)some.value();
            Seq updatedHandlers = (Seq)handlers.filter((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)WebSocketCommunicationClient.$anonfun$unregisterEventHandler$1(handler, h)));
            TrieMap trieMap = this.eventHandlersPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)eventType)), (Object)updatedHandlers));
        }
    }

    @Override
    public void onReceivedMessage(String message) {
        block9: {
            try {
                JsonNode json = this.mapper().readTree(message);
                int n = json.get("msgType").asInt();
                switch (n) {
                    case 0: {
                        this.processEvent(json);
                        break;
                    }
                    case 2: {
                        this.processResponse(json);
                        break;
                    }
                    case 3: {
                        this.processError(json);
                        break;
                    }
                    default: {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(new StringBuilder(51).append("On receive message processing exception occurred = ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void processError(JsonNode json) {
        Some some;
        Tuple2 tuple2;
        LazyRef lazyRef = new LazyRef();
        String requestId = json.get("requestId").asText("");
        Option option = this.requestsPool().remove((Object)requestId);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            BoxedUnit boxedUnit;
            Promise promise = (Promise)tuple2._1();
            try {
                public class Com_horizen_websocket_WebSocketCommunicationClient$Error$1
                implements Product,
                scala.Serializable {
                    private final int msgType;
                    private final String requestId;
                    private final int errorCode;
                    private final String message;
                    private final /* synthetic */ WebSocketCommunicationClient $outer;

                    public int msgType() {
                        return this.msgType;
                    }

                    public String requestId() {
                        return this.requestId;
                    }

                    public int errorCode() {
                        return this.errorCode;
                    }

                    public String message() {
                        return this.message;
                    }

                    public Com_horizen_websocket_WebSocketCommunicationClient$Error$1 copy(int msgType, String requestId, int errorCode, String message) {
                        return new Com_horizen_websocket_WebSocketCommunicationClient$Error$1(this.$outer, msgType, requestId, errorCode, message);
                    }

                    public int copy$default$1() {
                        return this.msgType();
                    }

                    public String copy$default$2() {
                        return this.requestId();
                    }

                    public int copy$default$3() {
                        return this.errorCode();
                    }

                    public String copy$default$4() {
                        return this.message();
                    }

                    public String productPrefix() {
                        return "Error";
                    }

                    public int productArity() {
                        return 4;
                    }

                    public Object productElement(int x$1) {
                        Object object;
                        int n = x$1;
                        switch (n) {
                            case 0: {
                                object = BoxesRunTime.boxToInteger((int)this.msgType());
                                break;
                            }
                            case 1: {
                                object = this.requestId();
                                break;
                            }
                            case 2: {
                                object = BoxesRunTime.boxToInteger((int)this.errorCode());
                                break;
                            }
                            case 3: {
                                object = this.message();
                                break;
                            }
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                        }
                        return object;
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Com_horizen_websocket_WebSocketCommunicationClient$Error$1;
                    }

                    public int hashCode() {
                        int n = -889275714;
                        n = Statics.mix((int)n, (int)this.msgType());
                        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.requestId()));
                        n = Statics.mix((int)n, (int)this.errorCode());
                        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
                        return Statics.finalizeHash((int)n, (int)4);
                    }

                    public String toString() {
                        return ScalaRunTime$.MODULE$._toString((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Com_horizen_websocket_WebSocketCommunicationClient$Error$1)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Com_horizen_websocket_WebSocketCommunicationClient$Error$1 var4_4 = (Com_horizen_websocket_WebSocketCommunicationClient$Error$1)x$1;
                        if (this.msgType() != var4_4.msgType()) return false;
                        String string = this.requestId();
                        String string2 = var4_4.requestId();
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        if (this.errorCode() != var4_4.errorCode()) return false;
                        String string3 = this.message();
                        String string4 = var4_4.message();
                        if (string3 == null) {
                            if (string4 != null) {
                                return false;
                            }
                        } else if (!string3.equals(string4)) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public Com_horizen_websocket_WebSocketCommunicationClient$Error$1(WebSocketCommunicationClient $outer, int msgType, String requestId, int errorCode, String message) {
                        this.msgType = msgType;
                        this.requestId = requestId;
                        this.errorCode = errorCode;
                        this.message = message;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        Product.$init$((Product)this);
                    }
                }
                Com_horizen_websocket_WebSocketCommunicationClient$Error$1 resp = (Com_horizen_websocket_WebSocketCommunicationClient$Error$1)this.mapper().convertValue((Object)json, Com_horizen_websocket_WebSocketCommunicationClient$Error$1.class);
                promise.failure((Throwable)new RuntimeException(resp.message()));
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable e) {
                promise.failure((Throwable)new RuntimeException(json.toString()));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(27).append("Unknown response received: ").append(json.toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void processEvent(JsonNode json) {
        int eventType = json.get("eventType").asInt(-1);
        Option option = this.eventHandlersPool().get((Object)BoxesRunTime.boxToInteger((int)eventType));
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq handlers = (Seq)some.value();
            JsonNode eventPayload = json.get("eventPayload");
            handlers.foreach((Function1 & Serializable & scala.Serializable)h -> {
                WebSocketCommunicationClient.$anonfun$processEvent$1(this, eventPayload, h);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(53).append("Event without defined handler received. Event type = ").append(eventType).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void processResponse(JsonNode json) {
        Some some;
        Tuple2 tuple2;
        String requestId = json.get("requestId").asText("");
        Option option = this.requestsPool().remove((Object)requestId);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            BoxedUnit boxedUnit;
            Promise promise = (Promise)tuple2._1();
            Class responseClazz = (Class)tuple2._2();
            try {
                ResponsePayload resp = (ResponsePayload)this.mapper().convertValue((Object)json.get("responsePayload"), responseClazz);
                promise.success((Object)resp);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                promise.failure(ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(46).append("Unknown response received with requested id = ").append(requestId).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Override
    public void onSendMessageErrorOccurred(String message, Throwable cause) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            Tuple2 tuple2;
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error("Error from web socket channel", cause);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            JsonNode json = this.mapper().readTree(message);
            String requestId = json.get("requestId").asText("");
            Option option = this.requestsPool().remove((Object)requestId);
            if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
                throw new MatchError((Object)option);
            }
            Promise promise = (Promise)tuple2._1();
            Promise promise2 = promise.failure(cause);
            return promise2;
        });
    }

    private String generateRequestId() {
        return String.valueOf(this.counter().addAndGet(1));
    }

    @Override
    public FiniteDuration requestTimeoutDuration() {
        return new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
    }

    public static final /* synthetic */ boolean $anonfun$registerEventHandler$3(EventHandler handler$1, Tuple2 h) {
        return h._1().equals(handler$1);
    }

    public static final /* synthetic */ boolean $anonfun$unregisterEventHandler$1(EventHandler handler$2, Tuple2 h) {
        return !h._1().equals(handler$2);
    }

    private final /* synthetic */ WebSocketCommunicationClient$Error$2$ Error$lzycompute$1(LazyRef Error$module$1) {
        WebSocketCommunicationClient$Error$2$ webSocketCommunicationClient$Error$2$;
        LazyRef lazyRef = Error$module$1;
        synchronized (lazyRef) {
            webSocketCommunicationClient$Error$2$ = Error$module$1.initialized() ? (WebSocketCommunicationClient$Error$2$)((Object)Error$module$1.value()) : (WebSocketCommunicationClient$Error$2$)((Object)Error$module$1.initialize((Object)new WebSocketCommunicationClient$Error$2$(this)));
        }
        return webSocketCommunicationClient$Error$2$;
    }

    private final WebSocketCommunicationClient$Error$2$ Error$3(LazyRef Error$module$1) {
        return Error$module$1.initialized() ? (WebSocketCommunicationClient$Error$2$)((Object)Error$module$1.value()) : this.Error$lzycompute$1(Error$module$1);
    }

    public static final /* synthetic */ void $anonfun$processEvent$1(WebSocketCommunicationClient $this, JsonNode eventPayload$1, Tuple2 h) {
        block3: {
            try {
                EventPayload resp = (EventPayload)$this.mapper().convertValue((Object)eventPayload$1, (Class)h._2());
                ((EventHandler)h._1()).onEvent(resp);
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                if ($this.log().underlying().isErrorEnabled()) {
                    $this.log().underlying().error(new StringBuilder(37).append("Event parsing was failed by handler: ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public WebSocketCommunicationClient() {
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
        this.requestsPool = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.eventHandlersPool = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.counter = new AtomicInteger();
    }
}

