/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket;

import com.horizen.block.MainchainBlockReference;
import com.horizen.block.MainchainBlockReference$;
import com.horizen.params.NetworkParams;
import com.horizen.utils.BytesUtils;
import com.horizen.websocket.BlockResponsePayload;
import com.horizen.websocket.BlocksResponsePayload;
import com.horizen.websocket.CommunicationClient;
import com.horizen.websocket.GetBlockByHashRequestPayload;
import com.horizen.websocket.GetBlockByHeightRequestPayload;
import com.horizen.websocket.GetBlocksAfterHashRequestPayload;
import com.horizen.websocket.GetBlocksAfterHeightRequestPayload;
import com.horizen.websocket.GetNewBlocksRequestPayload;
import com.horizen.websocket.MainchainNodeChannel;
import com.horizen.websocket.NewBlocksResponsePayload;
import com.horizen.websocket.OnUpdateTipEventHandler;
import com.horizen.websocket.OnUpdateTipEventPayload;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0007\u000f\u0001UA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!)!\u0006\u0001C\u0001W!)q\u0006\u0001C!a!)!\t\u0001C!\u0007\")\u0011\u000b\u0001C\u0005%\")a\f\u0001C\u0001?\")Q\u000e\u0001C\u0001]\")\u0011\u000f\u0001C!e\")!\u0010\u0001C!w\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0006\u0001\t\u0003\n9B\u0001\rNC&t7\r[1j]:{G-Z\"iC:tW\r\\%na2T!a\u0004\t\u0002\u0013],'m]8dW\u0016$(BA\t\u0013\u0003\u001dAwN]5{K:T\u0011aE\u0001\u0004G>l7\u0001A\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\ta\"\u0003\u0002 \u001d\t!R*Y5oG\"\f\u0017N\u001c(pI\u0016\u001c\u0005.\u00198oK2\faa\u00197jK:$\bCA\u000f#\u0013\t\u0019cBA\nD_6lWO\\5dCRLwN\\\"mS\u0016tG/\u0001\u0004qCJ\fWn\u001d\t\u0003M!j\u0011a\n\u0006\u0003IAI!!K\u0014\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0019A&\f\u0018\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0004\u0001\u0004\t\u0003\"\u0002\u0013\u0004\u0001\u0004)\u0013\u0001E4fi\ncwnY6Cs\"+\u0017n\u001a5u)\t\tT\bE\u00023k]j\u0011a\r\u0006\u0003ia\tA!\u001e;jY&\u0011ag\r\u0002\u0004)JL\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0011\u0003\u0015\u0011Gn\\2l\u0013\ta\u0014HA\fNC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK\")a\b\u0002a\u0001\u007f\u00051\u0001.Z5hQR\u0004\"a\u0006!\n\u0005\u0005C\"aA%oi\u0006qq-\u001a;CY>\u001c7NQ=ICNDGCA\u0019E\u0011\u0015)U\u00011\u0001G\u0003\u0011A\u0017m\u001d5\u0011\u0005\u001dseB\u0001%M!\tI\u0005$D\u0001K\u0015\tYE#\u0001\u0004=e>|GOP\u0005\u0003\u001bb\ta\u0001\u0015:fI\u00164\u0017BA(Q\u0005\u0019\u0019FO]5oO*\u0011Q\nG\u0001\u001caJ|7-Z:t\u00052|7m\u001b*fgB|gn]3QCfdw.\u00193\u0015\u0005E\u001a\u0006\"\u0002+\u0007\u0001\u0004)\u0016A\u00024viV\u0014X\rE\u0002W3nk\u0011a\u0016\u0006\u00031b\t!bY8oGV\u0014(/\u001a8u\u0013\tQvK\u0001\u0004GkR,(/\u001a\t\u0003;qK!!\u0018\b\u0003)\tcwnY6SKN\u0004xN\\:f!\u0006LHn\\1e\u0003e9W\r\u001e\"m_\u000e\\\u0007*Y:iKN\fe\r^3s\u0011\u0016Lw\r\u001b;\u0015\u0007\u0001T7\u000eE\u00023k\u0005\u00042AY4G\u001d\t\u0019WM\u0004\u0002JI&\t\u0011$\u0003\u0002g1\u00059\u0001/Y2lC\u001e,\u0017B\u00015j\u0005\r\u0019V-\u001d\u0006\u0003MbAQAP\u0004A\u0002}BQ\u0001\\\u0004A\u0002}\nQ\u0001\\5nSR\fqcZ3u\u00052|7m\u001b%bg\",7/\u00114uKJD\u0015m\u001d5\u0015\u0007\u0001|\u0007\u000fC\u0003F\u0011\u0001\u0007a\tC\u0003m\u0011\u0001\u0007q(A\thKRtUm\u001e\"m_\u000e\\\u0007*Y:iKN$2a]<z!\r\u0011T\u0007\u001e\t\u0005/U|\u0014-\u0003\u0002w1\t1A+\u001e9mKJBQ\u0001_\u0005A\u0002\u0005\fQ\u0002\\8dCR|'\u000fS1tQ\u0016\u001c\b\"\u00027\n\u0001\u0004y\u0014AE4fi\n+7\u000f^\"p[6|g\u000eU8j]R$\"\u0001 @\u0011\u0007I*T\u0010\u0005\u0003\u0018k~2\u0005\"\u0002=\u000b\u0001\u0004\t\u0017!G:vEN\u001c'/\u001b2f\u001f:,\u0006\u000fZ1uKRK\u0007/\u0012<f]R$B!a\u0001\u0002\fA!!'NA\u0003!\r9\u0012qA\u0005\u0004\u0003\u0013A\"\u0001B+oSRDq!!\u0004\f\u0001\u0004\ty!A\u0004iC:$G.\u001a:\u0011\u0007u\t\t\"C\u0002\u0002\u00149\u0011qc\u00148Va\u0012\fG/\u001a+ja\u00163XM\u001c;IC:$G.\u001a:\u00027Ut7/\u001e2tGJL'-Z(o+B$\u0017\r^3USB,e/\u001a8u)\u0011\t)!!\u0007\t\u000f\u00055A\u00021\u0001\u0002\u0010\u0001")
public class MainchainNodeChannelImpl
implements MainchainNodeChannel {
    private final CommunicationClient client;
    private final NetworkParams params;

    @Override
    public Try<MainchainBlockReference> getBlockByHeight(int height) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockResponsePayload> future = $this.client.sendRequest(0, new GetBlockByHeightRequestPayload(height), BlockResponsePayload.class);
            return (MainchainBlockReference)this.processBlockResponsePayload(future).get();
        });
    }

    @Override
    public Try<MainchainBlockReference> getBlockByHash(String hash) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlockResponsePayload> future = $this.client.sendRequest(0, new GetBlockByHashRequestPayload(hash), BlockResponsePayload.class);
            return (MainchainBlockReference)this.processBlockResponsePayload(future).get();
        });
    }

    private Try<MainchainBlockReference> processBlockResponsePayload(Future<BlockResponsePayload> future) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BlockResponsePayload response = (BlockResponsePayload)Await$.MODULE$.result((Awaitable)future, (Duration)$this.client.requestTimeoutDuration());
            byte[] blockBytes = BytesUtils.fromHexString(response.block());
            return (MainchainBlockReference)MainchainBlockReference$.MODULE$.create(blockBytes, $this.params).get();
        });
    }

    @Override
    public Try<Seq<String>> getBlockHashesAfterHeight(int height, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlocksResponsePayload> future = $this.client.sendRequest(1, new GetBlocksAfterHeightRequestPayload(height, limit), BlocksResponsePayload.class);
            BlocksResponsePayload response = (BlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.hashes();
        });
    }

    @Override
    public Try<Seq<String>> getBlockHashesAfterHash(String hash, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<BlocksResponsePayload> future = $this.client.sendRequest(1, new GetBlocksAfterHashRequestPayload(hash, limit), BlocksResponsePayload.class);
            BlocksResponsePayload response = (BlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return response.hashes();
        });
    }

    @Override
    public Try<Tuple2<Object, Seq<String>>> getNewBlockHashes(Seq<String> locatorHashes, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Future<NewBlocksResponsePayload> future = $this.client.sendRequest(2, new GetNewBlocksRequestPayload(locatorHashes, limit), NewBlocksResponsePayload.class);
            NewBlocksResponsePayload response = (NewBlocksResponsePayload)Await$.MODULE$.result(future, (Duration)$this.client.requestTimeoutDuration());
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)response.height()), response.hashes());
        });
    }

    @Override
    public Try<Tuple2<Object, String>> getBestCommonPoint(Seq<String> locatorHashes) {
        Success success;
        Tuple2 tuple2;
        Try<Tuple2<Object, Seq<String>>> try_ = this.getNewBlockHashes(locatorHashes, 1);
        if (!(try_ instanceof Success) || (tuple2 = (Tuple2)(success = (Success)try_).value()) == null) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw ex;
            }
            throw new MatchError(try_);
        }
        int height = tuple2._1$mcI$sp();
        Seq hashes = (Seq)tuple2._2();
        Success success2 = new Success((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)height), hashes.head()));
        return success2;
    }

    @Override
    public Try<BoxedUnit> subscribeOnUpdateTipEvent(OnUpdateTipEventHandler handler) {
        return this.client.registerEventHandler(0, handler, OnUpdateTipEventPayload.class);
    }

    @Override
    public void unsubscribeOnUpdateTipEvent(OnUpdateTipEventHandler handler) {
        this.client.unregisterEventHandler(0, handler);
    }

    public MainchainNodeChannelImpl(CommunicationClient client, NetworkParams params) {
        this.client = client;
        this.params = params;
    }
}

