/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.websocket;

import com.horizen.WebSocketSettings;
import com.horizen.websocket.DisconnectionCode$;
import com.horizen.websocket.WebSocketReconnectionHandler;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import scala.Enumeration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scorex.util.ScorexLogging;

@ScalaSignature(bytes="\u0006\u0001A4AAC\u0006\u0001%!AQ\u0005\u0001B\u0001B\u0003%a\u0005C\u0003+\u0001\u0011\u00051\u0006C\u0004/\u0001\u0001\u0007I\u0011A\u0018\t\u000fM\u0002\u0001\u0019!C\u0001i!1!\b\u0001Q!\nABQa\u000f\u0001\u0005BqBQA\u0014\u0001\u0005B=CQ\u0001\u001a\u0001\u0005B\u0015DQA\u001c\u0001\u0005B=\u00141\u0005R3gCVdGoV3c'>\u001c7.\u001a;SK\u000e|gN\\3di&|g\u000eS1oI2,'O\u0003\u0002\r\u001b\u0005Iq/\u001a2t_\u000e\\W\r\u001e\u0006\u0003\u001d=\tq\u0001[8sSj,gNC\u0001\u0011\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011#G\u000f\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ2$D\u0001\f\u0013\ta2B\u0001\u000fXK\n\u001cvnY6fiJ+7m\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001B;uS2T\u0011AI\u0001\u0007g\u000e|'/\u001a=\n\u0005\u0011z\"!D*d_J,\u0007\u0010T8hO&tw-\u0001\u0003d_:4\u0007CA\u0014)\u001b\u0005i\u0011BA\u0015\u000e\u0005E9VMY*pG.,GoU3ui&twm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051j\u0003C\u0001\u000e\u0001\u0011\u0015)#\u00011\u0001'\u0003]ygnQ8o]\u0016\u001cGOR1jYV\u0014XmQ8v]R,'/F\u00011!\t!\u0012'\u0003\u00023+\t\u0019\u0011J\u001c;\u00027=t7i\u001c8oK\u000e$h)Y5mkJ,7i\\;oi\u0016\u0014x\fJ3r)\t)\u0004\b\u0005\u0002\u0015m%\u0011q'\u0006\u0002\u0005+:LG\u000fC\u0004:\t\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013'\u0001\rp]\u000e{gN\\3di\u001a\u000b\u0017\u000e\\;sK\u000e{WO\u001c;fe\u0002\n!c\u001c8D_:tWm\u0019;j_:4\u0015-\u001b7fIR\u0011Q\b\u0011\t\u0003)yJ!aP\u000b\u0003\u000f\t{w\u000e\\3b]\")\u0011I\u0002a\u0001\u0005\u0006)1-Y;tKB\u00111i\u0013\b\u0003\t&s!!\u0012%\u000e\u0003\u0019S!aR\t\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001&\u0016\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001T'\u0003\u0013QC'o\\<bE2,'B\u0001&\u0016\u0003=yg\u000eR5tG>tg.Z2uS>tGcA\u001fQ5\")\u0011k\u0002a\u0001%\u0006!1m\u001c3f!\t\u0019fK\u0004\u0002\u001b)&\u0011QkC\u0001\u0012\t&\u001c8m\u001c8oK\u000e$\u0018n\u001c8D_\u0012,\u0017BA,Y\u0005\u00151\u0016\r\\;f\u0013\tIVCA\u0006F]VlWM]1uS>t\u0007\"B.\b\u0001\u0004a\u0016A\u0002:fCN|g\u000e\u0005\u0002^C:\u0011al\u0018\t\u0003\u000bVI!\u0001Y\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u00117M\u0001\u0004TiJLgn\u001a\u0006\u0003AV\t\u0001bZ3u\t\u0016d\u0017-_\u000b\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\tIV\u0014\u0018\r^5p]*\u00111.F\u0001\u000bG>t7-\u001e:sK:$\u0018BA7i\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f1c\u001c8D_:tWm\u0019;j_:\u001cVoY2fgN$\u0012!\u000e")
public class DefaultWebSocketReconnectionHandler
implements WebSocketReconnectionHandler,
ScorexLogging {
    private final WebSocketSettings conf;
    private int onConnectFailureCounter;
    private final Logger logger;

    public Logger log() {
        return ScorexLogging.log$((ScorexLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int onConnectFailureCounter() {
        return this.onConnectFailureCounter;
    }

    public void onConnectFailureCounter_$eq(int x$1) {
        this.onConnectFailureCounter = x$1;
    }

    @Override
    public boolean onConnectionFailed(Throwable cause) {
        boolean bl;
        this.onConnectFailureCounter_$eq(this.onConnectFailureCounter() + 1);
        if (this.onConnectFailureCounter() <= this.conf.reconnectionMaxAttempts()) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder(45).append("onConnectFailure. Reconnecting... (attempt ").append(this.onConnectFailureCounter()).append(") ").append(cause.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onDisconnection(Enumeration.Value code, String reason) {
        BoxedUnit boxedUnit;
        this.onConnectFailureCounter_$eq(this.onConnectFailureCounter() + 1);
        if (this.onConnectFailureCounter() > this.conf.reconnectionMaxAttempts()) return false;
        Enumeration.Value value = code;
        Enumeration.Value value2 = DisconnectionCode$.MODULE$.ON_SUCCESS();
        if (value == null) {
            if (value2 == null) return false;
        } else if (value.equals(value2)) return false;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(40).append("onDisconnect. Reconnecting... (attempt ").append(this.onConnectFailureCounter()).append(")").toString());
            boxedUnit = BoxedUnit.UNIT;
            return true;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return true;
    }

    @Override
    public FiniteDuration getDelay() {
        return this.conf.reconnectionDelay();
    }

    @Override
    public void onConnectionSuccess() {
        this.onConnectFailureCounter_$eq(0);
    }

    public DefaultWebSocketReconnectionHandler(WebSocketSettings conf) {
        this.conf = conf;
        StrictLogging.$init$((StrictLogging)this);
        ScorexLogging.$init$((ScorexLogging)this);
        this.onConnectFailureCounter = 0;
    }
}

