/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.validation;

import com.horizen.SidechainHistory;
import com.horizen.block.MainchainBlockReferenceData;
import com.horizen.block.SidechainBlock;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.params.NetworkParams;
import com.horizen.transaction.MC2SCAggregatedTransaction;
import com.horizen.transaction.mainchain.SidechainCreation;
import com.horizen.utils.BytesUtils;
import com.horizen.utils.WithdrawalEpochInfo;
import com.horizen.utils.WithdrawalEpochUtils$;
import com.horizen.validation.HistoryBlockValidator;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scorex.util.package$;

@ScalaSignature(bytes="\u0006\u0001\t3AAB\u0004\u0001\u001d!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003$\u0001\u0011\u0005C\u0005C\u0003<\u0001\u0011%A\bC\u0003?\u0001\u0011%qH\u0001\rXSRDGM]1xC2,\u0005o\\2i-\u0006d\u0017\u000eZ1u_JT!\u0001C\u0005\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002\u000b\u0017\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001yQ\u0003\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-]i\u0011aB\u0005\u00031\u001d\u0011Q\u0003S5ti>\u0014\u0018P\u00117pG.4\u0016\r\\5eCR|'/\u0001\u0004qCJ\fWn\u001d\t\u00037ui\u0011\u0001\b\u0006\u00033%I!A\b\u000f\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u0003-\u0001AQ!\u0007\u0002A\u0002i\t\u0001B^1mS\u0012\fG/\u001a\u000b\u0004K9*\u0004c\u0001\u0014*W5\tqE\u0003\u0002)#\u0005!Q\u000f^5m\u0013\tQsEA\u0002Uef\u0004\"\u0001\u0005\u0017\n\u00055\n\"\u0001B+oSRDQaL\u0002A\u0002A\nQA\u00197pG.\u0004\"!M\u001a\u000e\u0003IR!aL\u0005\n\u0005Q\u0012$AD*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b\u0005\u0006m\r\u0001\raN\u0001\bQ&\u001cHo\u001c:z!\tA\u0014(D\u0001\n\u0013\tQ\u0014B\u0001\tTS\u0012,7\r[1j]\"K7\u000f^8ss\u0006!b/\u00197jI\u0006$XmR3oKNL7O\u00117pG.$\"!J\u001f\t\u000b=\"\u0001\u0019\u0001\u0019\u0002\u001bY\fG.\u001b3bi\u0016\u0014En\\2l)\r)\u0003)\u0011\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e")
public class WithdrawalEpochValidator
implements HistoryBlockValidator {
    private final NetworkParams params;

    @Override
    public Try<BoxedUnit> validate(SidechainBlock block, SidechainHistory history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (block.id().equals($this.params.sidechainGenesisBlockId())) {
                this.validateGenesisBlock(block).get();
            } else {
                this.validateBlock(block, history).get();
            }
        });
    }

    private Try<BoxedUnit> validateGenesisBlock(SidechainBlock block) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (block.mainchainBlockReferencesData().size() != 1) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block validation failed for %s: genesis block should contain single MC block reference.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
            }
            SidechainCreation sidechainCreation = (SidechainCreation)((MC2SCAggregatedTransaction)((MainchainBlockReferenceData)block.mainchainBlockReferencesData().head()).sidechainRelatedAggregatedTransaction().get()).mc2scTransactionsOutputs().get(0);
            if (sidechainCreation.withdrawalEpochLength() != $this.params.withdrawalEpochLength()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block validation failed for %s: genesis block contains different withdrawal epoch length than expected in configs.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
            }
        });
    }

    private Try<BoxedUnit> validateBlock(SidechainBlock block, SidechainHistory history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            block.mainchainBlockReferencesData().foreach((Function1 & Serializable & scala.Serializable)data -> {
                WithdrawalEpochValidator.$anonfun$validateBlock$2(block, data);
                return BoxedUnit.UNIT;
            });
            Option<SidechainBlockInfo> option = history.storage().blockInfoOptionById(block.parentId());
            if (option instanceof Some) {
                Some some = (Some)option;
                SidechainBlockInfo parentBlockInfo = (SidechainBlockInfo)some.value();
                WithdrawalEpochInfo blockEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(block, parentBlockInfo.withdrawalEpochInfo(), $this.params);
                if (blockEpochInfo.epoch() > parentBlockInfo.withdrawalEpochInfo().epoch()) {
                    if (parentBlockInfo.withdrawalEpochInfo().lastEpochIndex() != $this.params.withdrawalEpochLength()) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block %s contains MC Block references, that belong to different withdrawal epochs.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (blockEpochInfo.lastEpochIndex() == $this.params.withdrawalEpochLength() && block.transactions().nonEmpty()) {
                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block %s is the last withdrawal epoch block, but contains Sidechain Transactions.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block %s parent block is missed.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block.id()))})));
                }
                throw new MatchError(option);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            int backwardTransferCertificateCount = ((SeqLike)block.mainchainBlockReferencesData().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.withdrawalEpochCertificate()), Seq$.MODULE$.canBuildFrom())).size();
            if (backwardTransferCertificateCount > 1) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block must contain 0 or 1 backward transfer certificate, but contains %d certificates.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)backwardTransferCertificateCount)})));
            }
        });
    }

    public static final /* synthetic */ void $anonfun$validateBlock$2(SidechainBlock block$3, MainchainBlockReferenceData data) {
        Option<MC2SCAggregatedTransaction> option = data.sidechainRelatedAggregatedTransaction();
        if (option instanceof Some) {
            Some some = (Some)option;
            MC2SCAggregatedTransaction aggTx = (MC2SCAggregatedTransaction)some.value();
            if (aggTx.mc2scTransactionsOutputs().stream().anyMatch(output -> output instanceof SidechainCreation)) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Sidechain block validation failed for %s: non-genesis block contains Sidechain Creation output.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BytesUtils.toHexString(package$.MODULE$.idToBytes(block$3.id()))})));
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public WithdrawalEpochValidator(NetworkParams params) {
        this.params = params;
    }
}

