/*
 * Decompiled with CFR 0.152.
 */
package com.horizen.validation;

import com.horizen.SidechainHistory;
import com.horizen.block.MainchainBlockReference;
import com.horizen.block.MainchainBlockReferenceData;
import com.horizen.block.MainchainHeader;
import com.horizen.block.SidechainBlock;
import com.horizen.chain.SidechainBlockInfo;
import com.horizen.chain.package$;
import com.horizen.params.NetworkParams;
import com.horizen.utils.ByteArrayWrapper;
import com.horizen.validation.HistoryBlockValidator;
import com.horizen.validation.InvalidMainchainDataException;
import com.horizen.validation.InvalidMainchainDataException$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\r3AAB\u0004\u0001\u001d!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003$\u0001\u0011\u0005C\u0005C\u0003<\u0001\u0011%A\bC\u0003@\u0001\u0011%\u0001I\u0001\u0011NC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dKZ\u000bG.\u001b3bi>\u0014(B\u0001\u0005\n\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u0015-\tq\u0001[8sSj,gNC\u0001\r\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Y9R\"A\u0004\n\u0005a9!!\u0006%jgR|'/\u001f\"m_\u000e\\g+\u00197jI\u0006$xN]\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0005miR\"\u0001\u000f\u000b\u0005eI\u0011B\u0001\u0010\u001d\u00055qU\r^<pe.\u0004\u0016M]1ng\u00061A(\u001b8jiz\"\"!\t\u0012\u0011\u0005Y\u0001\u0001\"B\r\u0003\u0001\u0004Q\u0012\u0001\u0003<bY&$\u0017\r^3\u0015\u0007\u0015rS\u0007E\u0002'S-j\u0011a\n\u0006\u0003QE\tA!\u001e;jY&\u0011!f\n\u0002\u0004)JL\bC\u0001\t-\u0013\ti\u0013C\u0001\u0003V]&$\b\"B\u0018\u0004\u0001\u0004\u0001\u0014!\u00022m_\u000e\\\u0007CA\u00194\u001b\u0005\u0011$BA\u0018\n\u0013\t!$G\u0001\bTS\u0012,7\r[1j]\ncwnY6\t\u000bY\u001a\u0001\u0019A\u001c\u0002\u000f!L7\u000f^8ssB\u0011\u0001(O\u0007\u0002\u0013%\u0011!(\u0003\u0002\u0011'&$Wm\u00195bS:D\u0015n\u001d;pef\fAC^1mS\u0012\fG/Z$f]\u0016\u001c\u0018n\u001d\"m_\u000e\\GCA\u0016>\u0011\u0015qD\u00011\u00011\u000351XM]5gS\u0016$'\t\\8dW\u0006ia/\u00197jI\u0006$XM\u00117pG.$2aK!C\u0011\u0015qT\u00011\u00011\u0011\u00151T\u00011\u00018\u0001")
public class MainchainBlockReferenceValidator
implements HistoryBlockValidator {
    private final NetworkParams params;

    @Override
    public Try<BoxedUnit> validate(SidechainBlock block, SidechainHistory history) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (block.id().equals($this.params.sidechainGenesisBlockId())) {
                this.validateGenesisBlock(block);
            } else {
                this.validateBlock(block, history);
            }
        });
    }

    private void validateGenesisBlock(SidechainBlock verifiedBlock) {
        if (verifiedBlock.mainchainHeaders().size() != 1) {
            throw new InvalidMainchainDataException(new StringBuilder(74).append("Genesis block expect to contain only 1 MainchainHeader, instead contains ").append(verifiedBlock.mainchainHeaders().size()).append(".").toString(), InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
        }
        if (verifiedBlock.mainchainBlockReferencesData().size() != 1) {
            throw new InvalidMainchainDataException(new StringBuilder(86).append("Genesis block expect to contain only 1 MainchainBlockReferenceData, instead contains ").append(verifiedBlock.mainchainBlockReferencesData().size()).append(".").toString(), InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
        }
        MainchainBlockReference reference = new MainchainBlockReference((MainchainHeader)verifiedBlock.mainchainHeaders().head(), (MainchainBlockReferenceData)verifiedBlock.mainchainBlockReferencesData().head());
        Try<BoxedUnit> try_ = reference.semanticValidity(this.params);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void validateBlock(SidechainBlock verifiedBlock, SidechainHistory history) {
        if (verifiedBlock.mainchainBlockReferencesData().isEmpty()) {
            return;
        }
        ObjectRef missedMainchainReferenceDataHeaderHashesInfo = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef blockId = ObjectRef.create((Object)verifiedBlock.parentId());
            ObjectRef bestMainchainReferenceDataHeaderHashOpt = ObjectRef.create((Object)None$.MODULE$);
            while (true) {
                int index;
                SidechainBlockInfo blockInfo = history.blockInfoById((String)blockId.elem);
                missedMainchainReferenceDataHeaderHashesInfo$1.elem = (Seq)((TraversableLike)blockInfo.mainchainHeaderHashes().map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2((Object)x$1, (Object)((String)blockId$1.elem)), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((Seq)missedMainchainReferenceDataHeaderHashesInfo$1.elem), Seq$.MODULE$.canBuildFrom());
                if (((Option)bestMainchainReferenceDataHeaderHashOpt.elem).isEmpty()) {
                    bestMainchainReferenceDataHeaderHashOpt.elem = blockInfo.mainchainReferenceDataHeaderHashes().lastOption();
                }
                if (((Option)bestMainchainReferenceDataHeaderHashOpt.elem).isDefined() && (index = ((Seq)missedMainchainReferenceDataHeaderHashesInfo$1.elem).indexWhere((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReferenceValidator.$anonfun$validateBlock$3(bestMainchainReferenceDataHeaderHashOpt, info)))) != -1) {
                    missedMainchainReferenceDataHeaderHashesInfo$1.elem = (Seq)((Seq)missedMainchainReferenceDataHeaderHashesInfo$1.elem).drop(index + 1);
                    throw Breaks$.MODULE$.break();
                }
                blockId.elem = blockInfo.parentId();
            }
        });
        missedMainchainReferenceDataHeaderHashesInfo.elem = (Seq)((Seq)missedMainchainReferenceDataHeaderHashesInfo.elem).$plus$plus((GenTraversableOnce)verifiedBlock.mainchainHeaders().map((Function1 & Serializable & scala.Serializable)header -> new Tuple2((Object)package$.MODULE$.byteArrayToMainchainHeaderHash(header.hash()), (Object)verifiedBlock.id()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        if (verifiedBlock.mainchainBlockReferencesData().size() > ((Seq)missedMainchainReferenceDataHeaderHashesInfo.elem).size()) {
            throw new InvalidMainchainDataException("Block contains more MainchainBlockReferenceData, than expected in the chain.", InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
        }
        ((TraversableOnce)verifiedBlock.mainchainBlockReferencesData().zip((GenIterable)((Seq)missedMainchainReferenceDataHeaderHashesInfo.elem), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)verifiedBlock, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            SidechainBlock sidechainBlock;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            SidechainBlock lastRetrievedBlock = (SidechainBlock)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            MainchainBlockReferenceData referenceData = (MainchainBlockReferenceData)tuple22._1();
            Tuple2 tuple23 = (Tuple2)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            ByteArrayWrapper mainchainHeaderHash = (ByteArrayWrapper)((Object)((Object)tuple23._1()));
            String containingBlockId = (String)tuple23._2();
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(referenceData.headerHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(mainchainHeaderHash.data()))) {
                throw new InvalidMainchainDataException("MainchainBlockReferenceData header hash and MainchainHeader hash are different.", InvalidMainchainDataException$.MODULE$.$lessinit$greater$default$2());
            }
            String string = containingBlockId;
            String string2 = lastRetrievedBlock.id();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                sidechainBlock = lastRetrievedBlock;
            } else {
                String string4 = verifiedBlock.id();
                String string5 = string;
                sidechainBlock = !(string4 != null ? !string4.equals(string5) : string5 != null) ? verifiedBlock : history.getBlockById(string).get();
            }
            SidechainBlock blockWithMainchainHeader = sidechainBlock;
            MainchainHeader mainchainHeader = (MainchainHeader)blockWithMainchainHeader.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReferenceValidator.$anonfun$validateBlock$6(mainchainHeaderHash, header))).get();
            MainchainBlockReference reference = new MainchainBlockReference(mainchainHeader, referenceData);
            Try<BoxedUnit> try_ = reference.semanticValidity($this.params);
            if (!(try_ instanceof Success)) {
                if (!(try_ instanceof Failure)) throw new MatchError(try_);
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw e;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return blockWithMainchainHeader;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateBlock$3(ObjectRef bestMainchainReferenceDataHeaderHashOpt$1, Tuple2 info) {
        return BoxesRunTime.equals((Object)info._1(), (Object)((Option)bestMainchainReferenceDataHeaderHashOpt$1.elem).get());
    }

    public static final /* synthetic */ boolean $anonfun$validateBlock$6(ByteArrayWrapper mainchainHeaderHash$1, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.hash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(mainchainHeaderHash$1.data()));
    }

    public MainchainBlockReferenceValidator(NetworkParams params) {
        this.params = params;
    }
}

